/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.impl.indexing;

import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.parsing.spi.indexing.PathRecognizer;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PathRecognizerRegistry {
    private static final Logger LOG = Logger.getLogger(PathRecognizerRegistry.class.getName());
    private static PathRecognizerRegistry instance;
    private final Lookup.Result<? extends PathRecognizer> lookupResult;
    private final LookupListener tracker = new LookupListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resultChanged(LookupEvent lookupEvent) {
            LOG.fine("resultChanged: reseting cached PathRecognizers");
            PathRecognizerRegistry pathRecognizerRegistry = PathRecognizerRegistry.this;
            synchronized (pathRecognizerRegistry) {
                PathRecognizerRegistry.access$102(PathRecognizerRegistry.this, null);
            }
        }
    };
    private Object[] cachedData;

    public static synchronized PathRecognizerRegistry getDefault() {
        if (instance == null) {
            instance = new PathRecognizerRegistry();
        }
        return instance;
    }

    public Set<String> getSourceIds() {
        Object[] objectArray = this.getData();
        return (Set)objectArray[0];
    }

    public Set<String> getLibraryIds() {
        Object[] objectArray = this.getData();
        return (Set)objectArray[1];
    }

    public Set<String> getBinaryLibraryIds() {
        Object[] objectArray = this.getData();
        return (Set)objectArray[2];
    }

    public Set<String> getMimeTypes() {
        Object[] objectArray = this.getData();
        return (Set)objectArray[3];
    }

    public Set<String> getLibraryIdsForSourceId(String string) {
        Object[] objectArray = this.getData();
        Set[] setArray = (Set[])((Map)objectArray[4]).get(string);
        return setArray != null ? setArray[0] : Collections.emptySet();
    }

    public Set<String> getBinaryLibraryIdsForSourceId(String string) {
        Object[] objectArray = this.getData();
        Set[] setArray = (Set[])((Map)objectArray[4]).get(string);
        return setArray != null ? setArray[1] : Collections.emptySet();
    }

    public Set<String> getLibraryIdsForLibraryId(String string) {
        Object[] objectArray = this.getData();
        Set[] setArray = (Set[])((Map)objectArray[5]).get(string);
        return setArray != null ? setArray[0] : Collections.emptySet();
    }

    public Set<String> getBinaryLibraryIdsForLibraryId(String string) {
        Object[] objectArray = this.getData();
        Set[] setArray = (Set[])((Map)objectArray[5]).get(string);
        return setArray != null ? setArray[1] : Collections.emptySet();
    }

    public Set<String> getSourceIdsForBinaryLibraryId(String string) {
        Object[] objectArray = this.getData();
        Set[] setArray = (Set[])((Map)objectArray[6]).get(string);
        return setArray != null ? setArray[0] : Collections.emptySet();
    }

    public Set<String> getMimeTypesForSourceId(String string) {
        Object[] objectArray = this.getData();
        Set[] setArray = (Set[])((Map)objectArray[4]).get(string);
        return setArray != null ? setArray[2] : Collections.emptySet();
    }

    public Set<String> getMimeTypesForLibraryId(String string) {
        Object[] objectArray = this.getData();
        Set[] setArray = (Set[])((Map)objectArray[5]).get(string);
        return setArray != null ? setArray[2] : Collections.emptySet();
    }

    public Set<String> getMimeTypesForBinaryLibraryId(String string) {
        Object[] objectArray = this.getData();
        Set[] setArray = (Set[])((Map)objectArray[6]).get(string);
        return setArray != null ? setArray[2] : Collections.emptySet();
    }

    private PathRecognizerRegistry() {
        this.lookupResult = Lookup.getDefault().lookupResult(PathRecognizer.class);
        this.lookupResult.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this.tracker, this.lookupResult));
    }

    private synchronized Object[] getData() {
        if (this.cachedData == null) {
            HashSet<String> hashSet = new HashSet<String>();
            HashSet<String> hashSet2 = new HashSet<String>();
            HashSet<String> hashSet3 = new HashSet<String>();
            HashSet<String> hashSet4 = new HashSet<String>();
            HashMap<String, Set[]> hashMap = new HashMap<String, Set[]>();
            HashMap<String, Set[]> hashMap2 = new HashMap<String, Set[]>();
            HashMap<String, Set[]> hashMap3 = new HashMap<String, Set[]>();
            Collection collection = this.lookupResult.allInstances();
            for (PathRecognizer pathRecognizer : collection) {
                Set[] setArray;
                Set<String> set = pathRecognizer.getSourcePathIds();
                Set<String> set2 = pathRecognizer.getLibraryPathIds();
                Set<String> set3 = pathRecognizer.getBinaryLibraryPathIds();
                Set<String> set4 = pathRecognizer.getMimeTypes();
                if (set != null) {
                    hashSet.addAll(set);
                    for (String string : set) {
                        if (hashMap.containsKey(string)) continue;
                        setArray = new Set[]{set2 == null ? Collections.emptySet() : Collections.unmodifiableSet(set2), set3 == null ? Collections.emptySet() : Collections.unmodifiableSet(set3), set4 == null ? Collections.emptySet() : Collections.unmodifiableSet(set4)};
                        hashMap.put(string, setArray);
                    }
                }
                if (set2 != null) {
                    hashSet2.addAll(set2);
                    for (String string : set2) {
                        if (hashMap2.containsKey(string)) continue;
                        setArray = new Set[]{set2 == null ? Collections.emptySet() : Collections.unmodifiableSet(set2), set3 == null ? Collections.emptySet() : Collections.unmodifiableSet(set3), set4 == null ? Collections.emptySet() : Collections.unmodifiableSet(set4)};
                        hashMap2.put(string, setArray);
                    }
                }
                if (set3 != null) {
                    hashSet3.addAll(set3);
                    for (String string : set3) {
                        if (hashMap3.containsKey(string)) continue;
                        setArray = new Set[]{set == null ? Collections.emptySet() : Collections.unmodifiableSet(set), set2 == null ? Collections.emptySet() : Collections.unmodifiableSet(set2), set4 == null ? Collections.emptySet() : Collections.unmodifiableSet(set4)};
                        hashMap3.put(string, setArray);
                    }
                }
                if (set4 != null) {
                    hashSet4.addAll(set4);
                }
                LOG.log(Level.FINE, "PathRecognizer {0} supplied sids={1}, lids={2}, blids={3}, mts={4}", new Object[]{pathRecognizer.toString(), set, set2, set3, set4});
            }
            this.cachedData = new Object[]{Collections.unmodifiableSet(hashSet), Collections.unmodifiableSet(hashSet2), Collections.unmodifiableSet(hashSet3), Collections.unmodifiableSet(hashSet4), Collections.unmodifiableMap(hashMap), Collections.unmodifiableMap(hashMap2), Collections.unmodifiableMap(hashMap3)};
        }
        return this.cachedData;
    }

    static /* synthetic */ Object[] access$102(PathRecognizerRegistry pathRecognizerRegistry, Object[] objectArray) {
        pathRecognizerRegistry.cachedData = objectArray;
        return objectArray;
    }
}

