/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.tasklist;

import java.awt.event.ActionListener;
import java.net.URL;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import org.netbeans.modules.tasklist.trampoline.Accessor;
import org.netbeans.modules.tasklist.trampoline.TaskGroup;
import org.netbeans.modules.tasklist.trampoline.TaskGroupFactory;
import org.netbeans.spi.tasklist.AccessorImpl;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Task {
    private final URL url;
    private final FileObject file;
    private final TaskGroup group;
    private final String description;
    private final int line;
    private final ActionListener defaultAction;
    private final Action[] actions;
    private static Set<String> unknownTaskGroups;

    public static Task create(URL uRL, String string, String string2) {
        return new Task(null, uRL, Task.getTaskGroup(string), string2, -1, null, null);
    }

    public static Task create(URL uRL, String string, String string2, ActionListener actionListener, Action[] actionArray) {
        return new Task(null, uRL, Task.getTaskGroup(string), string2, -1, actionListener, actionArray);
    }

    public static Task create(FileObject fileObject, String string, String string2, int n) {
        assert (null != fileObject);
        return new Task(fileObject, null, Task.getTaskGroup(string), string2, n, null, null);
    }

    public static Task create(FileObject fileObject, String string, String string2, ActionListener actionListener) {
        assert (null != fileObject);
        return new Task(fileObject, null, Task.getTaskGroup(string), string2, -1, actionListener, null);
    }

    private Task(FileObject fileObject, URL uRL, TaskGroup taskGroup, String string, int n, ActionListener actionListener, Action[] actionArray) {
        assert (null != taskGroup);
        assert (null != string);
        assert (null == fileObject || null == uRL);
        this.file = fileObject;
        this.url = uRL;
        this.group = taskGroup;
        this.description = string;
        this.line = n;
        this.defaultAction = actionListener;
        this.actions = actionArray;
    }

    URL getURL() {
        return this.url;
    }

    FileObject getFile() {
        return this.file;
    }

    TaskGroup getGroup() {
        return this.group;
    }

    String getDescription() {
        return this.description;
    }

    int getLine() {
        return this.line;
    }

    ActionListener getDefaultAction() {
        return this.defaultAction;
    }

    Action[] getActions() {
        return this.actions;
    }

    static TaskGroup createGroup(Map<String, String> map) {
        return TaskGroupFactory.create(map);
    }

    private static TaskGroup getTaskGroup(String string) {
        TaskGroup taskGroup = TaskGroupFactory.getDefault().getGroup(string);
        if (null == taskGroup) {
            if (null == unknownTaskGroups || !unknownTaskGroups.contains(string)) {
                Logger.getLogger(Task.class.getName()).log(Level.INFO, NbBundle.getMessage(Task.class, (String)"Err_UnknownGroupName"), string);
                if (null == unknownTaskGroups) {
                    unknownTaskGroups = new HashSet<String>(10);
                }
                unknownTaskGroups.add(string);
            }
            taskGroup = TaskGroupFactory.getDefault().getDefaultGroup();
        }
        return taskGroup;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Task task = (Task)object;
        if (this.line != task.line) {
            return false;
        }
        if (this.description != task.description && this.description != null && !this.description.equals(task.description)) {
            return false;
        }
        if (this.group != task.group && this.group != null && !this.group.equals(task.group)) {
            return false;
        }
        if (this.url != task.url && this.url != null && !this.url.equals(task.url)) {
            return false;
        }
        return this.file == task.file || this.file == null || this.file.equals(task.file);
    }

    public int hashCode() {
        int n = 7;
        n = 17 * n + this.line;
        n = 17 * n + (this.description != null ? this.description.hashCode() : 0);
        n = 17 * n + (this.group != null ? this.group.hashCode() : 0);
        n = 17 * n + (this.file != null ? this.file.hashCode() : 0);
        n = 17 * n + (this.url != null ? this.url.hashCode() : 0);
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        stringBuffer.append(null == this.url ? this.getFile() : this.getURL());
        stringBuffer.append(", ");
        stringBuffer.append(this.getLine());
        stringBuffer.append(", ");
        stringBuffer.append(this.getDescription());
        stringBuffer.append(", ");
        stringBuffer.append(this.getGroup());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    static {
        Accessor.DEFAULT = new AccessorImpl();
    }
}

