/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit.output.antutils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tools.ant.module.spi.TaskStructure;
import org.netbeans.modules.junit.output.antutils.AntProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PatternSet {
    private final AntProject project;
    private Collection<String> includePatterns;
    private Collection<String> excludePatterns;

    PatternSet(AntProject antProject) {
        this.project = antProject;
    }

    void handleChildrenAndAttrs(TaskStructure taskStructure) {
        this.setAttrs(taskStructure);
        for (TaskStructure taskStructure2 : taskStructure.getChildren()) {
            Object object;
            String string = taskStructure2.getName();
            if (string.equals("include")) {
                object = new Entry();
                ((Entry)object).handleChildrenAndAttrs(taskStructure2);
                if (!((Entry)object).isApplicable()) continue;
                this.addIncludePatterns(((Entry)object).getPattern());
                continue;
            }
            if (string.equals("exclude")) {
                object = new Entry();
                ((Entry)object).handleChildrenAndAttrs(taskStructure2);
                if (!((Entry)object).isApplicable()) continue;
                this.addExcludePatterns(((Entry)object).getPattern());
                continue;
            }
            if (string.equals("includesfile")) {
                object = new Entry();
                ((Entry)object).handleChildrenAndAttrs(taskStructure2);
                if (!((Entry)object).isApplicable()) continue;
                this.addIncludePatterns(this.project.resolveFile(((Entry)object).getPattern()));
                continue;
            }
            if (string.equals("excludesfile")) {
                object = new Entry();
                ((Entry)object).handleChildrenAndAttrs(taskStructure2);
                if (!((Entry)object).isApplicable()) continue;
                this.addExcludePatterns(this.project.resolveFile(((Entry)object).getPattern()));
                continue;
            }
            if (!string.equals("patternset")) continue;
            object = new PatternSet(this.project);
            ((PatternSet)object).handleChildrenAndAttrs(taskStructure2);
            this.addPatternSet((PatternSet)object);
        }
    }

    Collection<String> getIncludePatterns() {
        if (this.includePatterns != null) {
            return this.includePatterns;
        }
        return Collections.emptyList();
    }

    Collection<String> getExcludePatterns() {
        if (this.excludePatterns != null) {
            return this.excludePatterns;
        }
        return Collections.emptyList();
    }

    private void setAttrs(TaskStructure taskStructure) {
        String string = taskStructure.getAttribute("includes");
        String string2 = taskStructure.getAttribute("includesFile");
        String string3 = taskStructure.getAttribute("excludes");
        String string4 = taskStructure.getAttribute("excludesFile");
        if (string != null) {
            this.addIncludePatterns(this.project.replaceProperties(string));
        }
        if (string3 != null) {
            this.addExcludePatterns(this.project.replaceProperties(string3));
        }
        if (string2 != null) {
            this.addIncludePatterns(this.project.resolveFile(this.project.replaceProperties(string2)));
        }
        if (string4 != null) {
            this.addExcludePatterns(this.project.resolveFile(this.project.replaceProperties(string4)));
        }
    }

    private void addIncludePatterns(String string) {
        if (this.includePatterns == null) {
            this.includePatterns = new ArrayList<String>();
        }
        this.addPatterns(string, this.includePatterns);
    }

    private void addExcludePatterns(String string) {
        if (this.excludePatterns == null) {
            this.excludePatterns = new ArrayList<String>();
        }
        this.addPatterns(string, this.excludePatterns);
    }

    private void addIncludePatterns(File file) {
        if (this.includePatterns == null) {
            this.includePatterns = new ArrayList<String>();
        }
        this.readPatterns(file, this.includePatterns);
    }

    private void addExcludePatterns(File file) {
        if (this.excludePatterns == null) {
            this.excludePatterns = new ArrayList<String>();
        }
        this.readPatterns(file, this.excludePatterns);
    }

    private void addPatterns(String string, Collection<String> collection) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
        while (stringTokenizer.hasMoreTokens()) {
            collection.add(stringTokenizer.nextToken());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readPatterns(File file, Collection<String> collection) {
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
            String string = bufferedReader.readLine();
            while (string != null) {
                if (string.length() == 0) continue;
                this.addPatterns(this.project.replaceProperties(string), collection);
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, "failed to read Ant patterns file " + file.getAbsolutePath(), iOException);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void addPatternSet(PatternSet patternSet) {
        if (patternSet.includePatterns != null) {
            if (this.includePatterns != null) {
                this.includePatterns.addAll(patternSet.includePatterns);
            } else {
                this.includePatterns = patternSet.includePatterns;
            }
        }
        if (patternSet.excludePatterns != null) {
            if (this.excludePatterns != null) {
                this.excludePatterns.addAll(patternSet.excludePatterns);
            } else {
                this.excludePatterns = patternSet.excludePatterns;
            }
        }
    }

    class Entry {
        private String pattern;
        private String ifCondition;
        private String unlessCondition;

        Entry() {
        }

        void handleChildrenAndAttrs(TaskStructure taskStructure) {
            this.setAttrs(taskStructure);
        }

        private void setAttrs(TaskStructure taskStructure) {
            this.pattern = taskStructure.getAttribute("name");
            this.ifCondition = taskStructure.getAttribute("if");
            this.unlessCondition = taskStructure.getAttribute("unless");
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        boolean isApplicable() {
            if (this.ifCondition != null) {
                PatternSet.this.project;
                if (!AntProject.toBoolean(PatternSet.this.project.replaceProperties(this.ifCondition))) return false;
            }
            if (this.unlessCondition == null) return true;
            PatternSet.this.project;
            if (AntProject.toBoolean(PatternSet.this.project.replaceProperties(this.unlessCondition))) return false;
            return true;
        }

        String getPattern() {
            return PatternSet.this.project.replaceProperties(this.pattern);
        }
    }
}

