/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.support.filesearch.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.CancellationException;
import java.util.logging.Level;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.support.Logger;
import org.netbeans.modules.nativeexecution.support.filesearch.FileSearchParams;
import org.netbeans.modules.nativeexecution.support.filesearch.FileSearcher;

public final class LocalFileSearcherImpl
implements FileSearcher {
    private static final java.util.logging.Logger log = Logger.getInstance();

    public final String searchFile(FileSearchParams fileSearchParams) {
        Object object;
        ExecutionEnvironment executionEnvironment = fileSearchParams.getExecEnv();
        if (!executionEnvironment.isLocal()) {
            return null;
        }
        log.fine("File Searching Task: " + fileSearchParams.toString() + "...");
        ArrayList<String> arrayList = new ArrayList<String>(fileSearchParams.getSearchPaths());
        if (fileSearchParams.isSearchInUserPaths()) {
            try {
                object = HostInfoUtils.getHostInfo(executionEnvironment);
                arrayList.addAll(Arrays.asList(object.getPath().split(File.pathSeparator)));
            }
            catch (IOException iOException) {
            }
            catch (CancellationException cancellationException) {
                // empty catch block
            }
        }
        object = fileSearchParams.getFilename();
        for (String string : arrayList) {
            try {
                File file = new File(string, (String)object);
                log.fine("   Test '" + file.toString() + "'");
                if (!file.canRead()) continue;
                log.fine("   FOUND '" + file.toString() + "'");
                return file.getCanonicalPath();
            }
            catch (Throwable throwable) {
                log.log(Level.FINE, "Execption in LocalFileSearcherImpl:", throwable);
            }
        }
        return null;
    }
}

