/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.support;

import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import org.netbeans.modules.nativeexecution.support.Computable;
import org.netbeans.modules.nativeexecution.support.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TasksCachedProcessor<P, R>
implements Computable<P, R> {
    private static final java.util.logging.Logger log = Logger.getInstance();
    private final ConcurrentMap<P, Future<R>> cache = new ConcurrentHashMap<P, Future<R>>();
    private final Computable<P, R> computable;
    private final boolean removeOnCompletion;

    public TasksCachedProcessor(Computable<P, R> computable, boolean bl) {
        this.computable = computable;
        this.removeOnCompletion = bl;
    }

    public boolean isResultAvailable(P p) {
        Future future = (Future)this.cache.get(p);
        if (future == null) {
            return false;
        }
        return future.isDone() && !future.isCancelled();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public R compute(final P p) throws InterruptedException {
        Object object;
        FutureTask futureTask;
        FutureTask futureTask2 = (FutureTask)this.cache.get(p);
        if (futureTask2 == null && (futureTask2 = (Future)this.cache.putIfAbsent(p, futureTask = new FutureTask(object = new Callable<R>(){

            @Override
            public R call() throws InterruptedException {
                return TasksCachedProcessor.this.computable.compute(p);
            }
        }))) == null) {
            futureTask2 = futureTask;
            futureTask.run();
        }
        try {
            try {
                object = futureTask2.get();
                Object var6_7 = null;
                if (!this.removeOnCompletion) return (R)object;
                this.cache.remove(p, futureTask2);
                return (R)object;
            }
            catch (InterruptedException interruptedException) {
                this.cache.remove(p, futureTask2);
                throw new CancellationException(interruptedException.getMessage());
            }
            catch (Throwable throwable) {
                this.cache.remove(p, futureTask2);
                if (!log.isLoggable(Level.FINE)) throw new CancellationException(throwable.getMessage());
                log.log(Level.FINE, "TasksCachedProcessor: exception while task execution:", throwable);
                throw new CancellationException(throwable.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (!this.removeOnCompletion) throw throwable;
            this.cache.remove(p, futureTask2);
            throw throwable;
        }
    }

    public void remove(P p) {
        Future future = (Future)this.cache.get(p);
        if (future != null && !future.isDone()) {
            future.cancel(true);
        }
        this.cache.remove(p);
    }

    public void resetCache() {
        this.cache.clear();
    }
}

