/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.support;

import java.io.File;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.Signal;

public class SignalSupport {
    private final NativeProcessBuilder npb;
    private final String[] args = new String[2];
    private final boolean useShell;
    private int last_pid = -1;
    private Signal last_signal = null;

    public SignalSupport(ExecutionEnvironment executionEnvironment) {
        String string = null;
        boolean bl = false;
        try {
            HostInfo hostInfo = HostInfoUtils.getHostInfo(executionEnvironment);
            String string2 = hostInfo.getShell();
            if (hostInfo.getOSFamily() == HostInfo.OSFamily.WINDOWS) {
                File file = new File(new File(string2).getParentFile(), "kill.exe");
                if (file.exists()) {
                    string = file.getAbsolutePath();
                } else {
                    string = string2;
                    this.args[0] = "-c";
                    bl = true;
                }
            } else {
                string = "/bin/kill";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.useShell = bl;
        if (string != null) {
            this.npb = NativeProcessBuilder.newProcessBuilder(executionEnvironment);
            this.npb.setExecutable(string);
        } else {
            this.npb = null;
        }
    }

    public synchronized int kill(Signal signal, int n) {
        if (this.npb == null) {
            return -1;
        }
        if (this.last_pid != n || this.last_signal != signal) {
            this.last_pid = n;
            this.last_signal = signal;
            if (this.useShell) {
                this.args[1] = "kill -" + (signal == Signal.NULL ? "0" : signal.name().substring(3)) + " " + n;
            } else {
                this.args[0] = signal == Signal.NULL ? "-0" : "-" + signal.name().substring(3);
                this.args[1] = Integer.toString(n);
            }
            this.npb.setArguments(this.args);
        }
        int n2 = -1;
        try {
            NativeProcess nativeProcess = this.npb.call();
            n2 = nativeProcess.waitFor();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n2;
    }
}

