/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution;

import com.sun.jna.Pointer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.logging.Level;
import org.netbeans.modules.nativeexecution.AbstractNativeProcess;
import org.netbeans.modules.nativeexecution.NativeProcessInfo;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.MacroMap;
import org.netbeans.modules.nativeexecution.api.util.UnbufferSupport;
import org.netbeans.modules.nativeexecution.api.util.WindowsSupport;
import org.netbeans.modules.nativeexecution.support.EnvWriter;
import org.netbeans.modules.nativeexecution.support.Win32APISupport;
import org.openide.util.NbBundle;

public final class LocalNativeProcess
extends AbstractNativeProcess {
    private Process process = null;
    private InputStream processOutput = null;
    private OutputStream processInput = null;
    private InputStream processError = null;

    public LocalNativeProcess(NativeProcessInfo nativeProcessInfo) {
        super(nativeProcessInfo);
    }

    protected void create() throws Throwable {
        boolean bl = this.hostInfo.getOSFamily() == HostInfo.OSFamily.WINDOWS;
        try {
            if (bl) {
                this.createWin();
            } else {
                this.createNonWin();
            }
        }
        catch (Throwable throwable) {
            String string = (throwable.getMessage() == null ? throwable.toString() : throwable.getMessage()) + "\n";
            this.processOutput = new ByteArrayInputStream(new byte[0]);
            this.processError = new ByteArrayInputStream(string.getBytes());
            this.processInput = new ByteArrayOutputStream();
            throw throwable;
        }
    }

    private void createNonWin() throws IOException, InterruptedException {
        Object object;
        MacroMap macroMap = this.info.getEnvironment().clone();
        if (this.info.isUnbuffer()) {
            UnbufferSupport.initUnbuffer(this.info.getExecutionEnvironment(), macroMap);
        }
        macroMap.appendPathVariable("PATH", "/bin:/usr/bin:" + this.hostInfo.getPath());
        ProcessBuilder processBuilder = new ProcessBuilder(this.hostInfo.getShell(), "-s");
        String string = this.info.getWorkingDirectory(true);
        if (string != null && ((File)(object = new File(string))).exists()) {
            processBuilder.directory((File)object);
        }
        if (this.isInterrupted()) {
            throw new InterruptedException();
        }
        this.process = processBuilder.start();
        this.processInput = this.process.getOutputStream();
        this.processError = this.process.getErrorStream();
        this.processOutput = this.process.getInputStream();
        this.processInput.write("echo $$\n".getBytes());
        this.processInput.flush();
        object = new EnvWriter(this.processInput);
        ((EnvWriter)object).write(macroMap);
        if (this.info.getInitialSuspend()) {
            this.processInput.write("ITS_TIME_TO_START=\n".getBytes());
            this.processInput.write("trap 'ITS_TIME_TO_START=1' CONT\n".getBytes());
            this.processInput.write("while [ -z \"$ITS_TIME_TO_START\" ]; do sleep 1; done\n".getBytes());
        }
        this.processInput.write(("exec " + this.info.getCommandLineForShell() + "\n").getBytes());
        this.processInput.flush();
        this.creation_ts = System.nanoTime();
        this.readPID(this.processOutput);
    }

    private void createWinUsingShell() throws IOException, InterruptedException {
        String string = this.info.getWorkingDirectory(true);
        if (string != null) {
            string = new File(string).getAbsolutePath();
        }
        MacroMap macroMap = this.info.getEnvironment().clone();
        if (this.info.isUnbuffer()) {
            UnbufferSupport.initUnbuffer(this.info.getExecutionEnvironment(), macroMap);
        }
        macroMap.put("PATH", "/bin:" + WindowsSupport.getInstance().convertToAllShellPaths(macroMap.get("PATH")));
        ProcessBuilder processBuilder = new ProcessBuilder(this.hostInfo.getShell(), "-s");
        if (this.isInterrupted()) {
            throw new InterruptedException();
        }
        this.process = processBuilder.start();
        this.processInput = this.process.getOutputStream();
        this.processError = this.process.getErrorStream();
        this.processOutput = this.process.getInputStream();
        this.processInput.write("echo $$\n".getBytes());
        this.processInput.flush();
        EnvWriter envWriter = new EnvWriter(this.processInput);
        envWriter.write(macroMap);
        if (string != null) {
            this.processInput.write(("cd \"" + WindowsSupport.getInstance().convertToShellPath(string) + "\"\n").getBytes());
        }
        this.processInput.write(("exec " + this.info.getCommandLineForShell() + "\n").getBytes());
        this.processInput.flush();
        this.creation_ts = System.nanoTime();
        this.readPID(this.processOutput);
    }

    private void createWin() throws IOException, InterruptedException {
        Object object;
        Object object2;
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        MacroMap macroMap = MacroMap.forExecEnv(ExecutionEnvironmentFactory.getLocal());
        macroMap.putAll(processBuilder.environment());
        macroMap.putAll(this.info.getEnvironment());
        if (this.isInterrupted()) {
            throw new InterruptedException();
        }
        if (this.hostInfo.getShell() != null) {
            macroMap.appendPathVariable("PATH", new File(this.hostInfo.getShell()).getParent());
        }
        if (this.info.isUnbuffer()) {
            UnbufferSupport.initUnbuffer(this.info.getExecutionEnvironment(), macroMap);
        }
        processBuilder.environment().clear();
        Object object3 = macroMap.entrySet().iterator();
        while (object3.hasNext()) {
            object2 = object3.next();
            processBuilder.environment().put(object2.getKey(), object2.getValue());
        }
        processBuilder.command(this.info.getCommand());
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest(String.format("Command: %s", this.info.getCommand()));
        }
        if ((object3 = this.info.getWorkingDirectory(true)) != null) {
            object2 = new File((String)object3);
            if (!((File)object2).exists()) {
                throw new IOException(LocalNativeProcess.loc("NativeProcess.noSuchDirectoryError.text", ((File)object2).getAbsolutePath()));
            }
            processBuilder.directory((File)object2);
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(String.format("Working directory: %s", object3));
            }
        }
        this.process = processBuilder.start();
        this.creation_ts = System.nanoTime();
        this.processInput = this.process.getOutputStream();
        this.processError = this.process.getErrorStream();
        this.processOutput = this.process.getInputStream();
        int n = 12345;
        try {
            object = this.process.getClass().getName();
            if ("java.lang.Win32Process".equals(object) || "java.lang.ProcessImpl".equals(object)) {
                Field field = this.process.getClass().getDeclaredField("handle");
                field.setAccessible(true);
                long l = field.getLong(this.process);
                Win32APISupport win32APISupport = Win32APISupport.instance;
                Win32APISupport.HANDLE hANDLE = new Win32APISupport.HANDLE();
                hANDLE.setPointer(Pointer.createConstant((long)l));
                n = win32APISupport.GetProcessId(hANDLE);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        object = new ByteArrayInputStream(("" + n).getBytes());
        this.readPID((InputStream)object);
    }

    public OutputStream getOutputStream() {
        return this.processInput;
    }

    public InputStream getInputStream() {
        return this.processOutput;
    }

    public InputStream getErrorStream() {
        return this.processError;
    }

    public final int waitResult() throws InterruptedException {
        if (this.process == null) {
            throw new InterruptedException();
        }
        int n = -1;
        while (true) {
            Thread.sleep(200L);
            try {
                n = this.process.exitValue();
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                continue;
            }
            break;
        }
        return n;
    }

    protected final synchronized void cancel() {
        if (this.process != null) {
            this.process.destroy();
        }
    }

    private static String loc(String string, String ... stringArray) {
        return NbBundle.getMessage(LocalNativeProcess.class, (String)string, (Object[])stringArray);
    }
}

