/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common.breakpoints;

import org.netbeans.modules.cnd.debugger.common.breakpoints.CndBreakpoint;
import org.openide.util.NbBundle;

public class AddressBreakpoint
extends CndBreakpoint
implements Comparable {
    public static final String PROP_ADDRESS_VALUE = "address";
    public static final String PROP_REFRESH = "refresh";
    private String address;

    private AddressBreakpoint(String string) {
        this.address = string;
    }

    public static AddressBreakpoint create(String string) {
        AddressBreakpoint addressBreakpoint = new AddressBreakpoint(string);
        addressBreakpoint.setPrintText(NbBundle.getBundle(AddressBreakpoint.class).getString("CTL_Address_Breakpoint_Print_Text"));
        return addressBreakpoint;
    }

    public String getAddress() {
        return this.address;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAddress(String string) {
        String string2;
        AddressBreakpoint addressBreakpoint = this;
        synchronized (addressBreakpoint) {
            if (string.equals(this.address)) {
                return;
            }
            string2 = this.address;
            this.address = string;
        }
        this.firePropertyChange(PROP_ADDRESS_VALUE, string2, string);
    }

    public int getLineNumber() {
        return 1;
    }

    public String toString() {
        return "AddressBreakpoint " + this.address;
    }

    public void refresh() {
        this.firePropertyChange(PROP_REFRESH, null, null);
    }

    public int compareTo(Object object) {
        if (object instanceof AddressBreakpoint) {
            return this.address.compareTo(((AddressBreakpoint)object).address);
        }
        return -1;
    }
}

