/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.extexecution.input;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.extexecution.input.InputProcessor;
import org.netbeans.api.extexecution.input.InputReader;

public class DefaultInputReader
implements InputReader {
    private static final Logger LOGGER = Logger.getLogger(DefaultInputReader.class.getName());
    private static final int BUFFER_SIZE = 512;
    private final Reader reader;
    private final char[] buffer;
    private final boolean greedy;
    private boolean closed;

    public DefaultInputReader(Reader reader, boolean bl) {
        assert (reader != null);
        this.reader = new BufferedReader(reader);
        this.greedy = bl;
        this.buffer = new char[bl ? 1024 : 512];
    }

    public int readInput(InputProcessor inputProcessor) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("Already closed reader");
        }
        if (!this.reader.ready()) {
            return 0;
        }
        int n = 0;
        StringBuilder stringBuilder = new StringBuilder();
        do {
            int n2;
            if ((n2 = this.reader.read(this.buffer)) <= 0) continue;
            stringBuilder.append(this.buffer, 0, n2);
            n += n2;
        } while (this.reader.ready() && this.greedy);
        if (inputProcessor != null && n > 0) {
            inputProcessor.processInput(stringBuilder.toString().toCharArray());
        }
        return n;
    }

    public void close() throws IOException {
        this.closed = true;
        this.reader.close();
        LOGGER.log(Level.FINEST, "Reader closed");
    }
}

