/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.extexecution;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import org.netbeans.modules.extexecution.OptionsAction;
import org.netbeans.modules.extexecution.RerunAction;
import org.netbeans.modules.extexecution.StopAction;
import org.openide.util.NbBundle;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;

public final class InputOutputManager {
    private static final Logger LOGGER = Logger.getLogger(InputOutputManager.class.getName());
    private static final Map<InputOutput, InputOutputData> AVAILABLE = new WeakHashMap<InputOutput, InputOutputData>();
    private static final Set<String> ACTIVE_DISPLAY_NAMES = new HashSet<String>();

    private InputOutputManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addInputOutput(InputOutputData inputOutputData) {
        Class<InputOutputManager> clazz = InputOutputManager.class;
        synchronized (InputOutputManager.class) {
            AVAILABLE.put(inputOutputData.inputOutput, inputOutputData);
            ACTIVE_DISPLAY_NAMES.remove(inputOutputData.displayName);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputOutputData getInputOutput(String string, boolean bl, String string2) {
        InputOutputData inputOutputData = null;
        TreeSet<InputOutputData> treeSet = new TreeSet<InputOutputData>();
        Class<InputOutputManager> clazz = InputOutputManager.class;
        synchronized (InputOutputManager.class) {
            Iterator<Map.Entry<InputOutput, InputOutputData>> iterator = AVAILABLE.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<InputOutput, InputOutputData> entry = iterator.next();
                InputOutput inputOutput = entry.getKey();
                InputOutputData inputOutputData2 = entry.getValue();
                if (inputOutput.isClosed()) {
                    iterator.remove();
                    continue;
                }
                if (InputOutputManager.isAppropriateName(string, inputOutputData2.displayName) && (bl && inputOutputData2.rerunAction != null && inputOutputData2.stopAction != null || !bl && inputOutputData2.rerunAction == null && inputOutputData2.stopAction == null) && (string2 != null && inputOutputData2.optionsAction != null && inputOutputData2.optionsAction.getOptionsPath().equals(string2) || string2 == null && inputOutputData2.optionsAction == null)) {
                    treeSet.add(inputOutputData2);
                }
                LOGGER.log(Level.FINEST, "InputOutputManager pool: {0}", inputOutputData2.getDisplayName());
            }
            if (!treeSet.isEmpty()) {
                inputOutputData = (InputOutputData)treeSet.first();
                AVAILABLE.remove(inputOutputData.inputOutput);
                ACTIVE_DISPLAY_NAMES.add(inputOutputData.displayName);
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return inputOutputData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputOutputData getInputOutput(InputOutput inputOutput) {
        InputOutputData inputOutputData = null;
        Class<InputOutputManager> clazz = InputOutputManager.class;
        synchronized (InputOutputManager.class) {
            Iterator<Map.Entry<InputOutput, InputOutputData>> iterator = AVAILABLE.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<InputOutput, InputOutputData> entry = iterator.next();
                InputOutput inputOutput2 = entry.getKey();
                InputOutputData inputOutputData2 = entry.getValue();
                if (inputOutput2.isClosed()) {
                    iterator.remove();
                    continue;
                }
                if (inputOutput2.equals(inputOutput)) {
                    inputOutputData = inputOutputData2;
                    ACTIVE_DISPLAY_NAMES.add(inputOutputData.displayName);
                    iterator.remove();
                }
                LOGGER.log(Level.FINEST, "InputOutputManager pool: {0}", inputOutputData2.getDisplayName());
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return inputOutputData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputOutputData createInputOutput(String string, boolean bl, String string2) {
        Class<InputOutputManager> clazz = InputOutputManager.class;
        synchronized (InputOutputManager.class) {
            InputOutput inputOutput;
            String string3 = InputOutputManager.getNonActiveDisplayName(string);
            StopAction stopAction = null;
            RerunAction rerunAction = null;
            OptionsAction optionsAction = null;
            if (bl) {
                stopAction = new StopAction();
                rerunAction = new RerunAction();
                if (string2 != null) {
                    optionsAction = new OptionsAction(string2);
                    inputOutput = IOProvider.getDefault().getIO(string3, new Action[]{rerunAction, stopAction, optionsAction});
                } else {
                    inputOutput = IOProvider.getDefault().getIO(string3, new Action[]{rerunAction, stopAction});
                }
                rerunAction.setParent(inputOutput);
            } else if (string2 != null) {
                optionsAction = new OptionsAction(string2);
                inputOutput = IOProvider.getDefault().getIO(string3, new Action[]{optionsAction});
            } else {
                inputOutput = IOProvider.getDefault().getIO(string3, true);
            }
            ACTIVE_DISPLAY_NAMES.add(string3);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return new InputOutputData(inputOutput, string3, stopAction, rerunAction, optionsAction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        Class<InputOutputManager> clazz = InputOutputManager.class;
        synchronized (InputOutputManager.class) {
            AVAILABLE.clear();
            ACTIVE_DISPLAY_NAMES.clear();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static boolean isAppropriateName(String string, String string2) {
        if (!string2.startsWith(string)) {
            return false;
        }
        return string2.substring(string.length()).matches("^(\\ #[0-9]+)?$");
    }

    private static String getNonActiveDisplayName(String string) {
        String string2 = string;
        if (ACTIVE_DISPLAY_NAMES.contains(string2)) {
            String string3;
            int n = 2;
            while (ACTIVE_DISPLAY_NAMES.contains(string3 = NbBundle.getMessage(InputOutputManager.class, (String)"Uniquified", (Object)string2, (Object)n++))) {
            }
            string2 = string3;
        }
        assert (!ACTIVE_DISPLAY_NAMES.contains(string2));
        return string2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class InputOutputData
    implements Comparable<InputOutputData> {
        private final InputOutput inputOutput;
        private final String displayName;
        private final StopAction stopAction;
        private final RerunAction rerunAction;
        private final OptionsAction optionsAction;

        public InputOutputData(InputOutput inputOutput, String string, StopAction stopAction, RerunAction rerunAction, OptionsAction optionsAction) {
            this.displayName = string;
            this.stopAction = stopAction;
            this.rerunAction = rerunAction;
            this.inputOutput = inputOutput;
            this.optionsAction = optionsAction;
        }

        public InputOutput getInputOutput() {
            return this.inputOutput;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public RerunAction getRerunAction() {
            return this.rerunAction;
        }

        public StopAction getStopAction() {
            return this.stopAction;
        }

        public OptionsAction getOptionsAction() {
            return this.optionsAction;
        }

        @Override
        public int compareTo(InputOutputData inputOutputData) {
            return this.displayName.compareTo(inputOutputData.displayName);
        }
    }
}

