/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.metadata.model.api.support.annotation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClassIndexListener;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.RootsEvent;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TypesEvent;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelException;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationScanner;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.JavaContextListener;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.ObjectProvider;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.PersistentObject;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.PersistentObjectManager;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.WeakSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AnnotationModelHelper {
    private final ClasspathInfo cpi;
    private final Set<JavaContextListener> javaContextListeners = new WeakSet();
    private final Set<PersistentObjectManager<? extends PersistentObject>> managers = new WeakSet();
    private ClassIndex classIndex;
    private ClassIndexListenerImpl listener;
    JavaSource javaSource;
    private Thread userActionTaskThread;
    private AnnotationScanner annotationScanner;
    private CompilationController controller;

    public static AnnotationModelHelper create(ClasspathInfo classpathInfo) {
        return new AnnotationModelHelper(classpathInfo);
    }

    private AnnotationModelHelper(ClasspathInfo classpathInfo) {
        this.cpi = classpathInfo;
    }

    public ClasspathInfo getClasspathInfo() {
        return this.cpi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends PersistentObject> PersistentObjectManager<T> createPersistentObjectManager(ObjectProvider<T> objectProvider) {
        AnnotationModelHelper annotationModelHelper = this;
        synchronized (annotationModelHelper) {
            PersistentObjectManager<T> persistentObjectManager = PersistentObjectManager.create(this, objectProvider);
            this.registerPersistentObjectManager(persistentObjectManager);
            return persistentObjectManager;
        }
    }

    private void registerPersistentObjectManager(PersistentObjectManager<? extends PersistentObject> persistentObjectManager) {
        assert (Thread.holdsLock(this));
        if (this.classIndex == null) {
            this.classIndex = this.cpi.getClassIndex();
            this.listener = new ClassIndexListenerImpl();
            this.classIndex.addClassIndexListener((ClassIndexListener)this.listener);
        }
        this.managers.add(persistentObjectManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJavaContextListener(JavaContextListener javaContextListener) {
        AnnotationModelHelper annotationModelHelper = this;
        synchronized (annotationModelHelper) {
            this.javaContextListeners.add(javaContextListener);
        }
    }

    public <V> V runJavaSourceTask(Callable<V> callable) throws IOException {
        return this.runJavaSourceTask(callable, true);
    }

    public void runJavaSourceTask(final Runnable runnable) throws IOException {
        this.runJavaSourceTask(new Callable<Void>(){

            @Override
            public Void call() {
                runnable.run();
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <V> V runJavaSourceTask(final Callable<V> callable, final boolean bl) throws IOException {
        JavaSource javaSource;
        AnnotationModelHelper annotationModelHelper = this;
        synchronized (annotationModelHelper) {
            javaSource = this.javaSource;
        }
        annotationModelHelper = javaSource != null ? javaSource : JavaSource.create((ClasspathInfo)this.cpi, (FileObject[])new FileObject[0]);
        final ArrayList arrayList = new ArrayList();
        try {
            annotationModelHelper.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void run(CompilationController compilationController) throws Exception {
                    arrayList.add(AnnotationModelHelper.this.runCallable(callable, compilationController, bl));
                }

                public void cancel() {
                }
            }, true);
        }
        catch (IOException iOException) {
            Throwable throwable = iOException.getCause();
            if (throwable instanceof MetadataModelException) {
                throw (MetadataModelException)throwable;
            }
            throw iOException;
        }
        return (V)arrayList.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> Future<V> runJavaSourceTaskWhenScanFinished(final Callable<V> callable) throws IOException {
        JavaSource javaSource;
        AnnotationModelHelper annotationModelHelper = this;
        synchronized (annotationModelHelper) {
            javaSource = this.javaSource;
        }
        annotationModelHelper = javaSource != null ? javaSource : JavaSource.create((ClasspathInfo)this.cpi, (FileObject[])new FileObject[0]);
        final DelegatingFuture delegatingFuture = new DelegatingFuture();
        try {
            delegatingFuture.setDelegate(annotationModelHelper.runWhenScanFinished((Task)new CancellableTask<CompilationController>(){

                public void run(CompilationController compilationController) throws Exception {
                    delegatingFuture.setResult(AnnotationModelHelper.this.runCallable(callable, compilationController, true));
                }

                public void cancel() {
                }
            }, true));
        }
        catch (IOException iOException) {
            Throwable throwable = iOException.getCause();
            if (throwable instanceof MetadataModelException) {
                throw (MetadataModelException)throwable;
            }
            throw iOException;
        }
        assert (delegatingFuture.delegate != null);
        return delegatingFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <V> V runCallable(Callable<V> callable, CompilationController compilationController, boolean bl) throws IOException {
        JavaSource javaSource;
        Thread thread;
        AnnotationModelHelper annotationModelHelper = this;
        synchronized (annotationModelHelper) {
            if (this.userActionTaskThread != null && this.userActionTaskThread != Thread.currentThread()) {
                throw new IllegalStateException("JavaSource.runUserActionTask() should not be executed by multiple threads concurrently");
            }
            thread = this.userActionTaskThread;
            this.userActionTaskThread = Thread.currentThread();
            javaSource = this.javaSource;
            this.javaSource = compilationController.getJavaSource();
        }
        annotationModelHelper = this.controller;
        this.controller = compilationController;
        try {
            compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
            V v = callable.call();
            return v;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new MetadataModelException((Throwable)exception);
        }
        finally {
            this.controller = annotationModelHelper;
            this.annotationScanner = null;
            AnnotationModelHelper annotationModelHelper2 = this;
            synchronized (annotationModelHelper2) {
                this.javaSource = javaSource;
                this.userActionTaskThread = thread;
            }
            if (bl) {
                for (JavaContextListener javaContextListener : this.javaContextListeners) {
                    javaContextListener.javaContextLeft();
                }
            }
        }
    }

    public CompilationController getCompilationController() {
        this.assertUserActionTaskThread();
        assert (this.controller != null);
        return this.controller;
    }

    public AnnotationScanner getAnnotationScanner() {
        this.assertUserActionTaskThread();
        if (this.annotationScanner == null) {
            this.annotationScanner = new AnnotationScanner(this);
        }
        return this.annotationScanner;
    }

    public boolean isJavaScanInProgress() {
        return SourceUtils.isScanInProgress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertUserActionTaskThread() {
        AnnotationModelHelper annotationModelHelper = this;
        synchronized (annotationModelHelper) {
            if (this.userActionTaskThread != Thread.currentThread()) {
                throw new IllegalStateException("The current thread is not running userActionTask()");
            }
        }
    }

    public TypeMirror resolveType(String string) {
        this.assertUserActionTaskThread();
        TypeElement typeElement = this.getCompilationController().getElements().getTypeElement(string);
        if (typeElement != null) {
            return typeElement.asType();
        }
        return null;
    }

    public boolean isSameRawType(TypeMirror typeMirror, String string) {
        this.assertUserActionTaskThread();
        TypeElement typeElement = this.getCompilationController().getElements().getTypeElement(string);
        if (typeElement != null) {
            Types types = this.getCompilationController().getTypes();
            TypeMirror typeMirror2 = types.erasure(typeElement.asType());
            return types.isSameType(types.erasure(typeMirror), typeMirror2);
        }
        return false;
    }

    public List<? extends TypeElement> getSuperclasses(TypeElement typeElement) {
        this.assertUserActionTaskThread();
        ArrayList<TypeElement> arrayList = new ArrayList<TypeElement>();
        TypeElement typeElement2 = typeElement;
        while ((typeElement2 = this.getSuperclass(typeElement2)) != null) {
            arrayList.add(typeElement2);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public TypeElement getSuperclass(TypeElement typeElement) {
        TypeElement typeElement2;
        Element element;
        this.assertUserActionTaskThread();
        TypeMirror typeMirror = typeElement.getSuperclass();
        if (TypeKind.DECLARED.equals((Object)typeMirror.getKind()) && ElementKind.CLASS.equals((Object)(element = ((DeclaredType)typeMirror).asElement()).getKind()) && !(typeElement2 = (TypeElement)element).getQualifiedName().contentEquals("java.lang.Object")) {
            return typeElement2;
        }
        return null;
    }

    public boolean hasAnnotation(List<? extends AnnotationMirror> list, String string) {
        this.assertUserActionTaskThread();
        for (AnnotationMirror annotationMirror : list) {
            String string2 = this.getAnnotationTypeName(annotationMirror.getAnnotationType());
            if (!string.equals(string2)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAnyAnnotation(List<? extends AnnotationMirror> list, Set<String> set) {
        this.assertUserActionTaskThread();
        for (AnnotationMirror annotationMirror : list) {
            String string = this.getAnnotationTypeName(annotationMirror.getAnnotationType());
            if (string == null || !set.contains(string)) continue;
            return true;
        }
        return false;
    }

    public Map<String, ? extends AnnotationMirror> getAnnotationsByType(List<? extends AnnotationMirror> list) {
        this.assertUserActionTaskThread();
        HashMap<String, AnnotationMirror> hashMap = new HashMap<String, AnnotationMirror>();
        for (AnnotationMirror annotationMirror : list) {
            String string = this.getAnnotationTypeName(annotationMirror.getAnnotationType());
            if (string == null) continue;
            hashMap.put(string, annotationMirror);
        }
        return Collections.unmodifiableMap(hashMap);
    }

    public String getAnnotationTypeName(DeclaredType declaredType) {
        this.assertUserActionTaskThread();
        if (!TypeKind.DECLARED.equals((Object)declaredType.getKind())) {
            return null;
        }
        Element element = declaredType.asElement();
        if (!ElementKind.ANNOTATION_TYPE.equals((Object)element.getKind())) {
            return null;
        }
        return ((TypeElement)element).getQualifiedName().toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DelegatingFuture<V>
    implements Future<V> {
        private volatile Future<Void> delegate;
        private volatile V result;
        private volatile ExecutionException executionException;

        private DelegatingFuture() {
        }

        public void setDelegate(Future<Void> future) {
            assert (this.delegate == null);
            this.delegate = future;
        }

        public void setResult(V v) {
            this.result = v;
        }

        @Override
        public boolean cancel(boolean bl) {
            return this.delegate.cancel(bl);
        }

        @Override
        public boolean isCancelled() {
            return this.delegate.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.delegate.isDone();
        }

        @Override
        public V get() throws InterruptedException, ExecutionException {
            this.delegate.get();
            return this.result;
        }

        @Override
        public V get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
            this.delegate.get(l, timeUnit);
            return this.result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ClassIndexListenerImpl
    implements ClassIndexListener {
        private ClassIndexListenerImpl() {
        }

        public void typesAdded(final TypesEvent typesEvent) {
            try {
                this.runInJavacContext(new Callable<Void>(){

                    @Override
                    public Void call() {
                        for (PersistentObjectManager persistentObjectManager : AnnotationModelHelper.this.managers) {
                            persistentObjectManager.typesAdded(typesEvent.getTypes());
                        }
                        return null;
                    }
                });
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }

        public void typesRemoved(final TypesEvent typesEvent) {
            try {
                this.runInJavacContext(new Callable<Void>(){

                    @Override
                    public Void call() {
                        for (PersistentObjectManager persistentObjectManager : AnnotationModelHelper.this.managers) {
                            persistentObjectManager.typesRemoved(typesEvent.getTypes());
                        }
                        return null;
                    }
                });
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }

        public void typesChanged(final TypesEvent typesEvent) {
            try {
                this.runInJavacContext(new Callable<Void>(){

                    @Override
                    public Void call() {
                        for (PersistentObjectManager persistentObjectManager : AnnotationModelHelper.this.managers) {
                            persistentObjectManager.typesChanged(typesEvent.getTypes());
                        }
                        return null;
                    }
                });
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }

        public void rootsAdded(RootsEvent rootsEvent) {
            this.rootsChanged();
        }

        public void rootsRemoved(RootsEvent rootsEvent) {
            this.rootsChanged();
        }

        private void rootsChanged() {
            try {
                this.runInJavacContext(new Callable<Void>(){

                    @Override
                    public Void call() {
                        for (PersistentObjectManager persistentObjectManager : AnnotationModelHelper.this.managers) {
                            persistentObjectManager.rootsChanged();
                        }
                        return null;
                    }
                });
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private <V> void runInJavacContext(Callable<V> callable) throws IOException {
            AnnotationModelHelper annotationModelHelper = AnnotationModelHelper.this;
            synchronized (annotationModelHelper) {
                if (AnnotationModelHelper.this.userActionTaskThread == Thread.currentThread()) {
                    throw new IllegalStateException("Retouche is sending ClassIndex events from within JavaSource.runUserActionTask()");
                }
            }
            AnnotationModelHelper.this.runJavaSourceTask(callable, false);
        }
    }
}

