/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.lexer;

import java.util.HashSet;
import java.util.Set;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.cnd.api.lexer.BatTokenId;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerInput;
import org.netbeans.spi.lexer.LexerRestartInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BatLexer
implements Lexer<BatTokenId> {
    private static Set<String> keywords = new HashSet<String>();
    private static Set<String> commands = new HashSet<String>();
    private LexerRestartInfo<BatTokenId> info;

    BatLexer(LexerRestartInfo<BatTokenId> lexerRestartInfo) {
        this.info = lexerRestartInfo;
    }

    public Token<BatTokenId> nextToken() {
        LexerInput lexerInput = this.info.input();
        int n = lexerInput.read();
        switch (n) {
            case -1: {
                return null;
            }
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 92: 
            case 94: 
            case 95: 
            case 96: 
            case 123: 
            case 124: 
            case 125: {
                return this.info.tokenFactory().createToken((TokenId)BatTokenId.OPERATOR);
            }
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                while ((n = lexerInput.read()) == 32 || n == 10 || n == 13 || n == 9) {
                }
                if (n != -1) {
                    lexerInput.backup(1);
                }
                return this.info.tokenFactory().createToken((TokenId)BatTokenId.WHITESPACE);
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                while ((n = lexerInput.read()) >= 48 && n <= 57) {
                }
                if (n == 46) {
                    while ((n = lexerInput.read()) >= 48 && n <= 57) {
                    }
                }
                lexerInput.backup(1);
                return this.info.tokenFactory().createToken((TokenId)BatTokenId.NUMBER);
            }
            case 34: {
                do {
                    if ((n = lexerInput.read()) != 92) continue;
                    n = lexerInput.read();
                    n = lexerInput.read();
                } while (n != 34 && n != 10 && n != 13 && n != -1);
                return this.info.tokenFactory().createToken((TokenId)BatTokenId.STRING);
            }
            case 39: {
                do {
                    if ((n = lexerInput.read()) != 92) continue;
                    n = lexerInput.read();
                    n = lexerInput.read();
                } while (n != 39 && n != 10 && n != 13 && n != -1);
                return this.info.tokenFactory().createToken((TokenId)BatTokenId.STRING);
            }
        }
        if (n >= 97 && n <= 122 || n >= 65 && n <= 90) {
            while ((n = lexerInput.read()) >= 97 && n <= 122 || n >= 65 && n <= 90 || n >= 48 && n <= 57 || n == 95 || n == 45 || n == 126) {
            }
            lexerInput.backup(1);
            String string = ((Object)lexerInput.readText()).toString();
            String string2 = string.toLowerCase();
            if (keywords.contains(string2)) {
                return this.info.tokenFactory().createToken((TokenId)BatTokenId.KEYWORD);
            }
            if (commands.contains(string2)) {
                return this.info.tokenFactory().createToken((TokenId)BatTokenId.COMMAND);
            }
            if ("rem".equals(string2)) {
                while ((n = lexerInput.read()) != 10 && n != 13 && n != -1) {
                }
                return this.info.tokenFactory().createToken((TokenId)BatTokenId.COMMENT);
            }
            return this.info.tokenFactory().createToken((TokenId)BatTokenId.IDENTIFIER);
        }
        return this.info.tokenFactory().createToken((TokenId)BatTokenId.ERROR);
    }

    public Object state() {
        return null;
    }

    public void release() {
    }

    static {
        keywords.add("aux");
        keywords.add("call");
        keywords.add("choice");
        keywords.add("defined");
        keywords.add("do");
        keywords.add("else");
        keywords.add("errorlevel");
        keywords.add("exist");
        keywords.add("endlocal");
        keywords.add("for");
        keywords.add("goto");
        keywords.add("if");
        keywords.add("in");
        keywords.add("not");
        keywords.add("nul");
        keywords.add("set");
        keywords.add("setlocal");
        keywords.add("shift");
        keywords.add("prn");
        commands.add("assign");
        commands.add("attrib");
        commands.add("cd");
        commands.add("chdir");
        commands.add("chkdsk");
        commands.add("cls");
        commands.add("comp");
        commands.add("copy");
        commands.add("date");
        commands.add("defrag");
        commands.add("del");
        commands.add("deltree");
        commands.add("dir");
        commands.add("echo");
        commands.add("echo.");
        commands.add("erase");
        commands.add("exit");
        commands.add("fc");
        commands.add("fdisk");
        commands.add("find");
        commands.add("format");
        commands.add("help");
        commands.add("label");
        commands.add("md");
        commands.add("mem");
        commands.add("memmaker");
        commands.add("mkdir");
        commands.add("more");
        commands.add("move");
        commands.add("path");
        commands.add("pause");
        commands.add("ren");
        commands.add("rename");
        commands.add("rd");
        commands.add("rmdir");
        commands.add("sort");
        commands.add("time");
        commands.add("tree");
        commands.add("type");
        commands.add("undelete");
        commands.add("ver");
        commands.add("xcopy");
    }
}

