/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.sync;

import java.awt.Color;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.dlight.api.collector.DataCollectorConfiguration;
import org.netbeans.modules.dlight.api.indicator.IndicatorConfiguration;
import org.netbeans.modules.dlight.api.indicator.IndicatorDataProviderConfiguration;
import org.netbeans.modules.dlight.api.indicator.IndicatorMetadata;
import org.netbeans.modules.dlight.api.storage.DataRow;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.api.storage.DataUtil;
import org.netbeans.modules.dlight.api.storage.types.Time;
import org.netbeans.modules.dlight.api.tool.DLightToolConfiguration;
import org.netbeans.modules.dlight.api.visualizer.VisualizerConfiguration;
import org.netbeans.modules.dlight.collector.stdout.CLIODCConfiguration;
import org.netbeans.modules.dlight.collector.stdout.CLIOParser;
import org.netbeans.modules.dlight.core.stack.api.support.FunctionDatatableDescription;
import org.netbeans.modules.dlight.dtrace.collector.DTDCConfiguration;
import org.netbeans.modules.dlight.indicators.DataRowToTimeSeries;
import org.netbeans.modules.dlight.indicators.TimeSeriesDescriptor;
import org.netbeans.modules.dlight.indicators.TimeSeriesIndicatorConfiguration;
import org.netbeans.modules.dlight.perfan.SunStudioDCConfiguration;
import org.netbeans.modules.dlight.spi.tool.DLightToolConfigurationProvider;
import org.netbeans.modules.dlight.tools.LLDataCollectorConfiguration;
import org.netbeans.modules.dlight.tools.ProcDataProviderConfiguration;
import org.netbeans.modules.dlight.util.DLightLogger;
import org.netbeans.modules.dlight.visualizers.api.ColumnsUIMapping;
import org.netbeans.modules.dlight.visualizers.api.FunctionName;
import org.netbeans.modules.dlight.visualizers.api.FunctionsListViewVisualizerConfiguration;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SyncToolConfigurationProvider
implements DLightToolConfigurationProvider {
    private static final int INDICATOR_POSITION = 300;
    private static final String ID = "dlight.tool.sync";
    private static final String TOOL_NAME = SyncToolConfigurationProvider.loc("SyncTool.ToolName", new String[0]);
    private static final String TOOL_DESCRIPTION = SyncToolConfigurationProvider.loc("SyncTool.ToolDescription", new String[0]);
    private static final DataTableMetadata.Column timestampColumn = new DataTableMetadata.Column("timestamp", Time.class, SyncToolConfigurationProvider.loc("SyncTool.ColumnName.timestamp", new String[0]), null);
    private static final DataTableMetadata.Column waiterColumn = new DataTableMetadata.Column("waiter", Integer.class, SyncToolConfigurationProvider.loc("SyncTool.ColumnName.waiter", new String[0]), null);
    private static final DataTableMetadata.Column mutexColumn = new DataTableMetadata.Column("mutex", Long.class, SyncToolConfigurationProvider.loc("SyncTool.ColumnName.mutex", new String[0]), null);
    private static final DataTableMetadata.Column blockerColumn = new DataTableMetadata.Column("blocker", Integer.class, SyncToolConfigurationProvider.loc("SyncTool.ColumnName.blocker", new String[0]), null);
    private static final DataTableMetadata.Column timeColumn = new DataTableMetadata.Column("time", Long.class, SyncToolConfigurationProvider.loc("SyncTool.ColumnName.time", new String[0]), null);
    private static final DataTableMetadata.Column stackColumn = new DataTableMetadata.Column("stackid", Long.class, SyncToolConfigurationProvider.loc("SyncTool.ColumnName.stackid", new String[0]), null);
    private static final DataTableMetadata.Column locksColumn = new DataTableMetadata.Column("locks", Float.class, SyncToolConfigurationProvider.loc("SyncTool.ColumnName.locks", new String[0]), null);
    private static final DataTableMetadata.Column threadsColumn = new DataTableMetadata.Column("threads", Integer.class, SyncToolConfigurationProvider.loc("SyncTool.ColumnName.threads", new String[0]), null);
    private static final DataTableMetadata rawTableMetadata;

    public DLightToolConfiguration create() {
        DLightToolConfiguration dLightToolConfiguration = new DLightToolConfiguration(ID, TOOL_NAME);
        dLightToolConfiguration.setLongName(TOOL_DESCRIPTION);
        dLightToolConfiguration.setDescription(SyncToolConfigurationProvider.loc("SyncTool.ToolDescription.Details", new String[0]));
        dLightToolConfiguration.setIcon("org/netbeans/modules/dlight/sync/resources/threads.png");
        List<DataCollectorConfiguration> list = this.initDataCollectorConfigurations();
        for (DataCollectorConfiguration object2 : list) {
            dLightToolConfiguration.addDataCollectorConfiguration(object2);
        }
        List<IndicatorDataProviderConfiguration> list2 = this.initIndicatorDataProviderConfigurations();
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            IndicatorDataProviderConfiguration indicatorDataProviderConfiguration = (IndicatorDataProviderConfiguration)iterator.next();
            dLightToolConfiguration.addIndicatorDataProviderConfiguration(indicatorDataProviderConfiguration);
        }
        IndicatorConfiguration indicatorConfiguration = this.initIndicatorConfiguration();
        dLightToolConfiguration.addIndicatorConfiguration(indicatorConfiguration);
        return dLightToolConfiguration;
    }

    private List<DataCollectorConfiguration> initDataCollectorConfigurations() {
        ArrayList<DataCollectorConfiguration> arrayList = new ArrayList<DataCollectorConfiguration>();
        arrayList.add((DataCollectorConfiguration)new SunStudioDCConfiguration(SunStudioDCConfiguration.CollectedInfo.SYNCHRONIZATION));
        arrayList.add((DataCollectorConfiguration)new LLDataCollectorConfiguration(LLDataCollectorConfiguration.CollectedData.SYNC));
        URL uRL = this.getClass().getResource("resources/sync.d");
        DTDCConfiguration dTDCConfiguration = new DTDCConfiguration(uRL, Arrays.asList(rawTableMetadata));
        dTDCConfiguration.setStackSupportEnabled(true);
        dTDCConfiguration.setIndicatorFiringFactor(1);
        dTDCConfiguration.setOutputPrefix("sync:");
        arrayList.add((DataCollectorConfiguration)dTDCConfiguration);
        return arrayList;
    }

    private IndicatorConfiguration initIndicatorConfiguration() {
        IndicatorMetadata indicatorMetadata = null;
        ArrayList<DataTableMetadata.Column> arrayList = new ArrayList<DataTableMetadata.Column>();
        arrayList.add(locksColumn);
        arrayList.add(threadsColumn);
        arrayList.add(SunStudioDCConfiguration.c_ulockSummary);
        arrayList.add(ProcDataProviderConfiguration.THREADS);
        arrayList.addAll(LLDataCollectorConfiguration.SYNC_TABLE.getColumns());
        indicatorMetadata = new IndicatorMetadata(arrayList);
        TimeSeriesIndicatorConfiguration timeSeriesIndicatorConfiguration = new TimeSeriesIndicatorConfiguration(indicatorMetadata, 300);
        timeSeriesIndicatorConfiguration.setTitle(SyncToolConfigurationProvider.loc("indicator.title", new String[0]));
        timeSeriesIndicatorConfiguration.setGraphScale(2);
        TimeSeriesDescriptor timeSeriesDescriptor = new TimeSeriesDescriptor(new Color(178, 188, 0), SyncToolConfigurationProvider.loc("graph.description.threads", new String[0]), TimeSeriesDescriptor.Kind.ABS_SURFACE);
        TimeSeriesDescriptor timeSeriesDescriptor2 = new TimeSeriesDescriptor(new Color(231, 111, 0), SyncToolConfigurationProvider.loc("graph.description.locks", new String[0]), TimeSeriesDescriptor.Kind.ABS_SURFACE);
        List<DataTableMetadata.Column> list = Arrays.asList(threadsColumn, ProcDataProviderConfiguration.THREADS, LLDataCollectorConfiguration.threads_count);
        List<DataTableMetadata.Column> list2 = Arrays.asList(locksColumn, SunStudioDCConfiguration.c_ulockSummary, LLDataCollectorConfiguration.LOCKS_COUNT);
        timeSeriesDescriptor.setSourceColumns(list);
        timeSeriesDescriptor2.setSourceColumns(list2);
        timeSeriesIndicatorConfiguration.addTimeSeriesDescriptors(new TimeSeriesDescriptor[]{timeSeriesDescriptor, timeSeriesDescriptor2});
        timeSeriesIndicatorConfiguration.setDataRowHandler((DataRowToTimeSeries)new DataRowToSync(list, list2));
        timeSeriesIndicatorConfiguration.setActionDisplayName(SyncToolConfigurationProvider.loc("indicator.action", new String[0]));
        timeSeriesIndicatorConfiguration.setActionTooltip(SyncToolConfigurationProvider.loc("indicator.action.tooltip", new String[0]));
        timeSeriesIndicatorConfiguration.addVisualizerConfiguration(this.getDetails(rawTableMetadata));
        DataTableMetadata dataTableMetadata = SunStudioDCConfiguration.getSyncTableMetadata((DataTableMetadata.Column[])new DataTableMetadata.Column[]{SunStudioDCConfiguration.c_name, SunStudioDCConfiguration.c_eSync, SunStudioDCConfiguration.c_eSyncn});
        FunctionDatatableDescription functionDatatableDescription = new FunctionDatatableDescription(SunStudioDCConfiguration.c_name.getColumnName(), null, SunStudioDCConfiguration.c_name.getColumnName());
        FunctionsListViewVisualizerConfiguration functionsListViewVisualizerConfiguration = new FunctionsListViewVisualizerConfiguration(dataTableMetadata, functionDatatableDescription, Arrays.asList(SunStudioDCConfiguration.c_eSync, SunStudioDCConfiguration.c_eSyncn));
        ColumnsUIMapping columnsUIMapping = new ColumnsUIMapping();
        columnsUIMapping.setColumnUI(SunStudioDCConfiguration.c_name.getColumnName(), SyncToolConfigurationProvider.loc("SyncTool.ColumnName.func_name", new String[0]), SyncToolConfigurationProvider.loc("SyncTool.ColumnTooltip.func_name", new String[0]));
        columnsUIMapping.setColumnUI(SunStudioDCConfiguration.c_eSync.getColumnName(), SyncToolConfigurationProvider.loc("SyncTool.ColumnName.e_sync", new String[0]), SyncToolConfigurationProvider.loc("SyncTool.ColumnTooltip.e_sync", new String[0]));
        columnsUIMapping.setColumnUI(SunStudioDCConfiguration.c_eSyncn.getColumnName(), SyncToolConfigurationProvider.loc("SyncTool.ColumnName.syncn", new String[0]), SyncToolConfigurationProvider.loc("SyncTool.ColumnTooltip.syncn", new String[0]));
        functionsListViewVisualizerConfiguration.setColumnsUIMapping(columnsUIMapping);
        functionsListViewVisualizerConfiguration.setEmptyAnalyzeMessage(SyncToolConfigurationProvider.loc("DetailedView.EmptyAnalyzeMessage", new String[0]));
        functionsListViewVisualizerConfiguration.setEmptyRunningMessage(SyncToolConfigurationProvider.loc("DetailedView.EmptyRunningMessage", new String[0]));
        timeSeriesIndicatorConfiguration.addVisualizerConfiguration((VisualizerConfiguration)functionsListViewVisualizerConfiguration);
        return timeSeriesIndicatorConfiguration;
    }

    private List<IndicatorDataProviderConfiguration> initIndicatorDataProviderConfigurations() {
        ArrayList<IndicatorDataProviderConfiguration> arrayList = new ArrayList<IndicatorDataProviderConfiguration>();
        DataTableMetadata dataTableMetadata = new DataTableMetadata("locks", Arrays.asList(locksColumn, threadsColumn), null);
        List<DataTableMetadata> list = Arrays.asList(dataTableMetadata);
        CLIODCConfiguration cLIODCConfiguration = new CLIODCConfiguration("/bin/prstat", "-mv -p @PID -c 1", (CLIOParser)new SyncCLIOParser(locksColumn, threadsColumn), list);
        cLIODCConfiguration.setName("prstat");
        arrayList.add((IndicatorDataProviderConfiguration)cLIODCConfiguration);
        arrayList.add((IndicatorDataProviderConfiguration)new SunStudioDCConfiguration(SunStudioDCConfiguration.CollectedInfo.SYNCSUMMARY));
        arrayList.add((IndicatorDataProviderConfiguration)new ProcDataProviderConfiguration());
        arrayList.add((IndicatorDataProviderConfiguration)new LLDataCollectorConfiguration(LLDataCollectorConfiguration.CollectedData.SYNC));
        return arrayList;
    }

    private VisualizerConfiguration getDetails(DataTableMetadata dataTableMetadata) {
        DataTableMetadata dataTableMetadata2 = null;
        DataTableMetadata.Column column = new DataTableMetadata.Column("time", Long.class, SyncToolConfigurationProvider.loc("SyncTool.ColumnName.e_sync", new String[0]), null);
        DataTableMetadata.Column column2 = new DataTableMetadata.Column("count", Long.class, SyncToolConfigurationProvider.loc("SyncTool.ColumnName.syncn", new String[0]), null);
        List<DataTableMetadata.Column> list = Arrays.asList(new DataTableMetadata.Column("id", Integer.class, "id", null), new DataTableMetadata.Column("func_name", FunctionName.class, "Function", null), column, column2);
        String string = "SELECT func.func_id as id, func.func_name as func_name, node.offset as offset, SUM(sync.time/1000000) as time, COUNT(*) as count FROM sync, node AS node, func WHERE  sync.stackid = node.node_id and node.func_id = func.func_id GROUP BY node.func_id, func.func_id, func.func_name, node.offset";
        dataTableMetadata2 = new DataTableMetadata("sync", list, string, Arrays.asList(dataTableMetadata));
        FunctionDatatableDescription functionDatatableDescription = new FunctionDatatableDescription("func_name", "offset", "id");
        FunctionsListViewVisualizerConfiguration functionsListViewVisualizerConfiguration = new FunctionsListViewVisualizerConfiguration(dataTableMetadata2, functionDatatableDescription, Arrays.asList(column, column2));
        ColumnsUIMapping columnsUIMapping = new ColumnsUIMapping();
        columnsUIMapping.setColumnUI("func_name", SyncToolConfigurationProvider.loc("SyncTool.ColumnName.func_name", new String[0]), SyncToolConfigurationProvider.loc("SyncTool.ColumnTooltip.func_name", new String[0]));
        columnsUIMapping.setColumnUI("time", SyncToolConfigurationProvider.loc("SyncTool.ColumnName.e_sync", new String[0]), SyncToolConfigurationProvider.loc("SyncTool.ColumnTooltip.e_sync", new String[0]));
        columnsUIMapping.setColumnUI("count", SyncToolConfigurationProvider.loc("SyncTool.ColumnName.syncn", new String[0]), SyncToolConfigurationProvider.loc("SyncTool.ColumnTooltip.syncn", new String[0]));
        functionsListViewVisualizerConfiguration.setColumnsUIMapping(columnsUIMapping);
        functionsListViewVisualizerConfiguration.setEmptyAnalyzeMessage(SyncToolConfigurationProvider.loc("DetailedView.EmptyAnalyzeMessage", new String[0]));
        functionsListViewVisualizerConfiguration.setEmptyRunningMessage(SyncToolConfigurationProvider.loc("DetailedView.EmptyRunningMessage", new String[0]));
        return functionsListViewVisualizerConfiguration;
    }

    private static String loc(String string, String ... stringArray) {
        return NbBundle.getMessage(SyncToolConfigurationProvider.class, (String)string, (Object[])stringArray);
    }

    static {
        List<DataTableMetadata.Column> list = Arrays.asList(timestampColumn, waiterColumn, mutexColumn, blockerColumn, timeColumn, stackColumn);
        rawTableMetadata = new DataTableMetadata("sync", list, null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DataRowToSync
    implements DataRowToTimeSeries {
        private final List<DataTableMetadata.Column> threadColumns;
        private final List<DataTableMetadata.Column> lockColumns;
        private int locks;

        public DataRowToSync(List<DataTableMetadata.Column> list, List<DataTableMetadata.Column> list2) {
            this.threadColumns = new ArrayList<DataTableMetadata.Column>(list);
            this.lockColumns = new ArrayList<DataTableMetadata.Column>(list2);
        }

        public float[] getData(DataRow dataRow) {
            boolean bl = false;
            int n = 0;
            for (String string : dataRow.getColumnNames()) {
                for (DataTableMetadata.Column column : this.threadColumns) {
                    if (!column.getColumnName().equals(string)) continue;
                    bl = true;
                    n = DataUtil.toInt((Object)dataRow.getData(string));
                }
                for (DataTableMetadata.Column column : this.lockColumns) {
                    if (!column.getColumnName().equals(string)) continue;
                    this.locks = DataUtil.toInt((Object)dataRow.getData(string));
                }
            }
            if (bl) {
                return new float[]{n, (float)(n * Math.min(this.locks, 100)) / 100.0f};
            }
            return null;
        }

        public Map<String, String> getDetails() {
            return Collections.emptyMap();
        }
    }

    private static class SyncCLIOParser
    implements CLIOParser {
        private static final Pattern TOTAL = Pattern.compile("^Total: \\d+ processes, (\\d+) lwps");
        private final List<String> colnames;
        private float locks;
        private boolean nextLineShouldBeTotal;

        public SyncCLIOParser(DataTableMetadata.Column column, DataTableMetadata.Column column2) {
            this.colnames = Arrays.asList(column.getColumnName(), column2.getColumnName());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DataRow process(String string) {
            Matcher matcher;
            if (DLightLogger.instance.isLoggable(Level.FINE)) {
                DLightLogger.instance.fine("SyncCLIOParser: " + string);
            }
            if (string == null || string.length() == 0) {
                return null;
            }
            if (Character.isDigit((string = string.trim()).charAt(0))) {
                String[] stringArray = (string = string.replaceAll(",", ".")).split("[ \t]+");
                if (stringArray.length < 8) {
                    return null;
                }
                try {
                    this.locks = Float.parseFloat(stringArray[7]);
                    this.nextLineShouldBeTotal = true;
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (this.nextLineShouldBeTotal && (matcher = TOTAL.matcher(string)).find()) {
                try {
                    int n = Integer.parseInt(matcher.group(1));
                    DataRow dataRow = new DataRow(this.colnames, Arrays.asList(Float.valueOf(this.locks), n));
                    return dataRow;
                }
                catch (NumberFormatException numberFormatException) {
                }
                finally {
                    this.nextLineShouldBeTotal = false;
                }
            }
            return null;
        }
    }
}

