/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsstack.jaxws.jboss;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.netbeans.modules.websvc.wsstack.api.WSStack;
import org.netbeans.modules.websvc.wsstack.api.WSStackVersion;
import org.netbeans.modules.websvc.wsstack.api.WSTool;
import org.netbeans.modules.websvc.wsstack.jaxws.JaxWs;
import org.netbeans.modules.websvc.wsstack.spi.WSStackFactory;
import org.netbeans.modules.websvc.wsstack.spi.WSStackImplementation;
import org.netbeans.modules.websvc.wsstack.spi.WSToolImplementation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossJaxWsStack
implements WSStackImplementation<JaxWs> {
    private static final String JAXWS_TOOLS_JAR = "client/jaxws-tools.jar";
    private File root;
    private String version;
    private JaxWs jaxWs;

    public JBossJaxWsStack(File file) {
        this.root = file;
        try {
            this.version = this.resolveImplementationVersion();
            if (this.version == null) {
                this.version = "2.1.3";
            }
        }
        catch (IOException iOException) {
            this.version = "2.1.3";
        }
        this.jaxWs = new JaxWs(this.getUriDescriptor());
    }

    public JaxWs get() {
        return this.jaxWs;
    }

    public WSStackVersion getVersion() {
        return WSStackFactory.createWSStackVersion((String)this.version);
    }

    public WSTool getWSTool(WSStack.Tool tool) {
        if (tool == JaxWs.Tool.WSIMPORT) {
            return WSStackFactory.createWSTool((WSToolImplementation)new JaxWsTool(JaxWs.Tool.WSIMPORT));
        }
        if (tool == JaxWs.Tool.WSGEN) {
            return WSStackFactory.createWSTool((WSToolImplementation)new JaxWsTool(JaxWs.Tool.WSGEN));
        }
        return null;
    }

    private JaxWs.UriDescriptor getUriDescriptor() {
        return new JaxWs.UriDescriptor(){

            public String getServiceUri(String string, String string2, String string3, boolean bl) {
                return string + "/" + string2;
            }

            public String getDescriptorUri(String string, String string2, String string3, boolean bl) {
                return this.getServiceUri(string, string2, string3, bl) + "?wsdl";
            }

            public String getTesterPageUri(String string, String string2, String string3, boolean bl) {
                return this.getServiceUri(string, string2, string3, bl) + "?Tester";
            }
        };
    }

    public boolean isFeatureSupported(WSStack.Feature feature) {
        if (feature == JaxWs.Feature.JSR109) {
            return true;
        }
        return feature == JaxWs.Feature.WSIT && new File(this.root, "client/jbossws-metro-wsit-tools.jar").exists();
    }

    private String resolveImplementationVersion() throws IOException {
        JarFile jarFile;
        JarEntry jarEntry;
        File file = new File(this.root, JAXWS_TOOLS_JAR);
        if (file.exists() && (jarEntry = (jarFile = new JarFile(file)).getJarEntry("com/sun/tools/ws/version.properties")) != null) {
            InputStream inputStream = jarFile.getInputStream(jarEntry);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            String string = null;
            String string2 = null;
            while ((string = bufferedReader.readLine()) != null) {
                String string3 = string.trim();
                if (!string3.startsWith("major-version=")) continue;
                string2 = string3.substring(14);
            }
            bufferedReader.close();
            return string2;
        }
        return null;
    }

    private class JaxWsTool
    implements WSToolImplementation {
        JaxWs.Tool tool;

        JaxWsTool(JaxWs.Tool tool) {
            this.tool = tool;
        }

        public String getName() {
            return this.tool.getName();
        }

        public URL[] getLibraries() {
            File file = new File(JBossJaxWsStack.this.root, "client");
            try {
                File file2;
                File file3 = new File(file, "jboss-common-client.jar");
                if (!file3.exists()) {
                    file3 = new File(file, "jboss-logging-spi.jar");
                }
                if ((file2 = new File(file, "jboss-jaxws.jar")).exists()) {
                    return new URL[]{new File(file, "wstx.jar").toURI().toURL(), new File(file, "jaxws-tools.jar").toURI().toURL(), file3.toURI().toURL(), new File(file, "stax-api.jar").toURI().toURL(), file2.toURI().toURL(), new File(file, "jbossws-client.jar").toURI().toURL(), new File(file, "jboss-jaxws-ext.jar").toURI().toURL(), new File(file, "jboss-saaj.jar").toURI().toURL()};
                }
                file2 = new File(file, "jbossws-native-jaxws.jar");
                if (file2.exists()) {
                    return new URL[]{new File(file, "wstx.jar").toURI().toURL(), new File(file, "jaxws-tools.jar").toURI().toURL(), file3.toURI().toURL(), new File(file, "stax-api.jar").toURI().toURL(), file2.toURI().toURL(), new File(file, "jbossws-native-client.jar").toURI().toURL(), new File(file, "jbossws-native-jaxws-ext.jar").toURI().toURL(), new File(file, "jbossws-native-saaj.jar").toURI().toURL()};
                }
                file2 = new File(file, "jaxws-api.jar");
                if (file2.exists()) {
                    return new URL[]{new File(file, "wstx.jar").toURI().toURL(), new File(file, "jaxws-tools.jar").toURI().toURL(), file3.toURI().toURL(), new File(file, "stax-api.jar").toURI().toURL(), file2.toURI().toURL(), new File(file, "jbossws-metro-client.jar").toURI().toURL(), new File(file, "saaj-api.jar").toURI().toURL()};
                }
            }
            catch (MalformedURLException malformedURLException) {
                return new URL[0];
            }
            return new URL[0];
        }
    }
}

