/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.EditList;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.php.editor.model.Model;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.VariableName;
import org.netbeans.modules.php.editor.model.VariableScope;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.verification.AbstractRule;
import org.netbeans.modules.php.editor.verification.PHPHintsProvider;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VarDocHint
extends AbstractRule {
    private static ScheduledExecutorService service = Executors.newSingleThreadScheduledExecutor();

    public String getId() {
        return "Var.Doc.Hint";
    }

    public String getDescription() {
        return NbBundle.getMessage(VarDocHint.class, (String)"VarDocHintDesc");
    }

    public String getDisplayName() {
        return NbBundle.getMessage(VarDocHint.class, (String)"VarDocHintDispName");
    }

    @Override
    void computeHintsImpl(PHPRuleContext pHPRuleContext, List<Hint> list, PHPHintsProvider.Kind kind) throws BadLocationException {
        PHPParseResult pHPParseResult;
        Model model;
        VariableScope variableScope;
        String string;
        BaseDocument baseDocument = pHPRuleContext.doc;
        int n = pHPRuleContext.caretOffset;
        int n2 = -1;
        int n3 = -1;
        n2 = n > 0 ? Utilities.getRowStart((BaseDocument)baseDocument, (int)n) : -1;
        int n4 = n3 = n2 != -1 ? Utilities.getRowEnd((BaseDocument)baseDocument, (int)n) : -1;
        if (n2 != -1 && n3 != -1 && n > n2 && (string = Utilities.getIdentifier((BaseDocument)baseDocument, (int)n)) != null && string.startsWith("$") && (variableScope = (model = (pHPParseResult = (PHPParseResult)pHPRuleContext.parserResult).getModel()).getVariableScope(n)) != null) {
            OffsetRange offsetRange;
            int n5;
            int n6 = Utilities.getWordStart((BaseDocument)baseDocument, (int)n);
            int n7 = Utilities.getWordEnd((BaseDocument)baseDocument, (int)n);
            VariableName variableName = ModelUtils.getFirst(variableScope.getDeclaredVariables(), string);
            if (variableName != null && n7 - n6 == string.length() && variableName.getTypes(n5 = (offsetRange = new OffsetRange(n6, n7)).getEnd()).isEmpty()) {
                Collection<? extends String> collection = variableName.getTypeNames(n5);
                for (String string2 : collection) {
                    if (string2.contains("@")) continue;
                    return;
                }
                list.add(new Hint((Rule)this, this.getDisplayName(), pHPRuleContext.parserResult.getSnapshot().getSource().getFileObject(), offsetRange, Collections.singletonList(new Fix(pHPRuleContext, variableName)), 500));
            }
        }
    }

    private class Fix
    implements HintFix {
        private RuleContext context;
        private VariableName vName;

        Fix(RuleContext ruleContext, VariableName variableName) {
            this.context = ruleContext;
            this.vName = variableName;
        }

        public String getDescription() {
            return VarDocHint.this.getDescription();
        }

        public void implement() throws Exception {
            JTextComponent jTextComponent;
            BaseDocument baseDocument = this.context.doc;
            int n = this.getOffset(baseDocument);
            String string = this.getCommentText();
            int n2 = string.indexOf(this.getTypeTemplate());
            EditList editList = this.getEditList(baseDocument, n);
            Position position = editList.createPosition(n + n2);
            editList.apply();
            if (position != null && position.getOffset() != -1 && (jTextComponent = GsfUtilities.getPaneFor((FileObject)this.context.parserResult.getSnapshot().getSource().getFileObject())) != null) {
                int n3 = position.getOffset();
                int n4 = n3 + this.getTypeTemplate().length();
                if (n2 != -1 && n4 <= baseDocument.getLength()) {
                    String string2 = baseDocument.getText(n3, this.getTypeTemplate().length());
                    if (this.getTypeTemplate().equals(string2)) {
                        jTextComponent.select(n3, n4);
                        this.scheduleShowingCompletion();
                    }
                }
            }
        }

        public boolean isSafe() {
            return true;
        }

        public boolean isInteractive() {
            return false;
        }

        EditList getEditList(BaseDocument baseDocument, int n) throws Exception {
            EditList editList = new EditList(baseDocument);
            editList.replace(n, 0, this.getCommentText(), true, 0);
            return editList;
        }

        private String getCommentText() {
            return String.format("\n/* @var %s %s */", this.vName.getName(), this.getTypeTemplate());
        }

        private String getTypeTemplate() {
            return "<type>";
        }

        private int getOffset(BaseDocument baseDocument) throws BadLocationException {
            int n = Utilities.getRowStart((BaseDocument)baseDocument, (int)this.context.caretOffset);
            return Utilities.getRowEnd((BaseDocument)baseDocument, (int)(n - 1));
        }

        private void scheduleShowingCompletion() {
            service.schedule(new Runnable(){

                public void run() {
                    Completion.get().showCompletion();
                }
            }, 50L, TimeUnit.MILLISECONDS);
        }
    }
}

