/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.model.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.netbeans.modules.php.api.editor.EditorSupport;
import org.netbeans.modules.php.api.editor.PhpClass;
import org.netbeans.modules.php.api.editor.PhpElement;
import org.netbeans.modules.php.api.editor.PhpFunction;
import org.netbeans.modules.php.api.editor.PhpVariable;
import org.netbeans.modules.php.editor.NamespaceIndexFilter;
import org.netbeans.modules.php.editor.index.IndexedClass;
import org.netbeans.modules.php.editor.index.PHPIndex;
import org.netbeans.modules.php.editor.model.ClassScope;
import org.netbeans.modules.php.editor.model.FieldElement;
import org.netbeans.modules.php.editor.model.FileScope;
import org.netbeans.modules.php.editor.model.FunctionScope;
import org.netbeans.modules.php.editor.model.MethodScope;
import org.netbeans.modules.php.editor.model.Model;
import org.netbeans.modules.php.editor.model.ModelFactory;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.Scope;
import org.netbeans.modules.php.editor.model.TypeScope;
import org.netbeans.modules.php.editor.model.VariableScope;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditorSupportImpl
implements EditorSupport {
    public Collection<PhpClass> getClasses(FileObject fileObject) {
        final ArrayList<PhpClass> arrayList = new ArrayList<PhpClass>();
        Source source = Source.create((FileObject)fileObject);
        if (source != null) {
            try {
                ParserManager.parse(Collections.singleton(source), (UserTask)new UserTask(){

                    public void run(ResultIterator resultIterator) throws Exception {
                        Parser.Result result = resultIterator.getParserResult();
                        if (result instanceof PHPParseResult) {
                            Model model = ModelFactory.getModel((PHPParseResult)result);
                            FileScope fileScope = model.getFileScope();
                            Collection<? extends ClassScope> collection = ModelUtils.getDeclaredClasses(fileScope);
                            for (ClassScope classScope : collection) {
                                arrayList.add((PhpClass)EditorSupportImpl.this.getPhpElement(classScope));
                            }
                        }
                    }
                });
            }
            catch (ParseException parseException) {
                Exceptions.printStackTrace((Throwable)parseException);
            }
        }
        return arrayList;
    }

    public Collection<FileObject> filesForClass(FileObject fileObject, PhpClass phpClass) {
        if (fileObject.isData()) {
            throw new IllegalArgumentException("sourceRoot must be a folder");
        }
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        PHPIndex pHPIndex = PHPIndex.get(Collections.singletonList(fileObject));
        NamespaceIndexFilter<IndexedClass> namespaceIndexFilter = new NamespaceIndexFilter<IndexedClass>(phpClass.getFullyQualifiedName());
        Collection<IndexedClass> collection = namespaceIndexFilter.filter(pHPIndex.getClasses(null, namespaceIndexFilter.getName(), QuerySupport.Kind.EXACT));
        for (IndexedClass indexedClass : collection) {
            FileObject fileObject2 = indexedClass.getFileObject();
            if (fileObject2 == null || !fileObject2.isValid()) continue;
            arrayList.add(fileObject2);
        }
        return arrayList;
    }

    public PhpElement getElement(FileObject fileObject, final int n) {
        Source source = Source.create((FileObject)fileObject);
        final ArrayList arrayList = new ArrayList(1);
        if (source != null) {
            try {
                ParserManager.parse(Collections.singleton(source), (UserTask)new UserTask(){

                    public void run(ResultIterator resultIterator) throws Exception {
                        Parser.Result result = resultIterator.getParserResult();
                        if (result instanceof PHPParseResult) {
                            Model model = ModelFactory.getModel((PHPParseResult)result);
                            arrayList.add(EditorSupportImpl.this.getPhpElement(model.getVariableScope(n)));
                        }
                    }
                });
            }
            catch (ParseException parseException) {
                Exceptions.printStackTrace((Throwable)parseException);
            }
        }
        return arrayList.isEmpty() ? null : (PhpElement)arrayList.get(0);
    }

    private PhpElement getPhpElement(Scope scope) {
        PhpVariable phpVariable = null;
        if (scope instanceof MethodScope) {
            PhpClass phpClass = (PhpClass)this.getPhpElement((TypeScope)scope.getInScope());
            for (PhpClass.Method method : phpClass.getMethods()) {
                if (!method.getName().equals(scope.getName())) continue;
                phpVariable = method;
                break;
            }
        } else if (scope instanceof ClassScope) {
            ClassScope classScope = (ClassScope)scope;
            PhpClass phpClass = new PhpClass(classScope.getName(), classScope.getNamespaceName().append(classScope.getName()).toFullyQualified().toString(), classScope.getOffset());
            for (FieldElement classMemberElement : classScope.getDeclaredFields()) {
                phpClass.addField(classMemberElement.getName(), classMemberElement.getName(), classMemberElement.getOffset());
            }
            for (MethodScope methodScope : classScope.getDeclaredMethods()) {
                phpClass.addMethod(methodScope.getName(), methodScope.getName(), methodScope.getOffset());
            }
            phpVariable = phpClass;
        } else if (scope instanceof FunctionScope) {
            phpVariable = new PhpFunction(scope.getName(), scope.getNamespaceName().append(scope.getName()).toFullyQualified().toString(), scope.getOffset());
        } else if (scope instanceof VariableScope) {
            phpVariable = new PhpVariable(scope.getName(), scope.getName(), scope.getOffset());
        }
        return phpVariable;
    }
}

