/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor;

import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.php.api.editor.PhpElement;
import org.netbeans.modules.php.api.editor.PhpVariable;
import org.netbeans.modules.php.editor.PHPCompletionItem;
import org.netbeans.modules.php.editor.index.IndexedConstant;

public final class PhpElementCompletionItem {
    private PhpElementCompletionItem() {
    }

    static CompletionProposal fromPhpElement(PhpElement phpElement, PHPCompletionItem.CompletionRequest completionRequest) {
        assert (phpElement != null);
        if (phpElement instanceof PhpVariable) {
            return new PhpVariableCompletionItem((PhpVariable)phpElement, completionRequest);
        }
        throw new IllegalArgumentException("Unsupported PHP element type (only variables are currently supported): " + phpElement);
    }

    private static final class PhpVariableCompletionItem
    extends PHPCompletionItem.VariableItem {
        private final PhpVariable variable;

        public PhpVariableCompletionItem(PhpVariable phpVariable, PHPCompletionItem.CompletionRequest completionRequest) {
            super(new IndexedConstant(phpVariable.getName(), null, null, null, phpVariable.getOffset(), 0, null), completionRequest);
            this.variable = phpVariable;
        }

        private PhpVariableCompletionItem(IndexedConstant indexedConstant, PHPCompletionItem.CompletionRequest completionRequest) {
            super(indexedConstant, completionRequest);
            this.variable = null;
        }

        protected String getTypeName() {
            return this.variable.getFullyQualifiedName();
        }

        public boolean isSmart() {
            return true;
        }
    }
}

