/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.classfile;

import java.io.DataInputStream;
import java.io.IOException;
import org.netbeans.modules.classfile.ConstantPool;
import org.netbeans.modules.classfile.InvalidClassFormatException;
import org.netbeans.modules.classfile.VerificationTypeInfo;

public abstract class StackMapFrame {
    int frameType;

    static StackMapFrame[] loadStackMapTable(DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        int n = dataInputStream.readUnsignedShort();
        StackMapFrame[] stackMapFrameArray = new StackMapFrame[n];
        for (int i = 0; i < n; ++i) {
            StackMapFrame stackMapFrame;
            int n2 = dataInputStream.readUnsignedByte();
            if (n2 >= 0 && n2 <= 63) {
                stackMapFrame = new SameFrame(n2);
            } else if (n2 >= 64 && n2 <= 127) {
                VerificationTypeInfo verificationTypeInfo = VerificationTypeInfo.loadVerificationTypeInfo(dataInputStream, constantPool);
                stackMapFrame = new SameLocals1StackItemFrame(n2, verificationTypeInfo);
            } else {
                if (n2 >= 128 && n2 <= 246) {
                    throw new InvalidClassFormatException("reserved stack map frame tag used: " + n2);
                }
                if (n2 == 247) {
                    int n3 = dataInputStream.readUnsignedShort();
                    VerificationTypeInfo verificationTypeInfo = VerificationTypeInfo.loadVerificationTypeInfo(dataInputStream, constantPool);
                    stackMapFrame = new SameLocals1StackItemFrameExtended(n2, n3, verificationTypeInfo);
                } else if (n2 >= 248 && n2 <= 250) {
                    int n4 = dataInputStream.readUnsignedShort();
                    stackMapFrame = new ChopFrame(n2, n4);
                } else if (n2 == 251) {
                    int n5 = dataInputStream.readUnsignedShort();
                    stackMapFrame = new SameFrameExtended(n2, n5);
                } else {
                    stackMapFrame = n2 >= 252 && n2 <= 254 ? StackMapFrame.makeAppendFrame(n2, dataInputStream, constantPool) : StackMapFrame.makeFullFrame(dataInputStream, constantPool);
                }
            }
            stackMapFrameArray[i] = stackMapFrame;
        }
        return stackMapFrameArray;
    }

    private static AppendFrame makeAppendFrame(int n, DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        int n2 = dataInputStream.readUnsignedShort();
        VerificationTypeInfo[] verificationTypeInfoArray = new VerificationTypeInfo[n - 251];
        for (int i = 0; i < verificationTypeInfoArray.length; ++i) {
            verificationTypeInfoArray[i] = VerificationTypeInfo.loadVerificationTypeInfo(dataInputStream, constantPool);
        }
        return new AppendFrame(n, n2, verificationTypeInfoArray);
    }

    private static FullFrame makeFullFrame(DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        int n = dataInputStream.readUnsignedShort();
        int n2 = dataInputStream.readUnsignedShort();
        VerificationTypeInfo[] verificationTypeInfoArray = new VerificationTypeInfo[n2];
        for (int i = 0; i < verificationTypeInfoArray.length; ++i) {
            verificationTypeInfoArray[i] = VerificationTypeInfo.loadVerificationTypeInfo(dataInputStream, constantPool);
        }
        n2 = dataInputStream.readUnsignedShort();
        VerificationTypeInfo[] verificationTypeInfoArray2 = new VerificationTypeInfo[n2];
        for (int i = 0; i < verificationTypeInfoArray2.length; ++i) {
            verificationTypeInfoArray2[i] = VerificationTypeInfo.loadVerificationTypeInfo(dataInputStream, constantPool);
        }
        return new FullFrame(255, n, verificationTypeInfoArray, verificationTypeInfoArray2);
    }

    StackMapFrame(int n) {
        this.frameType = n;
    }

    public final int getFrameType() {
        return this.frameType;
    }

    public abstract int getOffsetDelta();

    public static final class FullFrame
    extends StackMapFrame {
        int offset;
        VerificationTypeInfo[] locals;
        VerificationTypeInfo[] stackItems;

        FullFrame(int n, int n2, VerificationTypeInfo[] verificationTypeInfoArray, VerificationTypeInfo[] verificationTypeInfoArray2) {
            super(n);
            this.offset = n2;
            this.locals = verificationTypeInfoArray;
            this.stackItems = verificationTypeInfoArray2;
        }

        public int getOffsetDelta() {
            return this.offset;
        }

        public VerificationTypeInfo[] getLocals() {
            return (VerificationTypeInfo[])this.locals.clone();
        }

        public VerificationTypeInfo[] getStackItems() {
            return (VerificationTypeInfo[])this.stackItems.clone();
        }
    }

    public static final class AppendFrame
    extends StackMapFrame {
        int offset;
        VerificationTypeInfo[] locals;

        AppendFrame(int n, int n2, VerificationTypeInfo[] verificationTypeInfoArray) {
            super(n);
            this.offset = n2;
            this.locals = verificationTypeInfoArray;
        }

        public int getOffsetDelta() {
            return this.offset;
        }

        public VerificationTypeInfo[] getLocals() {
            return (VerificationTypeInfo[])this.locals.clone();
        }
    }

    public static final class SameFrameExtended
    extends StackMapFrame {
        int offset;

        SameFrameExtended(int n, int n2) {
            super(n);
            this.offset = n2;
        }

        public int getOffsetDelta() {
            return this.offset;
        }
    }

    public static final class ChopFrame
    extends StackMapFrame {
        int offset;

        ChopFrame(int n, int n2) {
            super(n);
            this.offset = n2;
        }

        public int getOffsetDelta() {
            return this.offset;
        }
    }

    public static final class SameLocals1StackItemFrameExtended
    extends StackMapFrame {
        int offset;
        VerificationTypeInfo typeInfo;

        SameLocals1StackItemFrameExtended(int n, int n2, VerificationTypeInfo verificationTypeInfo) {
            super(n);
            this.offset = n2;
            this.typeInfo = verificationTypeInfo;
        }

        public int getOffsetDelta() {
            return this.offset;
        }

        public VerificationTypeInfo getVerificationTypeInfo() {
            return this.typeInfo;
        }
    }

    public static final class SameLocals1StackItemFrame
    extends StackMapFrame {
        VerificationTypeInfo typeInfo;

        SameLocals1StackItemFrame(int n, VerificationTypeInfo verificationTypeInfo) {
            super(n);
            this.typeInfo = verificationTypeInfo;
        }

        public int getOffsetDelta() {
            return this.frameType - 64;
        }

        public VerificationTypeInfo getVerificationTypeInfo() {
            return this.typeInfo;
        }
    }

    public static final class SameFrame
    extends StackMapFrame {
        SameFrame(int n) {
            super(n);
        }

        public int getOffsetDelta() {
            return this.frameType;
        }
    }
}

