/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.classfile;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.netbeans.modules.classfile.Access;
import org.netbeans.modules.classfile.Annotation;
import org.netbeans.modules.classfile.AttributeMap;
import org.netbeans.modules.classfile.CPUTF8Info;
import org.netbeans.modules.classfile.ClassFile;
import org.netbeans.modules.classfile.ClassName;
import org.netbeans.modules.classfile.ConstantPool;
import org.netbeans.modules.classfile.InvalidClassFileAttributeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Field {
    private int iName;
    private int iType;
    private String _name;
    private String _type;
    int access;
    ClassFile classFile;
    Map<ClassName, Annotation> annotations;
    String typeSignature;
    AttributeMap attributes;

    Field(DataInputStream dataInputStream, ConstantPool constantPool, ClassFile classFile, boolean bl) throws IOException {
        this.access = dataInputStream.readUnsignedShort();
        this.iName = dataInputStream.readUnsignedShort();
        this.iType = dataInputStream.readUnsignedShort();
        this.classFile = classFile;
        this.attributes = AttributeMap.load(dataInputStream, constantPool, bl);
    }

    Field(String string, String string2, ClassFile classFile) {
        this.access = 0;
        this._name = string;
        this._type = string2;
        this.classFile = classFile;
        this.attributes = new AttributeMap(new HashMap<String, byte[]>(1));
    }

    public final String getName() {
        if (this._name == null && this.iName != 0) {
            CPUTF8Info cPUTF8Info = (CPUTF8Info)this.classFile.constantPool.get(this.iName);
            this._name = cPUTF8Info.getName();
        }
        return this._name;
    }

    public final String getDescriptor() {
        if (this._type == null && this.iType != 0) {
            CPUTF8Info cPUTF8Info = (CPUTF8Info)this.classFile.constantPool.get(this.iType);
            this._type = cPUTF8Info.getName();
        }
        return this._type;
    }

    public abstract String getDeclaration();

    public final int getAccess() {
        return this.access;
    }

    public final boolean isStatic() {
        return Access.isStatic(this.access);
    }

    public final boolean isPublic() {
        return Access.isPublic(this.access);
    }

    public final boolean isProtected() {
        return Access.isProtected(this.access);
    }

    public final boolean isPackagePrivate() {
        return Access.isPackagePrivate(this.access);
    }

    public final boolean isPrivate() {
        return Access.isPrivate(this.access);
    }

    public final boolean isDeprecated() {
        return this.attributes.get("Deprecated") != null;
    }

    public final boolean isSynthetic() {
        return this.attributes.get("Synthetic") != null;
    }

    public final ClassFile getClassFile() {
        return this.classFile;
    }

    public String getTypeSignature() {
        DataInputStream dataInputStream;
        if (this.typeSignature == null && (dataInputStream = this.attributes.getStream("Signature")) != null) {
            try {
                int n = dataInputStream.readUnsignedShort();
                CPUTF8Info cPUTF8Info = (CPUTF8Info)this.classFile.constantPool.get(n);
                this.typeSignature = cPUTF8Info.getName();
                dataInputStream.close();
            }
            catch (IOException iOException) {
                throw new InvalidClassFileAttributeException("invalid Signature attribute", iOException);
            }
        }
        return this.typeSignature;
    }

    void setTypeSignature(String string) {
        this.typeSignature = string;
    }

    public final Collection<Annotation> getAnnotations() {
        this.loadAnnotations();
        return this.annotations.values();
    }

    public final Annotation getAnnotation(ClassName className) {
        this.loadAnnotations();
        return this.annotations.get(className);
    }

    public final boolean isAnnotationPresent(ClassName className) {
        this.loadAnnotations();
        return this.annotations.get(className) != null;
    }

    public final AttributeMap getAttributes() {
        return this.attributes;
    }

    void loadAnnotations() {
        if (this.annotations == null) {
            this.annotations = ClassFile.buildAnnotationMap(this.classFile.constantPool, this.attributes);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.getName();
        if (string != null) {
            stringBuffer.append(this.getName());
            stringBuffer.append(' ');
        }
        if (this.isSynthetic()) {
            stringBuffer.append("(synthetic)");
        }
        if (this.isDeprecated()) {
            stringBuffer.append("(deprecated)");
        }
        stringBuffer.append("type=");
        stringBuffer.append(this.getDescriptor());
        if (this.getTypeSignature() != null) {
            stringBuffer.append(", signature=");
            stringBuffer.append(this.typeSignature);
        }
        stringBuffer.append(", access=");
        stringBuffer.append(Access.toString(this.access));
        this.loadAnnotations();
        if (this.annotations.size() > 0) {
            Iterator<Annotation> iterator = this.annotations.values().iterator();
            stringBuffer.append(", annotations={ ");
            while (iterator.hasNext()) {
                stringBuffer.append(iterator.next().toString());
                if (!iterator.hasNext()) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append(" }");
        }
        return stringBuffer.toString();
    }
}

