/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.visualeditor.querymodel;

import java.util.Collection;
import org.netbeans.api.db.sql.support.SQLIdentifiers;
import org.netbeans.modules.db.sql.visualeditor.querymodel.ColumnNode;
import org.netbeans.modules.db.sql.visualeditor.querymodel.Expression;
import org.netbeans.modules.db.sql.visualeditor.querymodel.JoinTable;
import org.netbeans.modules.db.sql.visualeditor.querymodel.Predicate;
import org.netbeans.modules.db.sql.visualeditor.querymodel.Table;
import org.netbeans.modules.db.sql.visualeditor.querymodel.TableNode;

public class JoinTableNode
implements JoinTable {
    private String _joinType;
    private TableNode _table;
    private Expression _condition;

    public JoinTableNode() {
    }

    public JoinTableNode(TableNode tableNode, String string, Expression expression) {
        this._table = tableNode;
        this._joinType = string;
        this._condition = expression;
    }

    public JoinTableNode(TableNode tableNode) {
        this(tableNode, null, null);
    }

    public String genText(SQLIdentifiers.Quoter quoter) {
        String string = (this._joinType == null || this._joinType.equals("CROSS") ? ", " : "          " + this._joinType + " JOIN ") + this._table.genText(quoter, true);
        if (this._condition != null) {
            string = string + " ON " + this._condition.genText(quoter);
        }
        return string;
    }

    public String genText(SQLIdentifiers.Quoter quoter, boolean bl) {
        return bl ? this._table.genText(quoter, true) : this.genText(quoter);
    }

    public Table getTable() {
        return this._table;
    }

    public String getTableName() {
        return this._table.getTableName();
    }

    public String getCorrName() {
        return this._table.getCorrName();
    }

    public String getTableSpec() {
        return this._table.getTableSpec();
    }

    public String getFullTableName() {
        return this._table.getFullTableName();
    }

    public String getJoinType() {
        return this._joinType;
    }

    public void setJoinType(String string) {
        this._joinType = string;
    }

    public Expression getExpression() {
        return this._condition;
    }

    public void setExpression(Expression expression) {
        this._condition = expression;
    }

    public void getReferencedColumns(Collection collection) {
        if (this._condition != null) {
            this._condition.getReferencedColumns(collection);
        }
    }

    void renameTableSpec(String string, String string2) {
        ((TableNode)this.getTable()).renameTableSpec(string, string2);
        if (this._condition instanceof Predicate) {
            ((Predicate)this._condition).renameTableSpec(string, string2);
        }
    }

    void setTableSpec(String string, String string2) {
        ((TableNode)this.getTable()).setTableSpec(string, string2);
    }

    public void addJoinCondition(String[] stringArray) {
        ColumnNode columnNode = new ColumnNode(stringArray[0], stringArray[1]);
        ColumnNode columnNode2 = new ColumnNode(stringArray[2], stringArray[3]);
        Predicate predicate = new Predicate(columnNode, columnNode2);
        this.setJoinType("INNER");
        this.setExpression(predicate);
    }
}

