/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.internal.runtime.methods;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyModule;
import org.jruby.nb.anno.JRubyMethod;
import org.jruby.nb.exceptions.RaiseException;
import org.jruby.nb.internal.runtime.methods.JavaMethod;
import org.jruby.nb.runtime.Arity;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.RubyEvent;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;

public class ReflectedJavaMethod
extends JavaMethod {
    private final Method method;
    private final boolean needsBlock;
    private final boolean isStatic;
    private final int required;
    private final int optional;
    private final boolean rest;
    private final int max;
    private final boolean argsAsIs;
    private final boolean needsThreadContext;

    public ReflectedJavaMethod(RubyModule rubyModule, Method method, JRubyMethod jRubyMethod) {
        super(rubyModule, jRubyMethod.visibility());
        this.method = method;
        Class[] classArray = method.getParameterTypes();
        this.needsBlock = classArray.length > 0 && classArray[classArray.length - 1] == Block.class;
        this.isStatic = Modifier.isStatic(method.getModifiers());
        Arity arity = Arity.fromAnnotation(jRubyMethod, classArray, this.isStatic);
        this.setArity(arity);
        this.required = arity.getValue() >= 0 ? arity.getValue() : Math.abs(arity.getValue()) - 1;
        this.optional = jRubyMethod.optional();
        this.rest = jRubyMethod.rest();
        this.needsThreadContext = classArray.length > 0 && classArray[0] == ThreadContext.class;
        this.argsAsIs = !this.isStatic && this.optional == 0 && !this.rest && !this.needsBlock && !this.needsThreadContext;
        this.max = this.rest ? -1 : this.required + this.optional;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject[] iRubyObjectArray, Block block) {
        IRubyObject iRubyObject2;
        block30: {
            IRubyObject iRubyObject3;
            block29: {
                Ruby ruby = threadContext.getRuntime();
                Arity.checkArgumentCount(ruby, iRubyObjectArray, this.required, this.max);
                this.callConfig.pre(threadContext, iRubyObject, this.getImplementationClass(), string, block, null, this);
                try {
                    IRubyObject iRubyObject4;
                    block28: {
                        try {
                            int n;
                            if (!this.isStatic && !this.method.getDeclaringClass().isAssignableFrom(iRubyObject.getClass())) {
                                throw new ClassCastException(iRubyObject.getClass().getName() + " cannot be converted to " + this.method.getDeclaringClass().getName());
                            }
                            if (this.argsAsIs) {
                                boolean bl = ruby.hasEventHooks();
                                try {
                                    if (bl) {
                                        ruby.callEventHooks(threadContext, RubyEvent.C_CALL, threadContext.getFile(), threadContext.getLine(), string, this.getImplementationClass());
                                    }
                                    iRubyObject4 = (IRubyObject)this.method.invoke((Object)iRubyObject, (Object[])iRubyObjectArray);
                                    Object var11_16 = null;
                                    if (bl) {
                                        ruby.callEventHooks(threadContext, RubyEvent.C_RETURN, threadContext.getFile(), threadContext.getLine(), string, this.getImplementationClass());
                                    }
                                }
                                catch (Throwable throwable) {
                                    Object var11_17 = null;
                                    if (!bl) throw throwable;
                                    ruby.callEventHooks(threadContext, RubyEvent.C_RETURN, threadContext.getFile(), threadContext.getLine(), string, this.getImplementationClass());
                                    throw throwable;
                                }
                                Object var16_19 = null;
                                break block28;
                            }
                            int n2 = this.calcArgsLength();
                            Object[] objectArray = new Object[n2];
                            int n3 = 0;
                            if (this.needsThreadContext) {
                                objectArray[n3++] = threadContext;
                            }
                            if (this.isStatic) {
                                objectArray[n3++] = iRubyObject;
                            }
                            if (this.optional == 0 && !this.rest) {
                                for (n = 0; n < iRubyObjectArray.length; ++n) {
                                    objectArray[n3++] = iRubyObjectArray[n];
                                }
                            } else {
                                objectArray[n3++] = iRubyObjectArray;
                            }
                            if (this.needsBlock) {
                                objectArray[n3++] = block;
                            }
                            n = ruby.hasEventHooks() ? 1 : 0;
                            try {
                                if (n != 0) {
                                    ruby.callEventHooks(threadContext, RubyEvent.C_CALL, threadContext.getFile(), threadContext.getLine(), string, this.getImplementationClass());
                                }
                                if (this.isStatic) {
                                    iRubyObject3 = (IRubyObject)this.method.invoke(null, objectArray);
                                    Object var14_27 = null;
                                    if (n != 0) {
                                        ruby.callEventHooks(threadContext, RubyEvent.C_RETURN, threadContext.getFile(), threadContext.getLine(), string, this.getImplementationClass());
                                    }
                                    break block29;
                                }
                            }
                            catch (Throwable throwable) {
                                Object var14_29 = null;
                                if (n == 0) throw throwable;
                                ruby.callEventHooks(threadContext, RubyEvent.C_RETURN, threadContext.getFile(), threadContext.getLine(), string, this.getImplementationClass());
                                throw throwable;
                            }
                            {
                                iRubyObject2 = (IRubyObject)this.method.invoke((Object)iRubyObject, objectArray);
                                Object var14_28 = null;
                                if (n == 0) break block30;
                                ruby.callEventHooks(threadContext, RubyEvent.C_RETURN, threadContext.getFile(), threadContext.getLine(), string, this.getImplementationClass());
                            }
                            break block30;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw RaiseException.createNativeRaiseException(ruby, illegalArgumentException);
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            throw RaiseException.createNativeRaiseException(ruby, illegalAccessException);
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            Throwable throwable = invocationTargetException.getCause();
                            if (throwable instanceof RuntimeException) {
                                throw (RuntimeException)throwable;
                            }
                            if (!(throwable instanceof Error)) throw RaiseException.createNativeRaiseException(ruby, throwable);
                            throw (Error)throwable;
                        }
                    }
                    this.callConfig.post(threadContext);
                    return iRubyObject4;
                }
                catch (Throwable throwable) {
                    Object var16_22 = null;
                    this.callConfig.post(threadContext);
                    throw throwable;
                }
            }
            Object var16_20 = null;
            this.callConfig.post(threadContext);
            return iRubyObject3;
        }
        Object var16_21 = null;
        this.callConfig.post(threadContext);
        return iRubyObject2;
    }

    private int calcArgsLength() {
        int n = 0;
        if (this.needsThreadContext) {
            ++n;
        }
        if (this.isStatic) {
            ++n;
        }
        n = this.optional == 0 && !this.rest ? (n += this.required) : ++n;
        if (this.needsBlock) {
            ++n;
        }
        return n;
    }
}

