/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ext.socket;

import java.io.EOFException;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.channels.Channel;
import java.nio.channels.DatagramChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyBoolean;
import org.jruby.nb.RubyClass;
import org.jruby.nb.RubyIO;
import org.jruby.nb.RubyNumeric;
import org.jruby.nb.RubyString;
import org.jruby.nb.anno.JRubyClass;
import org.jruby.nb.anno.JRubyMethod;
import org.jruby.nb.runtime.ObjectAllocator;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.util.io.BadDescriptorException;
import org.jruby.nb.util.io.ChannelDescriptor;
import org.jruby.nb.util.io.ChannelStream;
import org.jruby.nb.util.io.InvalidValueException;
import org.jruby.nb.util.io.ModeFlags;
import org.jruby.nb.util.io.OpenFile;

@JRubyClass(name={"BasicSocket"}, parent="IO")
public class RubyBasicSocket
extends RubyIO {
    private static ObjectAllocator BASICSOCKET_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
            return new RubyBasicSocket(ruby, rubyClass);
        }
    };

    static void createBasicSocket(Ruby ruby) {
        RubyClass rubyClass = ruby.defineClass("BasicSocket", ruby.getIO(), BASICSOCKET_ALLOCATOR);
        rubyClass.defineAnnotatedMethods(RubyBasicSocket.class);
    }

    public RubyBasicSocket(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    protected void initSocket(ChannelDescriptor channelDescriptor) {
        this.registerDescriptor(channelDescriptor);
        this.openFile = new OpenFile();
        try {
            this.openFile.setMainStream(ChannelStream.fdopen(this.getRuntime(), channelDescriptor, new ModeFlags(0L)));
            this.openFile.setPipeStream(ChannelStream.fdopen(this.getRuntime(), channelDescriptor, new ModeFlags(1L)));
            this.openFile.getPipeStream().setSync(true);
        }
        catch (InvalidValueException invalidValueException) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        this.openFile.setMode(11);
    }

    public IRubyObject close_write(ThreadContext threadContext) {
        if (this.getRuntime().getSafeLevel() >= 4 && this.isTaint()) {
            throw this.getRuntime().newSecurityError("Insecure: can't close");
        }
        if (this.openFile.getPipeStream() == null && this.openFile.isReadable()) {
            throw this.getRuntime().newIOError("closing non-duplex IO for writing");
        }
        if (!this.openFile.isReadable()) {
            this.close();
        } else {
            Channel channel = this.openFile.getMainStream().getDescriptor().getChannel();
            if (channel instanceof SocketChannel || channel instanceof DatagramChannel) {
                try {
                    this.asSocket().shutdownOutput();
                }
                catch (IOException iOException) {
                    throw this.getRuntime().newIOError(iOException.getMessage());
                }
            }
            this.openFile.setPipeStream(null);
            this.openFile.setMode(this.openFile.getMode() & 0xFFFFFFFD);
        }
        return this.getRuntime().getNil();
    }

    public IRubyObject close_read(ThreadContext threadContext) {
        Ruby ruby = threadContext.getRuntime();
        if (ruby.getSafeLevel() >= 4 && this.isTaint()) {
            throw this.getRuntime().newSecurityError("Insecure: can't close");
        }
        if (!this.openFile.isWritable()) {
            this.close();
        } else if (this.openFile.getPipeStream() != null) {
            Channel channel = this.openFile.getMainStream().getDescriptor().getChannel();
            if (channel instanceof SocketChannel || channel instanceof DatagramChannel) {
                try {
                    this.asSocket().shutdownInput();
                }
                catch (IOException iOException) {
                    throw ruby.newIOError(iOException.getMessage());
                }
            }
            this.openFile.setMainStream(this.openFile.getPipeStream());
            this.openFile.setPipeStream(null);
            this.openFile.setMode(this.openFile.getMode() & 0xFFFFFFFE);
        }
        return ruby.getNil();
    }

    @JRubyMethod(name={"send"}, rest=true)
    public IRubyObject write_send(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        return this.syswrite(threadContext, iRubyObjectArray[0]);
    }

    @JRubyMethod(rest=true)
    public IRubyObject recv(IRubyObject[] iRubyObjectArray) {
        OpenFile openFile = this.getOpenFileChecked();
        try {
            return RubyString.newString(this.getRuntime(), openFile.getMainStream().read(RubyNumeric.fix2int(iRubyObjectArray[0])));
        }
        catch (BadDescriptorException badDescriptorException) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        catch (EOFException eOFException) {
            return this.getRuntime().getNil();
        }
        catch (IOException iOException) {
            if ("Socket not open".equals(iOException.getMessage())) {
                throw this.getRuntime().newIOError(iOException.getMessage());
            }
            throw this.getRuntime().newSystemCallError(iOException.getMessage());
        }
    }

    protected InetSocketAddress getLocalSocket() {
        Channel channel = this.openFile.getMainStream().getDescriptor().getChannel();
        if (channel instanceof SocketChannel) {
            return (InetSocketAddress)((SocketChannel)channel).socket().getLocalSocketAddress();
        }
        if (channel instanceof ServerSocketChannel) {
            return (InetSocketAddress)((ServerSocketChannel)channel).socket().getLocalSocketAddress();
        }
        return null;
    }

    protected InetSocketAddress getRemoteSocket() {
        Channel channel = this.openFile.getMainStream().getDescriptor().getChannel();
        if (channel instanceof SocketChannel) {
            return (InetSocketAddress)((SocketChannel)channel).socket().getRemoteSocketAddress();
        }
        return null;
    }

    private Socket asSocket() {
        Channel channel = this.openFile.getMainStream().getDescriptor().getChannel();
        if (!(channel instanceof SocketChannel)) {
            throw this.getRuntime().newErrnoENOPROTOOPTError();
        }
        return ((SocketChannel)channel).socket();
    }

    private ServerSocket asServerSocket() {
        Channel channel = this.openFile.getMainStream().getDescriptor().getChannel();
        if (!(channel instanceof ServerSocketChannel)) {
            throw this.getRuntime().newErrnoENOPROTOOPTError();
        }
        return ((ServerSocketChannel)channel).socket();
    }

    private DatagramSocket asDatagramSocket() {
        Channel channel = this.openFile.getMainStream().getDescriptor().getChannel();
        if (!(channel instanceof DatagramChannel)) {
            throw this.getRuntime().newErrnoENOPROTOOPTError();
        }
        return ((DatagramChannel)channel).socket();
    }

    private IRubyObject getBroadcast() throws IOException {
        Channel channel = this.openFile.getMainStream().getDescriptor().getChannel();
        return this.trueFalse(channel instanceof DatagramChannel ? this.asDatagramSocket().getBroadcast() : false);
    }

    private void setBroadcast(IRubyObject iRubyObject) throws IOException {
        Channel channel = this.openFile.getMainStream().getDescriptor().getChannel();
        if (channel instanceof DatagramChannel) {
            this.asDatagramSocket().setBroadcast(this.asBoolean(iRubyObject));
        }
    }

    private void setKeepAlive(IRubyObject iRubyObject) throws IOException {
        Channel channel = this.openFile.getMainStream().getDescriptor().getChannel();
        if (channel instanceof SocketChannel) {
            this.asSocket().setKeepAlive(this.asBoolean(iRubyObject));
        }
    }

    private void setReuseAddr(IRubyObject iRubyObject) throws IOException {
        Channel channel = this.openFile.getMainStream().getDescriptor().getChannel();
        if (channel instanceof ServerSocketChannel) {
            this.asServerSocket().setReuseAddress(this.asBoolean(iRubyObject));
        }
    }

    private void setRcvBuf(IRubyObject iRubyObject) throws IOException {
        Channel channel = this.openFile.getMainStream().getDescriptor().getChannel();
        if (channel instanceof SocketChannel) {
            this.asSocket().setReceiveBufferSize(this.asNumber(iRubyObject));
        } else if (channel instanceof ServerSocketChannel) {
            this.asServerSocket().setReceiveBufferSize(this.asNumber(iRubyObject));
        } else if (channel instanceof DatagramChannel) {
            this.asDatagramSocket().setReceiveBufferSize(this.asNumber(iRubyObject));
        }
    }

    private void setTimeout(IRubyObject iRubyObject) throws IOException {
        Channel channel = this.openFile.getMainStream().getDescriptor().getChannel();
        if (channel instanceof SocketChannel) {
            this.asSocket().setSoTimeout(this.asNumber(iRubyObject));
        } else if (channel instanceof ServerSocketChannel) {
            this.asServerSocket().setSoTimeout(this.asNumber(iRubyObject));
        } else if (channel instanceof DatagramChannel) {
            this.asDatagramSocket().setSoTimeout(this.asNumber(iRubyObject));
        }
    }

    private void setSndBuf(IRubyObject iRubyObject) throws IOException {
        Channel channel = this.openFile.getMainStream().getDescriptor().getChannel();
        if (channel instanceof SocketChannel) {
            this.asSocket().setSendBufferSize(this.asNumber(iRubyObject));
        } else if (channel instanceof DatagramChannel) {
            this.asDatagramSocket().setSendBufferSize(this.asNumber(iRubyObject));
        }
    }

    private void setLinger(IRubyObject iRubyObject) throws IOException {
        Channel channel = this.openFile.getMainStream().getDescriptor().getChannel();
        if (channel instanceof SocketChannel) {
            if (iRubyObject instanceof RubyBoolean && !iRubyObject.isTrue()) {
                this.asSocket().setSoLinger(false, 0);
            } else {
                int n = this.asNumber(iRubyObject);
                if (n == -1) {
                    this.asSocket().setSoLinger(false, 0);
                } else {
                    this.asSocket().setSoLinger(true, n);
                }
            }
        }
    }

    private void setOOBInline(IRubyObject iRubyObject) throws IOException {
        Channel channel = this.openFile.getMainStream().getDescriptor().getChannel();
        if (channel instanceof SocketChannel) {
            this.asSocket().setOOBInline(this.asBoolean(iRubyObject));
        }
    }

    private int asNumber(IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyNumeric) {
            return RubyNumeric.fix2int(iRubyObject);
        }
        return this.stringAsNumber(iRubyObject);
    }

    private int stringAsNumber(IRubyObject iRubyObject) {
        String string = iRubyObject.convertToString().toString();
        int n = 0;
        n += string.charAt(0) << 24;
        n += string.charAt(1) << 16;
        n += string.charAt(2) << 8;
        return n += string.charAt(3);
    }

    protected boolean asBoolean(IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyString) {
            return this.stringAsNumber(iRubyObject) != 0;
        }
        if (iRubyObject instanceof RubyNumeric) {
            return RubyNumeric.fix2int(iRubyObject) != 0;
        }
        return iRubyObject.isTrue();
    }

    private IRubyObject getKeepAlive() throws IOException {
        Channel channel = this.openFile.getMainStream().getDescriptor().getChannel();
        return this.trueFalse(channel instanceof SocketChannel ? this.asSocket().getKeepAlive() : false);
    }

    private IRubyObject getLinger() throws IOException {
        Channel channel = this.openFile.getMainStream().getDescriptor().getChannel();
        return this.number(channel instanceof SocketChannel ? (long)this.asSocket().getSoLinger() : 0L);
    }

    private IRubyObject getOOBInline() throws IOException {
        Channel channel = this.openFile.getMainStream().getDescriptor().getChannel();
        return this.trueFalse(channel instanceof SocketChannel ? this.asSocket().getOOBInline() : false);
    }

    private IRubyObject getRcvBuf() throws IOException {
        Channel channel = this.openFile.getMainStream().getDescriptor().getChannel();
        return this.number(channel instanceof SocketChannel ? (long)this.asSocket().getReceiveBufferSize() : (long)(channel instanceof ServerSocketChannel ? this.asServerSocket().getReceiveBufferSize() : this.asDatagramSocket().getReceiveBufferSize()));
    }

    private IRubyObject getSndBuf() throws IOException {
        Channel channel = this.openFile.getMainStream().getDescriptor().getChannel();
        return this.number(channel instanceof SocketChannel ? (long)this.asSocket().getSendBufferSize() : (long)(channel instanceof DatagramChannel ? this.asDatagramSocket().getSendBufferSize() : 0));
    }

    private IRubyObject getReuseAddr() throws IOException {
        Channel channel = this.openFile.getMainStream().getDescriptor().getChannel();
        return this.trueFalse(channel instanceof ServerSocketChannel ? this.asServerSocket().getReuseAddress() : false);
    }

    private IRubyObject getTimeout() throws IOException {
        Channel channel = this.openFile.getMainStream().getDescriptor().getChannel();
        return this.number(channel instanceof SocketChannel ? (long)this.asSocket().getSoTimeout() : (long)(channel instanceof ServerSocketChannel ? this.asServerSocket().getSoTimeout() : (channel instanceof DatagramChannel ? this.asDatagramSocket().getSoTimeout() : 0)));
    }

    protected int getSoTypeDefault() {
        return 0;
    }

    private IRubyObject getSoType() throws IOException {
        Channel channel = this.openFile.getMainStream().getDescriptor().getChannel();
        return this.number(channel instanceof SocketChannel ? 1L : (long)(channel instanceof ServerSocketChannel ? 1 : (channel instanceof DatagramChannel ? 2 : this.getSoTypeDefault())));
    }

    private IRubyObject trueFalse(boolean bl) {
        return this.getRuntime().newString(bl ? " \u0000\u0000\u0000" : "\u0000\u0000\u0000\u0000");
    }

    private IRubyObject number(long l) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append((char)(l >> 24 & 0xFFL)).append((char)(l >> 16 & 0xFFL));
        stringBuilder.append((char)(l >> 8 & 0xFFL)).append((char)(l & 0xFFL));
        return this.getRuntime().newString(stringBuilder.toString());
    }

    @JRubyMethod
    public IRubyObject getsockopt(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        int n = RubyNumeric.fix2int(iRubyObject);
        int n2 = RubyNumeric.fix2int(iRubyObject2);
        try {
            switch (n) {
                case 0: 
                case 6: 
                case 17: 
                case 65535: {
                    switch (n2) {
                        case 32: {
                            return this.getBroadcast();
                        }
                        case 8: {
                            return this.getKeepAlive();
                        }
                        case 128: {
                            return this.getLinger();
                        }
                        case 256: {
                            return this.getOOBInline();
                        }
                        case 4098: {
                            return this.getRcvBuf();
                        }
                        case 4: {
                            return this.getReuseAddr();
                        }
                        case 4097: {
                            return this.getSndBuf();
                        }
                        case 4101: 
                        case 4102: {
                            return this.getTimeout();
                        }
                        case 4104: {
                            return this.getSoType();
                        }
                        case 4100: {
                            return this.number(1L);
                        }
                        case 4099: {
                            return this.number(2048L);
                        }
                        case 1: 
                        case 16: 
                        case 1024: 
                        case 4103: {
                            return this.trueFalse(false);
                        }
                    }
                    throw this.getRuntime().newErrnoENOPROTOOPTError();
                }
            }
            throw this.getRuntime().newErrnoENOPROTOOPTError();
        }
        catch (IOException iOException) {
            throw this.getRuntime().newErrnoENOPROTOOPTError();
        }
    }

    @JRubyMethod
    public IRubyObject setsockopt(IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        int n = RubyNumeric.fix2int(iRubyObject);
        int n2 = RubyNumeric.fix2int(iRubyObject2);
        try {
            block1 : switch (n) {
                case 0: 
                case 6: 
                case 17: 
                case 65535: {
                    switch (n2) {
                        case 32: {
                            this.setBroadcast(iRubyObject3);
                            break block1;
                        }
                        case 8: {
                            this.setKeepAlive(iRubyObject3);
                            break block1;
                        }
                        case 128: {
                            this.setLinger(iRubyObject3);
                            break block1;
                        }
                        case 256: {
                            this.setOOBInline(iRubyObject3);
                            break block1;
                        }
                        case 4098: {
                            this.setRcvBuf(iRubyObject3);
                            break block1;
                        }
                        case 4: {
                            this.setReuseAddr(iRubyObject3);
                            break block1;
                        }
                        case 4097: {
                            this.setSndBuf(iRubyObject3);
                            break block1;
                        }
                        case 4101: 
                        case 4102: {
                            this.setTimeout(iRubyObject3);
                            break block1;
                        }
                        case 1: 
                        case 16: 
                        case 1024: 
                        case 4099: 
                        case 4100: 
                        case 4103: 
                        case 4104: {
                            break block1;
                        }
                    }
                    throw this.getRuntime().newErrnoENOPROTOOPTError();
                }
                default: {
                    throw this.getRuntime().newErrnoENOPROTOOPTError();
                }
            }
        }
        catch (IOException iOException) {
            throw this.getRuntime().newErrnoENOPROTOOPTError();
        }
        return this.getRuntime().newFixnum(0);
    }

    @JRubyMethod(name={"getsockname", "__getsockname"})
    public IRubyObject getsockname() {
        InetSocketAddress inetSocketAddress = this.getLocalSocket();
        if (null == inetSocketAddress) {
            throw this.getRuntime().newIOError("Not Supported");
        }
        return this.getRuntime().newString(((Object)inetSocketAddress).toString());
    }

    @JRubyMethod(name={"getpeername", "__getpeername"})
    public IRubyObject getpeername() {
        InetSocketAddress inetSocketAddress = this.getRemoteSocket();
        if (null == inetSocketAddress) {
            throw this.getRuntime().newIOError("Not Supported");
        }
        return this.getRuntime().newString(((Object)inetSocketAddress).toString());
    }

    @JRubyMethod(optional=1)
    public IRubyObject shutdown(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        if (this.getRuntime().getSafeLevel() >= 4 && this.tainted_p(threadContext).isFalse()) {
            throw this.getRuntime().newSecurityError("Insecure: can't shutdown socket");
        }
        int n = 2;
        if (iRubyObjectArray.length > 0) {
            n = RubyNumeric.fix2int(iRubyObjectArray[0]);
        }
        if (n < 0 || 2 < n) {
            throw this.getRuntime().newArgumentError("`how' should be either 0, 1, 2");
        }
        if (n != 2) {
            throw this.getRuntime().newNotImplementedError("Shutdown currently only works with how=2");
        }
        return this.close();
    }

    @JRubyMethod(meta=true)
    public static IRubyObject do_not_reverse_lookup(IRubyObject iRubyObject) {
        return iRubyObject.getRuntime().isDoNotReverseLookupEnabled() ? iRubyObject.getRuntime().getTrue() : iRubyObject.getRuntime().getFalse();
    }

    @JRubyMethod(name={"do_not_reverse_lookup="}, meta=true)
    public static IRubyObject set_do_not_reverse_lookup(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        iRubyObject.getRuntime().setDoNotReverseLookupEnabled(iRubyObject2.isTrue());
        return iRubyObject.getRuntime().isDoNotReverseLookupEnabled() ? iRubyObject.getRuntime().getTrue() : iRubyObject.getRuntime().getFalse();
    }
}

