/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jruby.nb.CompatVersion;
import org.jruby.nb.Profile;
import org.jruby.nb.Ruby;
import org.jruby.nb.ast.executable.Script;
import org.jruby.nb.exceptions.MainExitException;
import org.jruby.nb.runtime.Constants;
import org.jruby.nb.runtime.load.LoadService;
import org.jruby.nb.util.ClassCache;
import org.jruby.nb.util.JRubyFile;
import org.jruby.nb.util.KCode;
import org.jruby.nb.util.NormalizedFile;
import org.jruby.nb.util.SafePropertyAccessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RubyInstanceConfig {
    private static final int JIT_MAX_METHODS_LIMIT = 4096;
    private static final int JIT_MAX_SIZE_LIMIT = Integer.MAX_VALUE;
    private static final int JIT_THRESHOLD = 50;
    public static final int JAVA_VERSION;
    private static final int CHAINED_COMPILE_LINE_COUNT_DEFAULT = 500;
    public static final int CHAINED_COMPILE_LINE_COUNT;
    private InputStream input = System.in;
    private PrintStream output = System.out;
    private PrintStream error = System.err;
    private Profile profile = Profile.DEFAULT;
    private boolean objectSpaceEnabled = SafePropertyAccessor.getBoolean("jruby.objectspace.enabled", false);
    private CompileMode compileMode = CompileMode.JIT;
    private boolean runRubyInProcess = true;
    private String currentDirectory;
    private Map environment;
    private String[] argv = new String[0];
    private final boolean jitLogging;
    private final boolean jitLoggingVerbose;
    private final int jitLogEvery;
    private final int jitThreshold;
    private final int jitMax;
    private final int jitMaxSize;
    private final boolean samplingEnabled;
    private CompatVersion compatVersion;
    private ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
    private ClassLoader loader = this.contextLoader == null ? RubyInstanceConfig.class.getClassLoader() : this.contextLoader;
    private ClassCache<Script> classCache;
    private List<String> loadPaths = new ArrayList<String>();
    private Set<String> excludedMethods = new HashSet<String>();
    private StringBuffer inlineScript = new StringBuffer();
    private boolean hasInlineScript = false;
    private String scriptFileName = null;
    private List<String> requiredLibraries = new ArrayList<String>();
    private boolean benchmarking = false;
    private boolean argvGlobalsOn = false;
    private boolean assumeLoop = false;
    private boolean assumePrinting = false;
    private Map optionGlobals = new HashMap();
    private boolean processLineEnds = false;
    private boolean split = false;
    private Boolean verbose = Boolean.FALSE;
    private boolean debug = false;
    private boolean showVersion = false;
    private boolean showBytecode = false;
    private boolean showCopyright = false;
    private boolean endOfArguments = false;
    private boolean shouldRunInterpreter = true;
    private boolean shouldPrintUsage = false;
    private boolean shouldPrintProperties = false;
    private boolean yarv = false;
    private boolean rubinius = false;
    private boolean yarvCompile = false;
    private KCode kcode = KCode.NONE;
    private String recordSeparator = "\n";
    private boolean shouldCheckSyntax = false;
    private String inputFieldSeparator = null;
    private boolean managementEnabled = true;
    private int safeLevel = 0;
    private String jrubyHome;
    public static final boolean FASTEST_COMPILE_ENABLED;
    public static final boolean BOXED_COMPILE_ENABLED;
    public static final boolean FASTOPS_COMPILE_ENABLED;
    public static final boolean FRAMELESS_COMPILE_ENABLED;
    public static final boolean POSITIONLESS_COMPILE_ENABLED;
    public static final boolean THREADLESS_COMPILE_ENABLED;
    public static final boolean LAZYHANDLES_COMPILE;
    public static final boolean FORK_ENABLED;
    public static final boolean POOLING_ENABLED;
    public static final int POOL_MAX;
    public static final int POOL_MIN;
    public static final int POOL_TTL;
    public static final boolean NATIVE_NET_PROTOCOL;
    public static boolean FULL_TRACE_ENABLED;
    public static final String COMPILE_EXCLUDE;
    public static boolean nativeEnabled;
    private LoadServiceCreator creator = LoadServiceCreator.DEFAULT;
    public int characterIndex = 0;

    public RubyInstanceConfig() {
        this.currentDirectory = Ruby.isSecurityRestricted() ? "/" : JRubyFile.getFileProperty("user.dir");
        this.samplingEnabled = SafePropertyAccessor.getBoolean("jruby.sampling.enabled", false);
        String string = SafePropertyAccessor.getProperty("jruby.compat.version", "RUBY1_8");
        if (string.equalsIgnoreCase("RUBY1_8")) {
            this.compatVersion = CompatVersion.RUBY1_8;
        } else if (string.equalsIgnoreCase("RUBY1_9")) {
            this.compatVersion = CompatVersion.RUBY1_9;
        } else {
            System.err.println("Compatibility version `" + string + "' invalid; use RUBY1_8 or RUBY1_9. Using RUBY1_8.");
            this.compatVersion = CompatVersion.RUBY1_8;
        }
        if (Ruby.isSecurityRestricted()) {
            this.compileMode = CompileMode.OFF;
            this.jitLogging = false;
            this.jitLoggingVerbose = false;
            this.jitLogEvery = 0;
            this.jitThreshold = -1;
            this.jitMax = 0;
            this.jitMaxSize = -1;
            this.managementEnabled = false;
        } else {
            Object object;
            boolean bl;
            String string2 = SafePropertyAccessor.getProperty("jruby.jit.threshold");
            String string3 = SafePropertyAccessor.getProperty("jruby.jit.max");
            String string4 = SafePropertyAccessor.getProperty("jruby.jit.maxsize");
            if (COMPILE_EXCLUDE != null) {
                String[] stringArray = COMPILE_EXCLUDE.split(",");
                for (String string5 : stringArray) {
                    this.excludedMethods.add(string5);
                }
            }
            this.managementEnabled = SafePropertyAccessor.getBoolean("jruby.management.enabled", true);
            this.runRubyInProcess = SafePropertyAccessor.getBoolean("jruby.launch.inproc", true);
            boolean bl2 = bl = SafePropertyAccessor.getProperty("jruby.jit.enabled") != null;
            if (bl) {
                this.error.print("jruby.jit.enabled property is deprecated; use jruby.compile.mode=(OFF|JIT|FORCE) for -C, default, and +C flags");
                this.compileMode = SafePropertyAccessor.getBoolean("jruby.jit.enabled") ? CompileMode.JIT : CompileMode.OFF;
            } else {
                object = SafePropertyAccessor.getProperty("jruby.compile.mode", "JIT");
                if (((String)object).equals("OFF")) {
                    this.compileMode = CompileMode.OFF;
                } else if (((String)object).equals("JIT")) {
                    this.compileMode = CompileMode.JIT;
                } else if (((String)object).equals("FORCE")) {
                    this.compileMode = CompileMode.FORCE;
                } else {
                    this.error.print("jruby.compile.mode property must be OFF, JIT, FORCE, or unset; defaulting to JIT");
                    this.compileMode = CompileMode.JIT;
                }
            }
            this.jitLogging = SafePropertyAccessor.getBoolean("jruby.jit.logging");
            this.jitLoggingVerbose = SafePropertyAccessor.getBoolean("jruby.jit.logging.verbose");
            object = SafePropertyAccessor.getProperty("jruby.jit.logEvery");
            this.jitLogEvery = object == null ? 0 : Integer.parseInt((String)object);
            this.jitThreshold = string2 == null ? 50 : Integer.parseInt(string2);
            this.jitMax = string3 == null ? 4096 : Integer.parseInt(string3);
            this.jitMaxSize = string4 == null ? Integer.MAX_VALUE : Integer.parseInt(string4);
        }
        this.classCache = new ClassCache(this.loader, this.jitMax);
        if (FORK_ENABLED) {
            this.error.print("WARNING: fork is highly unlikely to be safe or stable on the JVM. Have fun!\n");
        }
    }

    public LoadServiceCreator getLoadServiceCreator() {
        return this.creator;
    }

    public void setLoadServiceCreator(LoadServiceCreator loadServiceCreator) {
        this.creator = loadServiceCreator;
    }

    public LoadService createLoadService(Ruby ruby) {
        return this.creator.create(ruby);
    }

    public String getBasicUsageHelp() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Usage: jruby [switches] [--] [programfile] [arguments]\n").append("  -0[octal]       specify record separator (\u0000, if no argument)\n").append("  -a              autosplit mode with -n or -p (splits $_ into $F)\n").append("  -b              benchmark mode, times the script execution\n").append("  -c              check syntax only\n").append("  -Cdirectory     cd to directory, before executing your script\n").append("  -d              set debugging flags (set $DEBUG to true)\n").append("  -e 'command'    one line of script. Several -e's allowed. Omit [programfile]\n").append("  -Fpattern       split() pattern for autosplit (-a)\n").append("  -Idirectory     specify $LOAD_PATH directory (may be used more than once)\n").append("  -J[java option] pass an option on to the JVM (e.g. -J-Xmx512m)\n").append("                    use --properties to list JRuby properties\n").append("                    run 'java -help' for a list of other Java options\n").append("  -Kkcode         specifies code-set (e.g. -Ku for Unicode\n").append("  -l              enable line ending processing\n").append("  -n              assume 'while gets(); ... end' loop around your script\n").append("  -p              assume loop like -n but print line also like sed\n").append("  -rlibrary       require the library, before executing your script\n").append("  -s              enable some switch parsing for switches after script name\n").append("  -S              look for the script in bin or using PATH environment variable\n").append("  -T[level]       turn on tainting checks\n").append("  -v              print version number, then turn on verbose mode\n").append("  -w              turn warnings on for your script\n").append("  -W[level]       set warning level; 0=silence, 1=medium, 2=verbose (default)\n").append("  -X[option]      enable extended option (omit option to list)\n").append("  --copyright     print the copyright\n").append("  --debug         sets the execution mode most suitable for debugger functionality\n").append("  --jdb           runs JRuby process under JDB\n").append("  --properties    List all configuration Java properties (pass -J-Dproperty=value)\n").append("  --sample        run with profiling using the JVM's sampling profiler\n").append("  --client        use the non-optimizing \"client\" JVM (improves startup; default)\n").append("  --server        use the optimizing \"server\" JVM (improves perf)\n").append("  --manage        enable remote JMX management and monitoring of the VM and JRuby\n").append("  --1.8           specify Ruby 1.8.x compatibility (default)\n").append("  --1.9           specify Ruby 1.9.x compatibility\n").append("  --bytecode      show the JVM bytecode produced by compiling specified code\n").append("  --version       print the version\n");
        return stringBuilder.toString();
    }

    public String getExtendedHelp() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("These flags are for extended JRuby options.\n").append("Specify them by passing -X<option>\n").append("  -O              run with ObjectSpace disabled (default; improves performance)\n").append("  +O              run with ObjectSpace enabled (reduces performance)\n").append("  -C              disable all compilation\n").append("  +C              force compilation of all scripts before they are run (except eval)\n").append("  -y              read a YARV-compiled Ruby script and run that (EXPERIMENTAL)\n").append("  -Y              compile a Ruby script into YARV bytecodes and run this (EXPERIMENTAL)\n").append("  -R              read a Rubinius-compiled Ruby script and run that (EXPERIMENTAL)\n");
        return stringBuilder.toString();
    }

    public String getPropertyHelp() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("These properties can be used to alter runtime behavior for perf or compatibility.\n").append("Specify them by passing -J-D<property>=<value>\n").append("\nCOMPILER SETTINGS:\n").append("    jruby.compile.mode=JIT|FORCE|OFF\n").append("       Set compilation mode. JIT is default; FORCE compiles all, OFF disables\n").append("    jruby.compile.fastest=true|false\n").append("       (EXPERIMENTAL) Turn on all experimental compiler optimizations\n").append("    jruby.compile.boxed=true|false\n").append("       (EXPERIMENTAL) Use boxed variables; this can speed up some methods. Default is false\n").append("    jruby.compile.frameless=true|false\n").append("       (EXPERIMENTAL) Turn on frameless compilation where possible\n").append("    jruby.compile.positionless=true|false\n").append("       (EXPERIMENTAL) Turn on compilation that avoids updating Ruby position info. Default is false\n").append("    jruby.compile.threadless=true|false\n").append("       (EXPERIMENTAL) Turn on compilation without polling for \"unsafe\" thread events. Default is false\n").append("    jruby.compile.fastops=true|false\n").append("       (EXPERIMENTAL) Turn on fast operators for Fixnum. Default is false\n").append("    jruby.compile.chainsize=<line count>\n").append("       Set the number of lines at which compiled bodies are \"chained\". Default is 500\n").append("    jruby.compile.lazyHandles=true|false\n").append("       Generate method bindings (handles) for compiled methods lazily. Default is false.").append("\nJIT SETTINGS:\n").append("    jruby.jit.threshold=<invocation count>\n").append("       Set the JIT threshold to the specified method invocation count. Default is 50.\n").append("    jruby.jit.max=<method count>\n").append("       Set the max count of active methods eligible for JIT-compilation.\n").append("       Default is 4096 per runtime. A value of 0 disables JIT, -1 disables max.\n").append("    jruby.jit.maxsize=<jitted method size (full .class)>\n").append("       Set the maximum full-class byte size allowed for jitted methods. Default is Integer.MAX_VALUE\n").append("    jruby.jit.logging=true|false\n").append("       Enable JIT logging (reports successful compilation). Default is false\n").append("    jruby.jit.logging.verbose=true|false\n").append("       Enable verbose JIT logging (reports failed compilation). Default is false\n").append("    jruby.jit.logEvery=<method count>\n").append("       Log a message every n methods JIT compiled. Default is 0 (off).\n").append("    jruby.jit.exclude=<ClsOrMod,ClsOrMod::method_name,-::method_name>\n").append("       Exclude methods from JIT by class/module short name, c/m::method_name,\n").append("       or -::method_name for anon/singleton classes/modules. Comma-delimited.\n").append("\nNATIVE SUPPORT:\n").append("    jruby.native.enabled=true|false\n").append("       Enable/disable native extensions (like JNA for non-Java APIs; Default is true\n").append("       (This affects all JRuby instances in a given JVM)\n").append("    jruby.native.verbose=true|false\n").append("       Enable verbose logging of native extension loading. Default is false.\n").append("    jruby.fork.enabled=true|false\n").append("       (EXPERIMENTAL, maybe dangerous) Enable fork(2) on platforms that support it.\n").append("\nTHREAD POOLING:\n").append("    jruby.thread.pool.enabled=true|false\n").append("       Enable reuse of native backing threads via a thread pool. Default is false.\n").append("    jruby.thread.pool.min=<min thread count>\n").append("       The minimum number of threads to keep alive in the pool. Default is 0.\n").append("    jruby.thread.pool.max=<max thread count>\n").append("       The maximum number of threads to allow in the pool. Default is unlimited.\n").append("    jruby.thread.pool.ttl=<time to live, in seconds>\n").append("       The maximum number of seconds to keep alive an idle thread. Default is 60.\n").append("\nMISCELLANY:\n").append("    jruby.compat.version=RUBY1_8|RUBY1_9\n").append("       Specify the major Ruby version to be compatible with; Default is RUBY1_8\n").append("    jruby.objectspace.enabled=true|false\n").append("       Enable or disable ObjectSpace.each_object (default is disabled)\n").append("    jruby.launch.inproc=true|false\n").append("       Set in-process launching of e.g. system('ruby ...'). Default is true\n").append("    jruby.bytecode.version=1.5|1.6\n").append("       Set bytecode version for JRuby to generate. Default is current JVM version.\n").append("    jruby.management.enabled=true|false\n").append("       Set whether JMX management is enabled. Default is true.\n").append("    jruby.debug.fullTrace=true|false\n").append("       Set whether full traces are enabled (c-call/c-return). Default is false.\n");
        return stringBuilder.toString();
    }

    public String getVersionString() {
        String string = Constants.RUBY_VERSION;
        switch (this.compatVersion) {
            case RUBY1_8: {
                string = Constants.RUBY_VERSION;
                break;
            }
            case RUBY1_9: {
                string = Constants.RUBY1_9_VERSION;
            }
        }
        String string2 = String.format("jruby %s (ruby %s patchlevel %s) (%s rev %s) [%s-java]\n", Constants.VERSION, string, Constants.RUBY_PATCHLEVEL, Constants.COMPILE_DATE, Constants.REVISION, SafePropertyAccessor.getProperty("os.arch", "unknown"));
        return string2;
    }

    public String getCopyrightString() {
        return "JRuby - Copyright (C) 2001-2008 The JRuby Community (and contribs)\n";
    }

    public void processArguments(String[] stringArray) {
        new ArgumentProcessor(stringArray).processArguments();
    }

    public CompileMode getCompileMode() {
        return this.compileMode;
    }

    public void setCompileMode(CompileMode compileMode) {
        this.compileMode = compileMode;
    }

    public boolean isJitLogging() {
        return this.jitLogging;
    }

    public boolean isJitLoggingVerbose() {
        return this.jitLoggingVerbose;
    }

    public int getJitLogEvery() {
        return this.jitLogEvery;
    }

    public boolean isSamplingEnabled() {
        return this.samplingEnabled;
    }

    public int getJitThreshold() {
        return this.jitThreshold;
    }

    public int getJitMax() {
        return this.jitMax;
    }

    public int getJitMaxSize() {
        return this.jitMaxSize;
    }

    public boolean isRunRubyInProcess() {
        return this.runRubyInProcess;
    }

    public void setRunRubyInProcess(boolean bl) {
        this.runRubyInProcess = bl;
    }

    public void setInput(InputStream inputStream) {
        this.input = inputStream;
    }

    public InputStream getInput() {
        return this.input;
    }

    public CompatVersion getCompatVersion() {
        return this.compatVersion;
    }

    public void setOutput(PrintStream printStream) {
        this.output = printStream;
    }

    public PrintStream getOutput() {
        return this.output;
    }

    public void setError(PrintStream printStream) {
        this.error = printStream;
    }

    public PrintStream getError() {
        return this.error;
    }

    public void setCurrentDirectory(String string) {
        this.currentDirectory = string;
    }

    public String getCurrentDirectory() {
        return this.currentDirectory;
    }

    public void setProfile(Profile profile) {
        this.profile = profile;
    }

    public Profile getProfile() {
        return this.profile;
    }

    public void setObjectSpaceEnabled(boolean bl) {
        this.objectSpaceEnabled = bl;
    }

    public boolean isObjectSpaceEnabled() {
        return this.objectSpaceEnabled;
    }

    public void setEnvironment(Map map) {
        this.environment = map;
    }

    public Map getEnvironment() {
        return this.environment;
    }

    public ClassLoader getLoader() {
        return this.loader;
    }

    public void setLoader(ClassLoader classLoader) {
        if (this.loader != classLoader) {
            this.classCache = new ClassCache(classLoader, this.classCache.getMax());
        }
        this.loader = classLoader;
    }

    public String[] getArgv() {
        return this.argv;
    }

    public void setArgv(String[] stringArray) {
        this.argv = stringArray;
    }

    public String getJRubyHome() {
        if (this.jrubyHome == null) {
            if (Ruby.isSecurityRestricted()) {
                return "SECURITY RESTRICTED";
            }
            this.jrubyHome = this.verifyHome(SafePropertyAccessor.getProperty("jruby.home", SafePropertyAccessor.getProperty("user.home") + "/.jruby"));
            try {
                this.jrubyHome = new NormalizedFile(this.jrubyHome).getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.jrubyHome = new NormalizedFile(this.jrubyHome).getAbsolutePath();
        }
        return this.jrubyHome;
    }

    public void setJRubyHome(String string) {
        this.jrubyHome = this.verifyHome(string);
    }

    private String verifyHome(String string) {
        if (string.equals(".")) {
            string = System.getProperty("user.dir");
        }
        if (!string.startsWith("file:")) {
            NormalizedFile normalizedFile = new NormalizedFile(string);
            if (!normalizedFile.isAbsolute()) {
                string = normalizedFile.getAbsolutePath();
            }
            normalizedFile.mkdirs();
        }
        return string;
    }

    public byte[] inlineScript() {
        return this.inlineScript.toString().getBytes();
    }

    public List<String> requiredLibraries() {
        return this.requiredLibraries;
    }

    public List<String> loadPaths() {
        return this.loadPaths;
    }

    public boolean shouldRunInterpreter() {
        if (this.isShowVersion() && (this.hasInlineScript || this.scriptFileName != null)) {
            return true;
        }
        return this.isShouldRunInterpreter();
    }

    public boolean shouldPrintUsage() {
        return this.shouldPrintUsage;
    }

    public boolean shouldPrintProperties() {
        return this.shouldPrintProperties;
    }

    private boolean isSourceFromStdin() {
        return this.getScriptFileName() == null;
    }

    public boolean isInlineScript() {
        return this.hasInlineScript;
    }

    public InputStream getScriptSource() {
        try {
            if (this.hasInlineScript) {
                return new ByteArrayInputStream(this.inlineScript());
            }
            if (this.isSourceFromStdin()) {
                if (this.isShowVersion()) {
                    return null;
                }
                return this.getInput();
            }
            JRubyFile jRubyFile = JRubyFile.create(this.getCurrentDirectory(), this.getScriptFileName());
            return new BufferedInputStream(new FileInputStream(jRubyFile));
        }
        catch (IOException iOException) {
            throw new MainExitException(1, "Error opening script file: " + iOException.getMessage());
        }
    }

    public String displayedFileName() {
        if (this.hasInlineScript) {
            if (this.scriptFileName != null) {
                return this.scriptFileName;
            }
            return "-e";
        }
        if (this.isSourceFromStdin()) {
            return "-";
        }
        return this.getScriptFileName();
    }

    private void setScriptFileName(String string) {
        this.scriptFileName = string;
    }

    public String getScriptFileName() {
        return this.scriptFileName;
    }

    public boolean isBenchmarking() {
        return this.benchmarking;
    }

    public boolean isAssumeLoop() {
        return this.assumeLoop;
    }

    public boolean isAssumePrinting() {
        return this.assumePrinting;
    }

    public boolean isProcessLineEnds() {
        return this.processLineEnds;
    }

    public boolean isSplit() {
        return this.split;
    }

    public boolean isVerbose() {
        return this.verbose == Boolean.TRUE;
    }

    public Boolean getVerbose() {
        return this.verbose;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isShowVersion() {
        return this.showVersion;
    }

    public boolean isShowBytecode() {
        return this.showBytecode;
    }

    public boolean isShowCopyright() {
        return this.showCopyright;
    }

    protected void setShowVersion(boolean bl) {
        this.showVersion = bl;
    }

    protected void setShowBytecode(boolean bl) {
        this.showBytecode = bl;
    }

    protected void setShowCopyright(boolean bl) {
        this.showCopyright = bl;
    }

    public boolean isShouldRunInterpreter() {
        return this.shouldRunInterpreter;
    }

    public boolean isShouldCheckSyntax() {
        return this.shouldCheckSyntax;
    }

    public boolean isYARVEnabled() {
        return this.yarv;
    }

    public String getInputFieldSeparator() {
        return this.inputFieldSeparator;
    }

    public boolean isRubiniusEnabled() {
        return this.rubinius;
    }

    public boolean isYARVCompileEnabled() {
        return this.yarvCompile;
    }

    public KCode getKCode() {
        return this.kcode;
    }

    public String getRecordSeparator() {
        return this.recordSeparator;
    }

    public int getSafeLevel() {
        return this.safeLevel;
    }

    public void setRecordSeparator(String string) {
        this.recordSeparator = string;
    }

    public ClassCache getClassCache() {
        return this.classCache;
    }

    public void setClassCache(ClassCache classCache) {
        this.classCache = classCache;
    }

    public Map getOptionGlobals() {
        return this.optionGlobals;
    }

    public boolean isManagementEnabled() {
        return this.managementEnabled;
    }

    public Set getExcludedMethods() {
        return this.excludedMethods;
    }

    static /* synthetic */ String[] access$502(RubyInstanceConfig rubyInstanceConfig, String[] stringArray) {
        rubyInstanceConfig.argv = stringArray;
        return stringArray;
    }

    static {
        CHAINED_COMPILE_LINE_COUNT = SafePropertyAccessor.getInt("jruby.compile.chainsize", 500);
        FASTEST_COMPILE_ENABLED = SafePropertyAccessor.getBoolean("jruby.compile.fastest");
        BOXED_COMPILE_ENABLED = FASTEST_COMPILE_ENABLED || SafePropertyAccessor.getBoolean("jruby.compile.boxed");
        FASTOPS_COMPILE_ENABLED = FASTEST_COMPILE_ENABLED || SafePropertyAccessor.getBoolean("jruby.compile.fastops");
        FRAMELESS_COMPILE_ENABLED = FASTEST_COMPILE_ENABLED || SafePropertyAccessor.getBoolean("jruby.compile.frameless");
        POSITIONLESS_COMPILE_ENABLED = FASTEST_COMPILE_ENABLED || SafePropertyAccessor.getBoolean("jruby.compile.positionless");
        THREADLESS_COMPILE_ENABLED = FASTEST_COMPILE_ENABLED || SafePropertyAccessor.getBoolean("jruby.compile.threadless");
        LAZYHANDLES_COMPILE = SafePropertyAccessor.getBoolean("jruby.compile.lazyHandles", false);
        FORK_ENABLED = SafePropertyAccessor.getBoolean("jruby.fork.enabled");
        POOLING_ENABLED = SafePropertyAccessor.getBoolean("jruby.thread.pool.enabled");
        POOL_MAX = SafePropertyAccessor.getInt("jruby.thread.pool.max", Integer.MAX_VALUE);
        POOL_MIN = SafePropertyAccessor.getInt("jruby.thread.pool.min", 0);
        POOL_TTL = SafePropertyAccessor.getInt("jruby.thread.pool.ttl", 60);
        NATIVE_NET_PROTOCOL = SafePropertyAccessor.getBoolean("jruby.native.net.protocol", false);
        FULL_TRACE_ENABLED = SafePropertyAccessor.getBoolean("jruby.debug.fullTrace", false);
        COMPILE_EXCLUDE = SafePropertyAccessor.getProperty("jruby.jit.exclude");
        nativeEnabled = true;
        String string = null;
        try {
            string = System.getProperty("jruby.bytecode.version");
            if (string == null) {
                string = System.getProperty("java.specification.version");
            }
            if (System.getProperty("jruby.native.enabled") != null) {
                nativeEnabled = Boolean.getBoolean("jruby.native.enabled");
            }
        }
        catch (SecurityException securityException) {
            nativeEnabled = false;
            string = "1.5";
        }
        JAVA_VERSION = string.equals("1.5") ? 49 : 50;
    }

    private class ArgumentProcessor {
        private String[] arguments;
        private int argumentIndex = 0;

        public ArgumentProcessor(String[] stringArray) {
            this.arguments = stringArray;
        }

        public void processArguments() {
            while (this.argumentIndex < this.arguments.length && this.isInterpreterArgument(this.arguments[this.argumentIndex])) {
                this.processArgument();
                ++this.argumentIndex;
            }
            if (!RubyInstanceConfig.this.hasInlineScript && RubyInstanceConfig.this.scriptFileName == null && this.argumentIndex < this.arguments.length) {
                RubyInstanceConfig.this.setScriptFileName(this.arguments[this.argumentIndex]);
                ++this.argumentIndex;
            }
            this.processArgv();
        }

        private void processArgv() {
            ArrayList<String> arrayList = new ArrayList<String>();
            while (this.argumentIndex < this.arguments.length) {
                String string = this.arguments[this.argumentIndex];
                if (RubyInstanceConfig.this.argvGlobalsOn && string.startsWith("-")) {
                    if ((string = string.substring(1)).indexOf(61) > 0) {
                        String[] stringArray = string.split("=", 2);
                        RubyInstanceConfig.this.optionGlobals.put(stringArray[0], stringArray[1]);
                    } else {
                        RubyInstanceConfig.this.optionGlobals.put(string, null);
                    }
                } else {
                    RubyInstanceConfig.this.argvGlobalsOn = false;
                    arrayList.add(string);
                }
                ++this.argumentIndex;
            }
            RubyInstanceConfig.access$502(RubyInstanceConfig.this, arrayList.toArray(new String[arrayList.size()]));
        }

        private boolean isInterpreterArgument(String string) {
            return (string.charAt(0) == '-' || string.charAt(0) == '+') && !RubyInstanceConfig.this.endOfArguments;
        }

        private String getArgumentError(String string) {
            return "jruby: invalid argument\n" + string + "\n";
        }

        private void processArgument() {
            String string = this.arguments[this.argumentIndex];
            RubyInstanceConfig.this.characterIndex = 1;
            block36: while (RubyInstanceConfig.this.characterIndex < string.length()) {
                switch (string.charAt(RubyInstanceConfig.this.characterIndex)) {
                    case '0': {
                        Object object2;
                        String string2 = this.grabOptionalValue();
                        if (null == string2) {
                            RubyInstanceConfig.this.recordSeparator = "\u0000";
                            break block36;
                        }
                        if (string2.equals("0")) {
                            RubyInstanceConfig.this.recordSeparator = "\n\n";
                            break block36;
                        }
                        if (string2.equals("777")) {
                            RubyInstanceConfig.this.recordSeparator = "\uffff";
                            break block36;
                        }
                        try {
                            int n = Integer.parseInt(string2, 8);
                            RubyInstanceConfig.this.recordSeparator = "" + (char)n;
                            break block36;
                        }
                        catch (Exception exception) {
                            object2 = new MainExitException(1, this.getArgumentError(" -0 must be followed by either 0, 777, or a valid octal value"));
                            ((MainExitException)object2).setUsageError(true);
                            throw object2;
                        }
                    }
                    case 'a': {
                        RubyInstanceConfig.this.split = true;
                        break;
                    }
                    case 'b': {
                        RubyInstanceConfig.this.benchmarking = true;
                        break;
                    }
                    case 'c': {
                        RubyInstanceConfig.this.shouldCheckSyntax = true;
                        break;
                    }
                    case 'C': {
                        Object object;
                        Object object2;
                        String string2;
                        try {
                            string2 = this.grabValue(this.getArgumentError(" -C must be followed by a directory expression"));
                            object = new File(RubyInstanceConfig.this.currentDirectory);
                            object2 = new File(string2);
                            if (((File)object2).isAbsolute()) {
                                RubyInstanceConfig.this.currentDirectory = ((File)object2).getCanonicalPath();
                            } else {
                                RubyInstanceConfig.this.currentDirectory = new File((File)object, ((File)object2).getPath()).getCanonicalPath();
                            }
                            if (!new File(RubyInstanceConfig.this.currentDirectory).isDirectory()) {
                                MainExitException mainExitException = new MainExitException(1, "jruby: Can't chdir to " + string2 + " (fatal)");
                                mainExitException.setUsageError(true);
                                throw mainExitException;
                            }
                            break;
                        }
                        catch (IOException iOException) {
                            object = new MainExitException(1, this.getArgumentError(" -C must be followed by a valid directory"));
                            object.setUsageError(true);
                            throw object;
                        }
                    }
                    case 'd': {
                        RubyInstanceConfig.this.debug = true;
                        RubyInstanceConfig.this.verbose = Boolean.TRUE;
                        break;
                    }
                    case 'e': {
                        RubyInstanceConfig.this.inlineScript.append(this.grabValue(this.getArgumentError(" -e must be followed by an expression to evaluate")));
                        RubyInstanceConfig.this.inlineScript.append('\n');
                        RubyInstanceConfig.this.hasInlineScript = true;
                        break block36;
                    }
                    case 'F': {
                        RubyInstanceConfig.this.inputFieldSeparator = this.grabValue(this.getArgumentError(" -F must be followed by a pattern for input field separation"));
                        break;
                    }
                    case 'h': {
                        RubyInstanceConfig.this.shouldPrintUsage = true;
                        RubyInstanceConfig.this.shouldRunInterpreter = false;
                        break;
                    }
                    case 'I': {
                        String string2 = this.grabValue(this.getArgumentError("-I must be followed by a directory name to add to lib path"));
                        Object object = string2.split(File.pathSeparator);
                        for (int i = 0; i < ((String[])object).length; ++i) {
                            RubyInstanceConfig.this.loadPaths.add(object[i]);
                        }
                        break block36;
                    }
                    case 'K': {
                        Object object2 = this.grabValue(this.getArgumentError("provide a value for -K"));
                        RubyInstanceConfig.this.kcode = KCode.create(null, (String)object2);
                        break;
                    }
                    case 'l': {
                        RubyInstanceConfig.this.processLineEnds = true;
                        break;
                    }
                    case 'n': {
                        RubyInstanceConfig.this.assumeLoop = true;
                        break;
                    }
                    case 'p': {
                        RubyInstanceConfig.this.assumePrinting = true;
                        RubyInstanceConfig.this.assumeLoop = true;
                        break;
                    }
                    case 'r': {
                        RubyInstanceConfig.this.requiredLibraries.add(this.grabValue(this.getArgumentError("-r must be followed by a package to require")));
                        break block36;
                    }
                    case 's': {
                        RubyInstanceConfig.this.argvGlobalsOn = true;
                        break;
                    }
                    case 'S': {
                        this.runBinScript();
                        break block36;
                    }
                    case 'T': {
                        String string3 = this.grabOptionalValue();
                        int n = 1;
                        if (string3 != null) {
                            try {
                                n = Integer.parseInt(string3, 8);
                            }
                            catch (Exception exception) {
                                n = 1;
                            }
                        }
                        RubyInstanceConfig.this.safeLevel = n;
                        break block36;
                    }
                    case 'v': {
                        RubyInstanceConfig.this.verbose = Boolean.TRUE;
                        RubyInstanceConfig.this.setShowVersion(true);
                        break;
                    }
                    case 'w': {
                        RubyInstanceConfig.this.verbose = Boolean.TRUE;
                        break;
                    }
                    case 'W': {
                        String string4 = this.grabOptionalValue();
                        int n = 2;
                        if (null != string4) {
                            if (string4.equals("2")) {
                                n = 2;
                            } else if (string4.equals("1")) {
                                n = 1;
                            } else if (string4.equals("0")) {
                                n = 0;
                            } else {
                                MainExitException mainExitException = new MainExitException(1, this.getArgumentError(" -W must be followed by either 0, 1, 2 or nothing"));
                                mainExitException.setUsageError(true);
                                throw mainExitException;
                            }
                        }
                        switch (n) {
                            case 0: {
                                RubyInstanceConfig.this.verbose = null;
                                break;
                            }
                            case 1: {
                                RubyInstanceConfig.this.verbose = Boolean.FALSE;
                                break;
                            }
                            case 2: {
                                RubyInstanceConfig.this.verbose = Boolean.TRUE;
                            }
                        }
                        break block36;
                    }
                    case 'X': {
                        String string5 = this.grabOptionalValue();
                        if (string5 == null) {
                            throw new MainExitException(0, "jruby: missing extended option, listing available options\n" + RubyInstanceConfig.this.getExtendedHelp());
                        }
                        if (string5.equals("-O")) {
                            RubyInstanceConfig.this.objectSpaceEnabled = false;
                            break block36;
                        }
                        if (string5.equals("+O")) {
                            RubyInstanceConfig.this.objectSpaceEnabled = true;
                            break block36;
                        }
                        if (string5.equals("-C")) {
                            RubyInstanceConfig.this.compileMode = CompileMode.OFF;
                            break block36;
                        }
                        if (string5.equals("+C")) {
                            RubyInstanceConfig.this.compileMode = CompileMode.FORCE;
                            break block36;
                        }
                        if (string5.equals("-y")) {
                            RubyInstanceConfig.this.yarv = true;
                            break block36;
                        }
                        if (string5.equals("-Y")) {
                            RubyInstanceConfig.this.yarvCompile = true;
                            break block36;
                        }
                        if (string5.equals("-R")) {
                            RubyInstanceConfig.this.rubinius = true;
                            break block36;
                        }
                        MainExitException mainExitException = new MainExitException(1, "jruby: invalid extended option " + string5 + " (-X will list valid options)\n");
                        mainExitException.setUsageError(true);
                        throw mainExitException;
                    }
                    case '-': {
                        if (string.equals("--command") || string.equals("--bin")) {
                            RubyInstanceConfig.this.characterIndex = string.length();
                            this.runBinScript();
                            break;
                        }
                        if (string.equals("--compat")) {
                            RubyInstanceConfig.this.characterIndex = string.length();
                            RubyInstanceConfig.this.compatVersion = CompatVersion.getVersionFromString(this.grabValue(this.getArgumentError("--compat must be RUBY1_8 or RUBY1_9")));
                            if (RubyInstanceConfig.this.compatVersion != null) break block36;
                            RubyInstanceConfig.this.compatVersion = CompatVersion.RUBY1_8;
                            break block36;
                        }
                        if (string.equals("--copyright")) {
                            RubyInstanceConfig.this.setShowCopyright(true);
                            RubyInstanceConfig.this.shouldRunInterpreter = false;
                            break block36;
                        }
                        if (string.equals("--debug")) {
                            RubyInstanceConfig.this.compileMode = CompileMode.OFF;
                            FULL_TRACE_ENABLED = true;
                            System.setProperty("jruby.reflection", "true");
                            break block36;
                        }
                        if (string.equals("--jdb")) {
                            RubyInstanceConfig.this.debug = true;
                            RubyInstanceConfig.this.verbose = Boolean.TRUE;
                            break;
                        }
                        if (string.equals("--help")) {
                            RubyInstanceConfig.this.shouldPrintUsage = true;
                            RubyInstanceConfig.this.shouldRunInterpreter = false;
                            break;
                        }
                        if (string.equals("--properties")) {
                            RubyInstanceConfig.this.shouldPrintProperties = true;
                            RubyInstanceConfig.this.shouldRunInterpreter = false;
                            break;
                        }
                        if (string.equals("--version")) {
                            RubyInstanceConfig.this.setShowVersion(true);
                            break block36;
                        }
                        if (string.equals("--bytecode")) {
                            RubyInstanceConfig.this.setShowBytecode(true);
                            break block36;
                        }
                        if (string.equals("--")) {
                            RubyInstanceConfig.this.endOfArguments = true;
                            break;
                        }
                    }
                    default: {
                        throw new MainExitException(1, "jruby: unknown option " + string);
                    }
                }
                ++RubyInstanceConfig.this.characterIndex;
            }
        }

        private void runBinScript() {
            String string = this.grabValue("jruby: provide a bin script to execute");
            if (string.equals("irb")) {
                string = "jirb";
            }
            RubyInstanceConfig.this.scriptFileName = string;
            if (!new File(RubyInstanceConfig.this.scriptFileName).exists()) {
                try {
                    String string2 = JRubyFile.create(System.getProperty("user.dir"), JRubyFile.getFileProperty("jruby.home")).getCanonicalPath();
                    RubyInstanceConfig.this.scriptFileName = JRubyFile.create(string2 + JRubyFile.separator + "bin", string).getCanonicalPath();
                }
                catch (IOException iOException) {
                    MainExitException mainExitException = new MainExitException(1, "jruby: Can't determine script filename");
                    mainExitException.setUsageError(true);
                    throw mainExitException;
                }
            }
            if (string.equals("gem") || !new File(RubyInstanceConfig.this.scriptFileName).exists()) {
                RubyInstanceConfig.this.requiredLibraries.add("jruby/commands");
                RubyInstanceConfig.this.inlineScript.append("JRuby::Commands." + string);
                RubyInstanceConfig.this.inlineScript.append("\n");
                RubyInstanceConfig.this.hasInlineScript = true;
            }
            RubyInstanceConfig.this.endOfArguments = true;
        }

        private String grabValue(String string) {
            ++RubyInstanceConfig.this.characterIndex;
            if (RubyInstanceConfig.this.characterIndex < this.arguments[this.argumentIndex].length()) {
                return this.arguments[this.argumentIndex].substring(RubyInstanceConfig.this.characterIndex);
            }
            ++this.argumentIndex;
            if (this.argumentIndex < this.arguments.length) {
                return this.arguments[this.argumentIndex];
            }
            MainExitException mainExitException = new MainExitException(1, string);
            mainExitException.setUsageError(true);
            throw mainExitException;
        }

        private String grabOptionalValue() {
            ++RubyInstanceConfig.this.characterIndex;
            if (RubyInstanceConfig.this.characterIndex < this.arguments[this.argumentIndex].length()) {
                return this.arguments[this.argumentIndex].substring(RubyInstanceConfig.this.characterIndex);
            }
            return null;
        }
    }

    public static interface LoadServiceCreator {
        public static final LoadServiceCreator DEFAULT = new LoadServiceCreator(){

            public LoadService create(Ruby ruby) {
                return new LoadService(ruby);
            }
        };

        public LoadService create(Ruby var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CompileMode {
        JIT,
        FORCE,
        OFF;


        public boolean shouldPrecompileCLI() {
            switch (this) {
                case JIT: 
                case FORCE: {
                    return true;
                }
            }
            return false;
        }

        public boolean shouldJIT() {
            switch (this) {
                case JIT: 
                case FORCE: {
                    return true;
                }
            }
            return false;
        }

        public boolean shouldPrecompileAll() {
            return this == FORCE;
        }
    }
}

