/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.execute;

import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.options.MavenSettings;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanRunConfig
implements RunConfig {
    private File executionDirectory;
    private WeakReference<Project> project;
    private FileObject projectDirectory;
    private List<String> goals;
    private String executionName;
    private Properties properties;
    private boolean showDebug = MavenSettings.getDefault().isShowDebug();
    private boolean showError = MavenSettings.getDefault().isShowErrors();
    private Boolean offline = MavenSettings.getDefault().isOffline();
    private boolean updateSnapshots = MavenSettings.getDefault().isUpdateSnapshots();
    private boolean interactive = MavenSettings.getDefault().isInteractive();
    private List<String> activate;
    private boolean recursive = true;
    private String taskName;
    private RunConfig parent;
    private String actionName;
    private FileObject selectedFO;
    private MavenProject mp;
    private RunConfig preexecution;
    private String preactionname;
    private RunConfig.ReactorStyle reactor = RunConfig.ReactorStyle.NONE;

    public BeanRunConfig() {
    }

    public BeanRunConfig(RunConfig runConfig) {
        this.parent = runConfig;
        this.setRecursive(runConfig.isRecursive());
        this.setInteractive(runConfig.isInteractive());
        this.setOffline(runConfig.isOffline());
        this.setShowDebug(runConfig.isShowDebug());
        this.setShowError(runConfig.isShowError());
        this.setUpdateSnapshots(runConfig.isUpdateSnapshots());
        this.setReactorStyle(runConfig.getReactorStyle());
    }

    @Override
    public final File getExecutionDirectory() {
        if (this.parent != null && this.executionDirectory == null) {
            return this.parent.getExecutionDirectory();
        }
        return this.executionDirectory;
    }

    @Override
    public final void setExecutionDirectory(File file) {
        this.executionDirectory = file;
    }

    @Override
    public final Project getProject() {
        if (this.parent != null && this.project == null) {
            return this.parent.getProject();
        }
        if (this.project != null) {
            Project project = (Project)this.project.get();
            if (project == null && this.projectDirectory.isValid()) {
                try {
                    project = ProjectManager.getDefault().findProject(this.projectDirectory);
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Exceptions.printStackTrace((Throwable)illegalArgumentException);
                }
            }
            return project;
        }
        return null;
    }

    @Override
    public final synchronized MavenProject getMavenProject() {
        if (this.mp != null) {
            return this.mp;
        }
        Project project = this.getProject();
        if (project != null) {
            NbMavenProjectImpl nbMavenProjectImpl = (NbMavenProjectImpl)project.getLookup().lookup(NbMavenProjectImpl.class);
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.addAll(nbMavenProjectImpl.getCurrentActiveProfiles());
            if (this.getActivatedProfiles() != null) {
                arrayList.addAll(this.getActivatedProfiles());
            }
            Properties properties = new Properties();
            if (this.getProperties() != null) {
                properties.putAll((Map<?, ?>)this.getProperties());
            }
            this.mp = nbMavenProjectImpl.loadMavenProject(EmbedderFactory.createProjectLikeEmbedder(), arrayList, properties);
        }
        return this.mp;
    }

    public final synchronized void setProject(Project project) {
        if (project != null) {
            this.project = new WeakReference<Project>(project);
            this.projectDirectory = project.getProjectDirectory();
        } else {
            this.project = null;
            this.projectDirectory = null;
        }
        this.mp = null;
    }

    @Override
    public final List<String> getGoals() {
        if (this.parent != null && this.goals == null) {
            return this.parent.getGoals();
        }
        return this.goals;
    }

    public final void setGoals(List<String> list) {
        this.goals = list;
    }

    @Override
    public final String getExecutionName() {
        if (this.parent != null && this.executionName == null) {
            return this.parent.getExecutionName();
        }
        return this.executionName;
    }

    public final void setExecutionName(String string) {
        this.executionName = string;
    }

    @Override
    public final Properties getProperties() {
        if (this.parent != null && this.properties == null) {
            return this.parent.getProperties();
        }
        Properties properties = new Properties();
        if (this.properties != null) {
            properties.putAll((Map<?, ?>)this.properties);
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final String removeProperty(String string) {
        if (this.properties == null) {
            this.properties = new Properties();
            if (this.parent != null) {
                this.properties.putAll((Map<?, ?>)this.parent.getProperties());
            }
        }
        String string2 = (String)this.properties.remove(string);
        BeanRunConfig beanRunConfig = this;
        synchronized (beanRunConfig) {
            this.mp = null;
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final String setProperty(String string, String string2) {
        if (this.properties == null) {
            this.properties = new Properties();
            if (this.parent != null) {
                this.properties.putAll((Map<?, ?>)this.parent.getProperties());
            }
        }
        String string3 = (String)this.properties.setProperty(string, string2);
        BeanRunConfig beanRunConfig = this;
        synchronized (beanRunConfig) {
            this.mp = null;
        }
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setProperties(Properties properties) {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        this.properties.clear();
        this.properties.putAll((Map<?, ?>)properties);
        BeanRunConfig beanRunConfig = this;
        synchronized (beanRunConfig) {
            this.mp = null;
        }
    }

    @Override
    public final boolean isShowDebug() {
        return this.showDebug;
    }

    public final void setShowDebug(boolean bl) {
        this.showDebug = bl;
    }

    @Override
    public final boolean isShowError() {
        return this.showError;
    }

    public final void setShowError(boolean bl) {
        this.showError = bl;
    }

    @Override
    public final Boolean isOffline() {
        return this.offline;
    }

    @Override
    public final void setOffline(Boolean bl) {
        this.offline = bl;
    }

    @Override
    public final List<String> getActivatedProfiles() {
        if (this.parent != null && this.activate == null) {
            return this.parent.getActivatedProfiles();
        }
        if (this.activate != null) {
            return Collections.unmodifiableList(this.activate);
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setActivatedProfiles(List<String> list) {
        this.activate = new ArrayList<String>();
        this.activate.addAll(list);
        BeanRunConfig beanRunConfig = this;
        synchronized (beanRunConfig) {
            this.mp = null;
        }
    }

    @Override
    public final boolean isRecursive() {
        return this.recursive;
    }

    public final void setRecursive(boolean bl) {
        this.recursive = bl;
    }

    @Override
    public final boolean isUpdateSnapshots() {
        return this.updateSnapshots;
    }

    public final void setUpdateSnapshots(boolean bl) {
        this.updateSnapshots = bl;
    }

    @Override
    public final String getTaskDisplayName() {
        if (this.parent != null && this.taskName == null) {
            return this.parent.getTaskDisplayName();
        }
        return this.taskName;
    }

    public final void setTaskDisplayName(String string) {
        this.taskName = string;
    }

    @Override
    public final boolean isInteractive() {
        return this.interactive;
    }

    public final void setInteractive(boolean bl) {
        this.interactive = bl;
    }

    public void setActionName(String string) {
        this.actionName = string;
    }

    @Override
    public String getActionName() {
        if (this.parent != null && this.actionName == null) {
            return this.parent.getActionName();
        }
        return this.actionName;
    }

    @Override
    public FileObject getSelectedFileObject() {
        if (this.parent != null && this.selectedFO == null) {
            return this.parent.getSelectedFileObject();
        }
        return this.selectedFO;
    }

    public void setFileObject(FileObject fileObject) {
        this.selectedFO = fileObject;
    }

    @Override
    public RunConfig getPreExecution() {
        if (this.parent != null && this.preexecution == null) {
            return this.parent.getPreExecution();
        }
        return this.preexecution;
    }

    public void setPreExecution(RunConfig runConfig) {
        this.preexecution = runConfig;
    }

    public void setPreExecutionActionName(String string) {
        this.preactionname = string;
    }

    public String getPreExecutionActionName() {
        return this.preactionname;
    }

    @Override
    public RunConfig.ReactorStyle getReactorStyle() {
        return this.reactor;
    }

    public void setReactorStyle(RunConfig.ReactorStyle reactorStyle) {
        this.reactor = reactorStyle;
    }
}

