/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.customizer;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.IllegalCharsetNameException;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.ModelUtils;
import org.netbeans.modules.maven.api.PluginPropertyUtils;
import org.netbeans.modules.maven.api.customizer.ModelHandle;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class SourcesPanel
extends JPanel {
    private String encoding;
    private String defaultEncoding;
    private String defaultSourceLevel = "1.3";
    private String sourceLevel;
    private ModelHandle handle;
    private JComboBox comEncoding;
    private JComboBox comSourceLevel;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JLabel lblEncoding;
    private JLabel lblGenerated;
    private JLabel lblProjectFolder;
    private JLabel lblSourceLevel;
    private JLabel lblSrc;
    private JLabel lblTestSrc;
    private JTextField txtProjectFolder;
    private JTextField txtSrc;
    private JTextField txtTestSrc;

    public SourcesPanel(ModelHandle modelHandle, NbMavenProjectImpl nbMavenProjectImpl) {
        String string;
        this.initComponents();
        this.handle = modelHandle;
        FileObject fileObject = nbMavenProjectImpl.getProjectDirectory();
        File file = FileUtil.toFile((FileObject)fileObject);
        this.txtProjectFolder.setText(file == null ? "" : file.getPath());
        this.comSourceLevel.setEditable(false);
        this.sourceLevel = SourceLevelQuery.getSourceLevel((FileObject)nbMavenProjectImpl.getProjectDirectory());
        this.comSourceLevel.setModel(new DefaultComboBoxModel<String>(new String[]{"1.3", "1.4", "1.5", "1.6"}));
        this.comSourceLevel.setSelectedItem(this.sourceLevel);
        String string2 = nbMavenProjectImpl.getOriginalMavenProject().getProperties().getProperty("project.build.sourceEncoding");
        if (string2 == null) {
            string2 = PluginPropertyUtils.getPluginProperty(nbMavenProjectImpl, "org.apache.maven.plugins", "maven-compiler-plugin", "encoding", null);
        }
        Charset charset = null;
        if (string2 != null) {
            charset = Charset.forName(string2);
        }
        if (charset == null && (string = PluginPropertyUtils.getPluginProperty(nbMavenProjectImpl, "org.apache.maven.plugins", "maven-resources-plugin", "encoding", null)) != null) {
            charset = Charset.forName(string);
        }
        if (charset != null) {
            this.encoding = charset.name();
        }
        if (this.encoding == null) {
            this.encoding = Charset.defaultCharset().toString();
        }
        this.defaultEncoding = Charset.defaultCharset().toString();
        this.comEncoding.setModel(new EncodingModel(this.encoding));
        this.comEncoding.setRenderer(new EncodingRenderer());
        this.comSourceLevel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SourcesPanel.this.handleSourceLevelChange();
            }
        });
        this.comEncoding.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SourcesPanel.this.handleEncodingChange();
            }
        });
        this.txtSrc.setText(nbMavenProjectImpl.getOriginalMavenProject().getBuild().getSourceDirectory());
        this.txtTestSrc.setText(nbMavenProjectImpl.getOriginalMavenProject().getBuild().getTestSourceDirectory());
    }

    private void handleSourceLevelChange() {
        this.sourceLevel = (String)this.comSourceLevel.getSelectedItem();
        ModelUtils.checkSourceLevel(this.handle, this.sourceLevel);
        if (this.defaultSourceLevel.equals(this.sourceLevel)) {
            this.lblSourceLevel.setFont(this.lblSourceLevel.getFont().deriveFont(0));
        } else {
            this.lblSourceLevel.setFont(this.lblSourceLevel.getFont().deriveFont(1));
        }
    }

    private void handleEncodingChange() {
        Charset charset = (Charset)this.comEncoding.getSelectedItem();
        String string = charset != null ? charset.name() : this.encoding;
        ModelUtils.checkEncoding(this.handle, string);
        if (this.defaultEncoding.equals(string)) {
            this.lblEncoding.setFont(this.lblEncoding.getFont().deriveFont(0));
        } else {
            this.lblEncoding.setFont(this.lblEncoding.getFont().deriveFont(1));
        }
    }

    private void initComponents() {
        this.lblProjectFolder = new JLabel();
        this.txtProjectFolder = new JTextField();
        this.lblSrc = new JLabel();
        this.txtSrc = new JTextField();
        this.lblTestSrc = new JLabel();
        this.txtTestSrc = new JTextField();
        this.lblGenerated = new JLabel();
        this.jPanel1 = new JPanel();
        this.lblSourceLevel = new JLabel();
        this.comSourceLevel = new JComboBox();
        this.lblEncoding = new JLabel();
        this.comEncoding = new JComboBox();
        this.jPanel2 = new JPanel();
        this.lblProjectFolder.setLabelFor(this.txtProjectFolder);
        Mnemonics.setLocalizedText((JLabel)this.lblProjectFolder, (String)NbBundle.getBundle(SourcesPanel.class).getString("CTL_ProjectFolder"));
        this.txtProjectFolder.setEditable(false);
        this.lblSrc.setLabelFor(this.txtSrc);
        Mnemonics.setLocalizedText((JLabel)this.lblSrc, (String)NbBundle.getBundle(SourcesPanel.class).getString("SourcesPanel.lblSrc.text"));
        this.txtSrc.setEditable(false);
        this.lblTestSrc.setLabelFor(this.txtTestSrc);
        Mnemonics.setLocalizedText((JLabel)this.lblTestSrc, (String)NbBundle.getBundle(SourcesPanel.class).getString("SourcesPanel.lblTestSrc.text"));
        this.txtTestSrc.setEditable(false);
        Mnemonics.setLocalizedText((JLabel)this.lblGenerated, (String)NbBundle.getBundle(SourcesPanel.class).getString("SourcesPanel.lblGenerated.text"));
        this.lblGenerated.setVerticalAlignment(1);
        this.jPanel1.setLayout(new GridBagLayout());
        this.lblSourceLevel.setLabelFor(this.comSourceLevel);
        Mnemonics.setLocalizedText((JLabel)this.lblSourceLevel, (String)NbBundle.getMessage(SourcesPanel.class, (String)"TXT_SourceLevel"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.jPanel1.add((Component)this.lblSourceLevel, gridBagConstraints);
        this.comSourceLevel.setModel(new DefaultComboBoxModel<String>(new String[]{"1.4", "1.5"}));
        this.comSourceLevel.setMinimumSize(this.comSourceLevel.getPreferredSize());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.comSourceLevel, gridBagConstraints);
        this.comSourceLevel.getAccessibleContext().setAccessibleName(NbBundle.getBundle(SourcesPanel.class).getString("AN_SourceLevel"));
        this.comSourceLevel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SourcesPanel.class, (String)"SourcesPanel.comSourceLevel.AccessibleContext.accessibleDescription"));
        this.lblEncoding.setLabelFor(this.comEncoding);
        Mnemonics.setLocalizedText((JLabel)this.lblEncoding, (String)NbBundle.getMessage(SourcesPanel.class, (String)"TXT_Encoding"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 12);
        this.jPanel1.add((Component)this.lblEncoding, gridBagConstraints);
        this.comEncoding.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.jPanel1.add((Component)this.comEncoding, gridBagConstraints);
        this.comEncoding.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SourcesPanel.class, (String)"SourcesPanel.comEncoding.AccessibleContext.accessibleDescription"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.jPanel2, gridBagConstraints);
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jPanel1, -1, 551, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.lblProjectFolder).add((Component)this.lblSrc).add((Component)this.lblTestSrc)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.txtTestSrc, -1, 453, Short.MAX_VALUE).add((Component)this.txtSrc, -1, 453, Short.MAX_VALUE).add((Component)this.txtProjectFolder, -1, 453, Short.MAX_VALUE))).add((Component)this.lblGenerated, -1, 551, Short.MAX_VALUE));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblProjectFolder).add((Component)this.txtProjectFolder, -2, -1, -2)).add(18, 18, 18).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblSrc).add((Component)this.txtSrc, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblTestSrc).add((Component)this.txtTestSrc, -2, -1, -2)).add(18, 18, 18).add((Component)this.lblGenerated, -2, 135, -2).addPreferredGap(0, 148, Short.MAX_VALUE).add((Component)this.jPanel1, -2, -1, -2)));
        this.txtProjectFolder.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SourcesPanel.class, (String)"SourcesPanel.txtProjectFolder.AccessibleContext.accessibleDescription"));
        this.txtSrc.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SourcesPanel.class, (String)"SourcesPanel.txtSrc.AccessibleContext.accessibleDescription"));
        this.txtTestSrc.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SourcesPanel.class, (String)"SourcesPanel.txtTestSrc.AccessibleContext.accessibleDescription"));
    }

    private static class UnknownCharset
    extends Charset {
        UnknownCharset(String string) {
            super(string, new String[0]);
        }

        public boolean contains(Charset charset) {
            throw new UnsupportedOperationException();
        }

        public CharsetDecoder newDecoder() {
            throw new UnsupportedOperationException();
        }

        public CharsetEncoder newEncoder() {
            throw new UnsupportedOperationException();
        }
    }

    private static class EncodingModel
    extends DefaultComboBoxModel {
        public EncodingModel(String string) {
            Charset charset = null;
            for (Charset charset2 : Charset.availableCharsets().values()) {
                if (charset2.name().equals(string)) {
                    charset = charset2;
                }
                this.addElement(charset2);
            }
            if (charset == null) {
                try {
                    charset = new UnknownCharset(string);
                    this.addElement(charset);
                }
                catch (IllegalCharsetNameException illegalCharsetNameException) {
                    Logger.getLogger(this.getClass().getName()).info("IllegalCharsetName: " + string);
                }
            }
            if (charset == null) {
                charset = FileEncodingQuery.getDefaultEncoding();
            }
            this.setSelectedItem(charset);
        }
    }

    private static class EncodingRenderer
    extends DefaultListCellRenderer {
        private EncodingRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            assert (object instanceof Charset);
            return super.getListCellRendererComponent((JList<?>)jList, ((Charset)object).displayName(), n, bl, bl2);
        }
    }
}

