/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.api.output;

import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;
import org.openide.util.Exceptions;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;

public final class OutputUtils {
    static final Pattern linePattern = Pattern.compile("(?:\\[catch\\])?\\sat (.*)\\((.*)\\.java\\:(.*)\\)");

    private OutputUtils() {
    }

    public static OutputListener matchStackTraceLine(String string, ClassPath classPath) {
        Matcher matcher = linePattern.matcher(string);
        StacktraceOutputListener stacktraceOutputListener = null;
        if (matcher.matches()) {
            String string2;
            String string3;
            FileObject fileObject;
            String string4 = matcher.group(1);
            String string5 = matcher.group(2);
            String string6 = matcher.group(3);
            int n = string4.indexOf(string5);
            if (n > -1 && (fileObject = classPath.findResource(string3 = (string2 = string4.substring(0, n).replace('.', '/')) + string5 + ".class")) != null) {
                FileObject fileObject2 = classPath.findOwnerRoot(fileObject);
                URL uRL = URLMapper.findURL((FileObject)fileObject2, (int)0);
                SourceForBinaryQuery.Result result = SourceForBinaryQuery.findSourceRoots((URL)uRL);
                FileObject[] fileObjectArray = result.getRoots();
                for (int i = 0; i < fileObjectArray.length; ++i) {
                    String string7 = string2 + string5 + ".java";
                    FileObject fileObject3 = fileObjectArray[i].getFileObject(string7);
                    if (fileObject3 == null) continue;
                    try {
                        DataObject dataObject = DataObject.find((FileObject)fileObject3);
                        EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
                        int n2 = Integer.parseInt(string6);
                        stacktraceOutputListener = new StacktraceOutputListener(editorCookie, n2);
                        continue;
                    }
                    catch (DataObjectNotFoundException dataObjectNotFoundException) {
                        Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
                    }
                }
            }
        }
        return stacktraceOutputListener;
    }

    private static class StacktraceOutputListener
    implements OutputListener {
        private EditorCookie cookie;
        private int line;

        public StacktraceOutputListener(EditorCookie editorCookie, int n) {
            this.cookie = editorCookie;
            this.line = n - 1;
        }

        public void outputLineSelected(OutputEvent outputEvent) {
        }

        public void outputLineAction(OutputEvent outputEvent) {
            this.cookie.getLineSet().getCurrent(this.line).show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS);
        }

        public void outputLineCleared(OutputEvent outputEvent) {
        }
    }
}

