/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.api.customizer.support;

import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.openide.util.NbBundle;

public abstract class TextComponentUpdater
implements DocumentListener,
AncestorListener {
    private JTextComponent component;
    private JLabel label;
    private boolean inherited = false;

    public TextComponentUpdater(JTextComponent jTextComponent, JLabel jLabel) {
        this.component = jTextComponent;
        this.component.addAncestorListener(this);
        this.label = jLabel;
    }

    public abstract String getValue();

    public abstract String getDefaultValue();

    public abstract void setValue(String var1);

    private void setModelValue() {
        if (this.inherited) {
            this.inherited = false;
            this.label.setFont(this.label.getFont().deriveFont(1));
            this.component.setToolTipText("");
        }
        this.setValue(this.component.getText().trim().length() == 0 ? null : this.component.getText());
        if (this.component.getText().trim().length() == 0) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    TextComponentUpdater.this.component.getDocument().removeDocumentListener(TextComponentUpdater.this);
                    TextComponentUpdater.this.setTextFieldValue(TextComponentUpdater.this.getValue(), TextComponentUpdater.this.getDefaultValue(), TextComponentUpdater.this.component);
                    TextComponentUpdater.this.component.getDocument().addDocumentListener(TextComponentUpdater.this);
                }
            });
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.setModelValue();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.setModelValue();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.setModelValue();
    }

    public void ancestorAdded(AncestorEvent ancestorEvent) {
        this.setTextFieldValue(this.getValue(), this.getDefaultValue(), this.component);
        this.component.getDocument().addDocumentListener(this);
    }

    public void ancestorRemoved(AncestorEvent ancestorEvent) {
        this.component.getDocument().removeDocumentListener(this);
    }

    public void ancestorMoved(AncestorEvent ancestorEvent) {
    }

    private void setTextFieldValue(String string, String string2, JTextComponent jTextComponent) {
        if (string != null) {
            jTextComponent.setText(string);
            this.component.setToolTipText("");
            this.inherited = false;
            this.label.setFont(this.label.getFont().deriveFont(1));
        } else if (string2 != null) {
            jTextComponent.setText(string2);
            jTextComponent.setSelectionEnd(string2.length());
            jTextComponent.setSelectionStart(0);
            this.label.setFont(this.label.getFont().deriveFont(0));
            this.component.setToolTipText(NbBundle.getMessage(TextComponentUpdater.class, (String)"MSG_Value_Inherited"));
            this.inherited = true;
        } else {
            jTextComponent.setText("");
            this.component.setToolTipText("");
            this.inherited = false;
            this.label.setFont(this.label.getFont().deriveFont(1));
        }
    }
}

