/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.api.customizer.support;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ComboBoxUpdater<T>
implements ActionListener,
AncestorListener {
    private JComboBox component;
    private JLabel label;
    private boolean inherited = false;

    public ComboBoxUpdater(JComboBox jComboBox, JLabel jLabel) {
        this.component = jComboBox;
        this.component.addAncestorListener(this);
        this.label = jLabel;
    }

    public abstract T getValue();

    public abstract T getDefaultValue();

    public abstract void setValue(T var1);

    private void setModelValue() {
        Object object;
        if (this.inherited) {
            this.inherited = false;
            this.label.setFont(this.label.getFont().deriveFont(1));
            this.component.setToolTipText("");
        }
        this.setValue((object = this.component.getSelectedItem()) == this.getDefaultValue() ? null : object);
        if (object == this.getDefaultValue()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ComboBoxUpdater.this.component.removeActionListener(ComboBoxUpdater.this);
                    ComboBoxUpdater.this.setComboValue(ComboBoxUpdater.this.getValue(), ComboBoxUpdater.this.getDefaultValue(), ComboBoxUpdater.this.component);
                    ComboBoxUpdater.this.component.addActionListener(ComboBoxUpdater.this);
                }
            });
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.setModelValue();
    }

    @Override
    public void ancestorAdded(AncestorEvent ancestorEvent) {
        this.setComboValue(this.getValue(), this.getDefaultValue(), this.component);
        this.component.addActionListener(this);
    }

    @Override
    public void ancestorRemoved(AncestorEvent ancestorEvent) {
        this.component.removeActionListener(this);
    }

    @Override
    public void ancestorMoved(AncestorEvent ancestorEvent) {
    }

    private void setComboValue(T t, T t2, JComboBox jComboBox) {
        if (t != null) {
            jComboBox.setSelectedItem(t);
            this.component.setToolTipText("");
            this.inherited = false;
            this.label.setFont(this.label.getFont().deriveFont(1));
        } else if (t2 != null) {
            jComboBox.setSelectedItem(t2);
            this.label.setFont(this.label.getFont().deriveFont(0));
            this.component.setToolTipText(NbBundle.getMessage(ComboBoxUpdater.class, (String)"HINT_inherited"));
            this.inherited = true;
        } else {
            jComboBox.setSelectedItem(jComboBox.getModel().getElementAt(0));
            this.component.setToolTipText("");
            this.inherited = false;
            this.label.setFont(this.label.getFont().deriveFont(1));
        }
    }
}

