/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.api;

import java.io.File;
import java.net.URI;
import java.util.Stack;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class FileUtilities {
    private static final Pattern RELATIVE_SLASH_SEPARATED_PATH = Pattern.compile("[^:/\\\\.][^:/\\\\]*(/[^:/\\\\.][^:/\\\\]*)*");

    private FileUtilities() {
    }

    public static FileObject convertURItoFileObject(URI uRI) {
        if (uRI == null) {
            return null;
        }
        File file = FileUtil.normalizeFile((File)new File(uRI));
        return FileUtil.toFileObject((File)file);
    }

    public static FileObject convertStringToFileObject(String string) {
        if (string != null) {
            File file = new File(string);
            file = FileUtil.normalizeFile((File)file);
            return FileUtil.toFileObject((File)file);
        }
        return null;
    }

    public static File convertStringToFile(String string) {
        if (string != null) {
            File file = new File(string);
            return FileUtil.normalizeFile((File)file);
        }
        return null;
    }

    public static URI convertStringToUri(String string) {
        if (string != null) {
            File file = new File(string);
            file = FileUtil.normalizeFile((File)file);
            return file.toURI();
        }
        return null;
    }

    public static File convertArtifactToLocalRepositoryFile(Artifact artifact) {
        String string = EmbedderFactory.getProjectEmbedder().getLocalRepository().pathOf(artifact);
        File file = FileUtilities.convertStringToFile(EmbedderFactory.getProjectEmbedder().getLocalRepository().getBasedir());
        return FileUtilities.resolveFilePath(file, string);
    }

    public static File resolveFilePath(File file, String string) {
        File file2;
        if (file == null) {
            throw new NullPointerException("null basedir passed to resolveFile");
        }
        if (string == null) {
            throw new NullPointerException("null filename passed to resolveFile");
        }
        if (!file.isAbsolute()) {
            throw new IllegalArgumentException("nonabsolute basedir passed to resolveFile: " + file);
        }
        if (RELATIVE_SLASH_SEPARATED_PATH.matcher(string).matches()) {
            file2 = new File(file, string.replace('/', File.separatorChar));
        } else {
            String string2 = string.replace('/', File.separatorChar).replace('\\', File.separatorChar);
            file2 = new File(string2);
            if (!file2.isAbsolute()) {
                file2 = new File(file, string2);
            }
            assert (file2.isAbsolute());
        }
        return FileUtil.normalizeFile((File)file2);
    }

    public static URI getDirURI(File file, String string) {
        String string2 = string.trim();
        string2 = string2.replaceFirst("^\\./", "");
        string2 = string2.replaceFirst("^\\.\\\\", "");
        File file2 = FileUtilities.resolveFilePath(file, string2);
        return FileUtil.normalizeFile((File)file2).toURI();
    }

    public static URI getDirURI(FileObject fileObject, String string) {
        return FileUtilities.getDirURI(FileUtil.toFile((FileObject)fileObject), string);
    }

    public static String getRelativePath(File file, File file2) {
        File file3;
        Stack<String> stack = new Stack<String>();
        for (file3 = file2; file3 != null && !file3.equals(file); file3 = file3.getParentFile()) {
            stack.push(file3.getName());
        }
        if (file3 == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        while (!stack.isEmpty()) {
            stringBuilder.append((String)stack.pop());
            if (stack.isEmpty()) continue;
            stringBuilder.append('/');
        }
        return stringBuilder.toString();
    }

    @Deprecated
    public static FileObject toFileObject(File file) {
        FileUtil.refreshFor((File[])new File[]{file});
        return FileUtil.toFileObject((File)file);
    }

    public static String relativizeFile(File file, File file2) {
        if (file.isFile()) {
            throw new IllegalArgumentException("Cannot relative w.r.t. a data file " + file);
        }
        if (file.equals(file2)) {
            return ".";
        }
        StringBuffer stringBuffer = new StringBuffer();
        File file3 = file;
        String string = file2.getAbsolutePath();
        while (!string.startsWith(FileUtilities.slashify(file3.getAbsolutePath()))) {
            if ((file3 = file3.getParentFile()) == null) {
                return null;
            }
            if (file3.equals(file2)) {
                stringBuffer.append("..");
                return stringBuffer.toString();
            }
            stringBuffer.append("../");
        }
        URI uRI = file3.toURI().relativize(file2.toURI());
        assert (!uRI.isAbsolute()) : uRI + " from " + file + " and " + file2 + " with common root " + file3;
        stringBuffer.append(uRI.getPath());
        if (stringBuffer.charAt(stringBuffer.length() - 1) == '/') {
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    private static String slashify(String string) {
        if (string.endsWith(File.separator)) {
            return string;
        }
        return string + File.separatorChar;
    }
}

