/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.classpath.ClassPathProviderImpl;
import org.netbeans.modules.maven.options.MavenSettings;
import org.netbeans.modules.maven.queries.MavenFileOwnerQueryImpl;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

class ProjectOpenedHookImpl
extends ProjectOpenedHook {
    private static final String PROP_BINARIES_CHECKED = "binariesChecked";
    private static final String PROP_JAVADOC_CHECKED = "javadocChecked";
    private static final String PROP_SOURCE_CHECKED = "sourceChecked";
    private final NbMavenProjectImpl project;
    private List<URI> uriReferences = new ArrayList<URI>();
    static final String UI_LOGGER_NAME = "org.netbeans.ui.maven.project";
    static final Logger UI_LOGGER = Logger.getLogger("org.netbeans.ui.maven.project");
    static final String USG_LOGGER_NAME = "org.netbeans.ui.metrics.maven";
    static final Logger USG_LOGGER = Logger.getLogger("org.netbeans.ui.metrics.maven");

    ProjectOpenedHookImpl(NbMavenProjectImpl nbMavenProjectImpl) {
        this.project = nbMavenProjectImpl;
    }

    protected void projectOpened() {
        this.checkBinaryDownloads();
        this.checkSourceDownloads();
        this.checkJavadocDownloads();
        this.attachUpdater();
        MavenFileOwnerQueryImpl mavenFileOwnerQueryImpl = MavenFileOwnerQueryImpl.getInstance();
        if (mavenFileOwnerQueryImpl != null) {
            mavenFileOwnerQueryImpl.addMavenProject(this.project);
        } else {
            ErrorManager.getDefault().log("MavenFileOwnerQueryImpl not found..");
        }
        HashSet<URI> hashSet = new HashSet<URI>();
        hashSet.addAll(Arrays.asList(this.project.getSourceRoots(false)));
        hashSet.addAll(Arrays.asList(this.project.getSourceRoots(true)));
        hashSet.addAll(Arrays.asList(this.project.getGeneratedSourceRoots()));
        URI uRI = FileUtil.toFile((FileObject)this.project.getProjectDirectory()).toURI();
        File file = new File(uRI);
        for (URI serializable2 : hashSet) {
            if (FileUtilities.getRelativePath(file, new File(serializable2)) != null) continue;
            FileOwnerQuery.markExternalOwner((URI)serializable2, (Project)this.project, (int)0);
            this.uriReferences.add(serializable2);
        }
        ClassPathProviderImpl classPathProviderImpl = (ClassPathProviderImpl)this.project.getLookup().lookup(ClassPathProviderImpl.class);
        GlobalPathRegistry.getDefault().register("classpath/boot", classPathProviderImpl.getProjectClassPaths("classpath/boot"));
        GlobalPathRegistry.getDefault().register("classpath/source", classPathProviderImpl.getProjectClassPaths("classpath/source"));
        GlobalPathRegistry.getDefault().register("classpath/compile", classPathProviderImpl.getProjectClassPaths("classpath/compile"));
        this.project.doBaseProblemChecks();
        LogRecord logRecord = new LogRecord(Level.INFO, "UI_MAVEN_PROJECT_OPENED");
        logRecord.setLoggerName(UI_LOGGER_NAME);
        logRecord.setParameters(new Object[]{this.project.getProjectWatcher().getPackagingType()});
        logRecord.setResourceBundle(NbBundle.getBundle(ProjectOpenedHookImpl.class));
        UI_LOGGER.log(logRecord);
        LogRecord logRecord2 = new LogRecord(Level.INFO, "USG_PROJECT_OPEN_MAVEN");
        logRecord2.setLoggerName(USG_LOGGER_NAME);
        logRecord2.setParameters(new Object[]{this.project.getProjectWatcher().getPackagingType()});
        USG_LOGGER.log(logRecord2);
    }

    protected void projectClosed() {
        this.uriReferences.clear();
        MavenFileOwnerQueryImpl mavenFileOwnerQueryImpl = MavenFileOwnerQueryImpl.getInstance();
        if (mavenFileOwnerQueryImpl != null) {
            mavenFileOwnerQueryImpl.removeMavenProject(this.project);
        } else {
            ErrorManager.getDefault().log("MavenFileOwnerQueryImpl not found..");
        }
        this.detachUpdater();
        ClassPathProviderImpl classPathProviderImpl = (ClassPathProviderImpl)this.project.getLookup().lookup(ClassPathProviderImpl.class);
        GlobalPathRegistry.getDefault().unregister("classpath/boot", classPathProviderImpl.getProjectClassPaths("classpath/boot"));
        GlobalPathRegistry.getDefault().unregister("classpath/source", classPathProviderImpl.getProjectClassPaths("classpath/source"));
        GlobalPathRegistry.getDefault().unregister("classpath/compile", classPathProviderImpl.getProjectClassPaths("classpath/compile"));
    }

    private void attachUpdater() {
        FileObject fileObject = this.project.getProjectDirectory();
        FileObject fileObject2 = this.project.getHomeDirectory();
        this.project.getProjectFolderUpdater().attachAll(fileObject);
        this.project.getUserFolderUpdater().attachAll(fileObject2);
    }

    private void detachUpdater() {
        this.project.getProjectFolderUpdater().detachAll();
        this.project.getUserFolderUpdater().detachAll();
    }

    private void checkBinaryDownloads() {
        boolean bl;
        MavenSettings.DownloadStrategy downloadStrategy = MavenSettings.getDefault().getBinaryDownloadStrategy();
        if (downloadStrategy.equals((Object)MavenSettings.DownloadStrategy.NEVER)) {
            return;
        }
        NbMavenProject nbMavenProject = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
        Preferences preferences = ProjectUtils.getPreferences((Project)this.project, NbMavenProject.class, (boolean)false);
        if (downloadStrategy.equals((Object)MavenSettings.DownloadStrategy.EVERY_OPEN)) {
            nbMavenProject.synchronousDependencyDownload();
            preferences.putBoolean(PROP_BINARIES_CHECKED, true);
            try {
                preferences.sync();
            }
            catch (BackingStoreException backingStoreException) {
                Exceptions.printStackTrace((Throwable)backingStoreException);
            }
        } else if (downloadStrategy.equals((Object)MavenSettings.DownloadStrategy.FIRST_OPEN) && !(bl = preferences.getBoolean(PROP_BINARIES_CHECKED, false))) {
            nbMavenProject.synchronousDependencyDownload();
            preferences.putBoolean(PROP_BINARIES_CHECKED, true);
            try {
                preferences.sync();
            }
            catch (BackingStoreException backingStoreException) {
                Exceptions.printStackTrace((Throwable)backingStoreException);
            }
        }
    }

    private void checkJavadocDownloads() {
        boolean bl;
        MavenSettings.DownloadStrategy downloadStrategy = MavenSettings.getDefault().getJavadocDownloadStrategy();
        if (downloadStrategy.equals((Object)MavenSettings.DownloadStrategy.NEVER)) {
            return;
        }
        NbMavenProject nbMavenProject = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
        Preferences preferences = ProjectUtils.getPreferences((Project)this.project, NbMavenProject.class, (boolean)false);
        if (downloadStrategy.equals((Object)MavenSettings.DownloadStrategy.EVERY_OPEN)) {
            nbMavenProject.triggerSourceJavadocDownload(true);
            preferences.putBoolean(PROP_JAVADOC_CHECKED, true);
            try {
                preferences.sync();
            }
            catch (BackingStoreException backingStoreException) {
                Exceptions.printStackTrace((Throwable)backingStoreException);
            }
        } else if (downloadStrategy.equals((Object)MavenSettings.DownloadStrategy.FIRST_OPEN) && !(bl = preferences.getBoolean(PROP_JAVADOC_CHECKED, false))) {
            nbMavenProject.triggerSourceJavadocDownload(true);
            preferences.putBoolean(PROP_JAVADOC_CHECKED, true);
            try {
                preferences.sync();
            }
            catch (BackingStoreException backingStoreException) {
                Exceptions.printStackTrace((Throwable)backingStoreException);
            }
        }
    }

    private void checkSourceDownloads() {
        boolean bl;
        MavenSettings.DownloadStrategy downloadStrategy = MavenSettings.getDefault().getSourceDownloadStrategy();
        if (downloadStrategy.equals((Object)MavenSettings.DownloadStrategy.NEVER)) {
            return;
        }
        NbMavenProject nbMavenProject = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
        Preferences preferences = ProjectUtils.getPreferences((Project)this.project, NbMavenProject.class, (boolean)false);
        if (downloadStrategy.equals((Object)MavenSettings.DownloadStrategy.EVERY_OPEN)) {
            nbMavenProject.triggerSourceJavadocDownload(false);
            preferences.putBoolean(PROP_SOURCE_CHECKED, true);
            try {
                preferences.sync();
            }
            catch (BackingStoreException backingStoreException) {
                Exceptions.printStackTrace((Throwable)backingStoreException);
            }
        } else if (downloadStrategy.equals((Object)MavenSettings.DownloadStrategy.FIRST_OPEN) && !(bl = preferences.getBoolean(PROP_SOURCE_CHECKED, false))) {
            nbMavenProject.triggerSourceJavadocDownload(false);
            preferences.putBoolean(PROP_SOURCE_CHECKED, true);
            try {
                preferences.sync();
            }
            catch (BackingStoreException backingStoreException) {
                Exceptions.printStackTrace((Throwable)backingStoreException);
            }
        }
    }
}

