/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.jaxws.projects;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.api.client.WebServicesClientSupport;
import org.netbeans.modules.websvc.api.jaxws.client.JAXWSClientSupport;
import org.netbeans.modules.websvc.core.jaxws.projects.J2SEProjectJAXWSClientSupport;
import org.netbeans.modules.websvc.core.jaxws.projects.J2SEProjectJaxRpcClientSupport;
import org.netbeans.modules.websvc.core.jaxws.projects.JaxWsCatalogPanel;
import org.netbeans.modules.websvc.spi.client.WebServicesClientSupportFactory;
import org.netbeans.modules.websvc.spi.client.WebServicesClientSupportImpl;
import org.netbeans.modules.websvc.spi.jaxws.client.JAXWSClientSupportFactory;
import org.netbeans.modules.websvc.spi.jaxws.client.JAXWSClientSupportImpl;
import org.netbeans.spi.project.LookupProvider;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;

public class J2SEWSSupportLookupProvider
implements LookupProvider {
    public Lookup createAdditionalLookup(Lookup lookup) {
        final Project project = (Project)lookup.lookup(Project.class);
        J2SEProjectJAXWSClientSupport j2SEProjectJAXWSClientSupport = new J2SEProjectJAXWSClientSupport(project);
        final JAXWSClientSupport jAXWSClientSupport = JAXWSClientSupportFactory.createJAXWSClientSupport((JAXWSClientSupportImpl)j2SEProjectJAXWSClientSupport);
        J2SEProjectJaxRpcClientSupport j2SEProjectJaxRpcClientSupport = new J2SEProjectJaxRpcClientSupport(project);
        final WebServicesClientSupport webServicesClientSupport = WebServicesClientSupportFactory.createWebServicesClientSupport((WebServicesClientSupportImpl)j2SEProjectJaxRpcClientSupport);
        ProjectOpenedHook projectOpenedHook = new ProjectOpenedHook(){

            protected void projectOpened() {
                if (webServicesClientSupport.isBroken(project)) {
                    webServicesClientSupport.showBrokenAlert(project);
                }
                if (jAXWSClientSupport.getServiceClients().size() > 0) {
                    FileObject fileObject = null;
                    try {
                        fileObject = jAXWSClientSupport.getWsdlFolder(false);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (fileObject == null || fileObject.getParent().getFileObject("jax-ws-catalog.xml") == null) {
                        RequestProcessor.getDefault().post(new Runnable(){

                            public void run() {
                                try {
                                    JaxWsCatalogPanel.generateJaxWsCatalog(project, jAXWSClientSupport);
                                }
                                catch (IOException iOException) {
                                    Logger.getLogger(JaxWsCatalogPanel.class.getName()).log(Level.WARNING, "Cannot create jax-ws-catalog.xml", iOException);
                                }
                            }
                        });
                    }
                }
            }

            protected void projectClosed() {
            }
        };
        return Lookups.fixed((Object[])new Object[]{jAXWSClientSupport, webServicesClientSupport, projectOpenedHook});
    }
}

