/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.devmodules.api;

import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.ModuleType;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.j2ee.deployment.config.J2eeModuleAccessor;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleBase;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleImplementation;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleImplementation2;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.openide.filesystems.FileObject;
import org.openide.util.Parameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class J2eeModule {
    public static final String MIME_J2EE_MODULE_TARGET = "MIME-org-nb-j2eeserver-J2eeModule-BuildTarget";
    public static final Object EAR = ModuleType.EAR;
    public static final Object WAR = ModuleType.WAR;
    public static final Object EJB = ModuleType.EJB;
    public static final Object CONN = ModuleType.RAR;
    public static final Object CLIENT = ModuleType.CAR;
    public static final String J2EE_13 = "1.3";
    public static final String J2EE_14 = "1.4";
    public static final String JAVA_EE_5 = "1.5";
    public static final String APP_XML = "META-INF/application.xml";
    public static final String WEB_XML = "WEB-INF/web.xml";
    public static final String WEBSERVICES_XML = "WEB-INF/webservices.xml";
    public static final String EJBJAR_XML = "META-INF/ejb-jar.xml";
    public static final String EJBSERVICES_XML = "META-INF/webservices.xml";
    public static final String CONNECTOR_XML = "META-INF/ra.xml";
    public static final String CLIENT_XML = "META-INF/application-client.xml";
    public static final String PROP_RESOURCE_DIRECTORY = "resourceDir";
    public static final String PROP_MODULE_VERSION = "moduleVersion";
    private static final Logger LOGGER = Logger.getLogger(J2eeModule.class.getName());
    private J2eeModuleProvider j2eeModuleProvider;
    private final J2eeModuleBase impl;

    J2eeModule(J2eeModuleBase j2eeModuleBase) {
        this.impl = j2eeModuleBase;
    }

    public String getModuleVersion() {
        return this.impl.getModuleVersion();
    }

    @NonNull
    public Object getModuleType() {
        if (this.impl instanceof J2eeModuleImplementation2) {
            return ((J2eeModuleImplementation2)this.impl).getModuleType().getJsrType();
        }
        return ((J2eeModuleImplementation)this.impl).getModuleType();
    }

    @NonNull
    public Type getType() {
        if (this.impl instanceof J2eeModuleImplementation2) {
            return ((J2eeModuleImplementation2)this.impl).getModuleType();
        }
        Type type = Type.fromJsrType(((J2eeModuleImplementation)this.impl).getModuleType());
        assert (type != null);
        return type;
    }

    public String getUrl() {
        return this.impl.getUrl();
    }

    public FileObject getArchive() throws IOException {
        return this.impl.getArchive();
    }

    public Iterator getArchiveContents() throws IOException {
        return this.impl.getArchiveContents();
    }

    public FileObject getContentDirectory() throws IOException {
        return this.impl.getContentDirectory();
    }

    public <T> MetadataModel<T> getMetadataModel(Class<T> clazz) {
        Parameters.notNull((CharSequence)"type", clazz);
        return this.impl.getMetadataModel(clazz);
    }

    public File getResourceDirectory() {
        return this.impl.getResourceDirectory();
    }

    public File getDeploymentConfigurationFile(String string) {
        return this.impl.getDeploymentConfigurationFile(string);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.impl.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.impl.removePropertyChangeListener(propertyChangeListener);
    }

    synchronized J2eeModuleProvider getJ2eeModuleProvider() {
        return this.j2eeModuleProvider;
    }

    synchronized void setJ2eeModuleProvider(J2eeModuleProvider j2eeModuleProvider) {
        this.j2eeModuleProvider = j2eeModuleProvider;
    }

    static {
        J2eeModuleAccessor.setDefault(new J2eeModuleAccessor(){

            public J2eeModule createJ2eeModule(J2eeModuleImplementation j2eeModuleImplementation) {
                return new J2eeModule(j2eeModuleImplementation);
            }

            public J2eeModule createJ2eeModule(J2eeModuleImplementation2 j2eeModuleImplementation2) {
                return new J2eeModule(j2eeModuleImplementation2);
            }

            public J2eeModuleProvider getJ2eeModuleProvider(J2eeModule j2eeModule) {
                return j2eeModule.getJ2eeModuleProvider();
            }

            public void setJ2eeModuleProvider(J2eeModule j2eeModule, J2eeModuleProvider j2eeModuleProvider) {
                j2eeModule.setJ2eeModuleProvider(j2eeModuleProvider);
            }

            public ModuleType getJsrModuleType(Type type) {
                return type.getJsrType();
            }
        });
    }

    public static final class Type {
        public static final Type WAR = new Type(ModuleType.WAR);
        public static final Type EJB = new Type(ModuleType.EJB);
        public static final Type EAR = new Type(ModuleType.EAR);
        public static final Type CAR = new Type(ModuleType.CAR);
        public static final Type RAR = new Type(ModuleType.RAR);
        private final ModuleType jsrType;

        private Type(ModuleType moduleType) {
            this.jsrType = moduleType;
        }

        private ModuleType getJsrType() {
            return this.jsrType;
        }

        public static Type fromJsrType(Object object) {
            if (object instanceof Type) {
                boolean bl = false;
                if (!$assertionsDisabled) {
                    bl = true;
                    if (!true) {
                        throw new AssertionError();
                    }
                }
                if (bl) {
                    LOGGER.log(Level.WARNING, "Redundant call to conversion method", new Exception());
                }
                return (Type)object;
            }
            assert (object instanceof ModuleType);
            if (WAR.equals(object)) {
                return WAR;
            }
            if (EJB.equals(object)) {
                return EJB;
            }
            if (EAR.equals(object)) {
                return EAR;
            }
            if (CLIENT.equals(object)) {
                return CAR;
            }
            if (CONN.equals(object)) {
                return RAR;
            }
            return null;
        }
    }

    public static interface RootedEntry {
        public FileObject getFileObject();

        public String getRelativePath();
    }
}

