/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.FileChannel;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.openide.util.Lookup;
import org.openidex.search.SearchType;
import sun.nio.cs.ThreadLocalCoders;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Utils {
    private static Lookup.Result<SearchType> result;

    private Utils() {
    }

    private static Lookup.Result<SearchType> getSearchTypes0() {
        if (result == null) {
            result = Lookup.getDefault().lookup(new Lookup.Template(SearchType.class));
        }
        return result;
    }

    static Collection<? extends SearchType> getSearchTypes() {
        return Utils.getSearchTypes0().allInstances();
    }

    static Class searchTypeForName(String string) {
        for (Class clazz : Utils.getSearchTypes0().allClasses()) {
            if (!clazz.getName().equals(string)) continue;
            return clazz;
        }
        return null;
    }

    static final Border getExplorerViewBorder() {
        Border border = (Border)UIManager.get("Nb.ScrollPane.border");
        if (border == null) {
            border = BorderFactory.createEtchedBorder();
        }
        return border;
    }

    static List<SearchType> cloneSearchTypes(Collection<? extends SearchType> collection) {
        if (collection.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<SearchType> arrayList = new ArrayList<SearchType>(collection.size());
        for (SearchType searchType : collection) {
            arrayList.add((SearchType)searchType.clone());
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static CharBuffer getCharSequence(FileInputStream fileInputStream, Charset charset) throws IOException {
        FileChannel fileChannel = fileInputStream.getChannel();
        ByteBuffer byteBuffer = ByteBuffer.allocate((int)fileChannel.size());
        try {
            fileChannel.read(byteBuffer, 0L);
        }
        catch (ClosedByInterruptException closedByInterruptException) {
            CharBuffer charBuffer = null;
            return charBuffer;
        }
        finally {
            fileChannel.close();
        }
        byteBuffer.rewind();
        CharBuffer charBuffer = Utils.decodeByteBuffer(byteBuffer, charset);
        return charBuffer;
    }

    static CharBuffer decodeByteBuffer(ByteBuffer byteBuffer, Charset charset) throws CharacterCodingException {
        CharsetDecoder charsetDecoder = ThreadLocalCoders.decoderFor(charset.name()).onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        int n = byteBuffer.remaining();
        if (n == 0) {
            return CharBuffer.allocate(0);
        }
        int n2 = (int)((float)n * charsetDecoder.averageCharsPerByte());
        if (n2 < 16) {
            n2 = 16;
        }
        CharBuffer charBuffer = CharBuffer.allocate(n2);
        charsetDecoder.reset();
        while (true) {
            CoderResult coderResult;
            CoderResult coderResult2 = coderResult = byteBuffer.hasRemaining() ? charsetDecoder.decode(byteBuffer, charBuffer, true) : CoderResult.UNDERFLOW;
            if (coderResult.isUnderflow()) {
                coderResult = charsetDecoder.flush(charBuffer);
            }
            if (coderResult.isUnderflow()) break;
            if (coderResult.isOverflow()) {
                CharBuffer charBuffer2 = CharBuffer.allocate(n2 <<= 1);
                charBuffer.flip();
                charBuffer2.put(charBuffer);
                charBuffer = charBuffer2;
                continue;
            }
            coderResult.throwException();
        }
        charBuffer.flip();
        return charBuffer;
    }
}

