/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.freeform.ui;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.ant.freeform.spi.support.Util;
import org.netbeans.modules.java.freeform.JavaProjectGenerator;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileUtil;
import org.openide.modules.SpecificationVersion;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectModel {
    private File baseFolder;
    private File nbProjectFolder;
    private PropertyEvaluator evaluator;
    private String sourceLevel;
    private String encoding;
    public static final String NO_ENCODING = NbBundle.getBundle(ProjectModel.class).getString("No_Encoding");
    private List<JavaProjectGenerator.SourceFolder> sourceFolders;
    public List<JavaProjectGenerator.JavaCompilationUnit> javaCompilationUnitsList;
    private Set<String> addedSourceFolders;
    private Set<String> removedSourceFolders;
    public static final String TYPE_JAVA = "java";
    public static final String CLASSPATH_MODE_COMPILE = "compile";
    private static final SpecificationVersion JDK_MAX_SUPPORTED_VERSION = new SpecificationVersion("1.5");
    private final ChangeSupport cs = new ChangeSupport((Object)this);

    private ProjectModel(File file, File file2, PropertyEvaluator propertyEvaluator, List<JavaProjectGenerator.SourceFolder> list, List<JavaProjectGenerator.JavaCompilationUnit> list2) {
        this.baseFolder = file;
        this.nbProjectFolder = file2;
        this.evaluator = propertyEvaluator;
        this.sourceFolders = list;
        this.javaCompilationUnitsList = list2;
        if (this.javaCompilationUnitsList.size() > 0) {
            this.sourceLevel = this.javaCompilationUnitsList.get((int)0).sourceLevel;
        }
        if (this.sourceLevel == null) {
            this.setSourceLevel(ProjectModel.getDefaultSourceLevel());
        }
        if (list.size() > 0) {
            JavaProjectGenerator.SourceFolder sourceFolder = list.get(0);
            this.encoding = sourceFolder.encoding == null ? null : Charset.forName(sourceFolder.encoding).name();
        }
        this.resetState();
    }

    public final void addChangeListener(ChangeListener changeListener) {
        this.cs.addChangeListener(changeListener);
    }

    public final void removeChangeListener(ChangeListener changeListener) {
        this.cs.removeChangeListener(changeListener);
    }

    protected final void fireChangeEvent() {
        this.cs.fireChange();
    }

    private void resetState() {
        this.addedSourceFolders = new HashSet<String>();
        this.removedSourceFolders = new HashSet<String>();
    }

    public static ProjectModel createEmptyModel(File file, File file2, PropertyEvaluator propertyEvaluator) {
        return new ProjectModel(file, file2, propertyEvaluator, new ArrayList<JavaProjectGenerator.SourceFolder>(), new ArrayList<JavaProjectGenerator.JavaCompilationUnit>());
    }

    public static ProjectModel createModel(final File file, final File file2, final PropertyEvaluator propertyEvaluator, final AntProjectHelper antProjectHelper) {
        return (ProjectModel)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<ProjectModel>(){

            public ProjectModel run() {
                ProjectModel projectModel = new ProjectModel(file, file2, propertyEvaluator, JavaProjectGenerator.getSourceFolders(antProjectHelper, ProjectModel.TYPE_JAVA), JavaProjectGenerator.getJavaCompilationUnits(antProjectHelper, Util.getAuxiliaryConfiguration((AntProjectHelper)antProjectHelper)));
                ProjectModel.updateStyle(projectModel.sourceFolders);
                return projectModel;
            }
        });
    }

    public static void instantiateJavaProject(AntProjectHelper antProjectHelper, ProjectModel projectModel) throws IOException {
        List<String> list;
        List<JavaProjectGenerator.SourceFolder> list2 = projectModel.updatePrincipalSourceFolders(projectModel.sourceFolders, true);
        ProjectModel.updateSourceFolders(list2, projectModel);
        if (list2.size() > 0) {
            JavaProjectGenerator.putSourceFolders(antProjectHelper, list2, null);
        }
        if (list2.size() > 0) {
            JavaProjectGenerator.putSourceViews(antProjectHelper, list2, null);
        }
        JavaProjectGenerator.putJavaCompilationUnits(antProjectHelper, Util.getAuxiliaryConfiguration((AntProjectHelper)antProjectHelper), projectModel.javaCompilationUnitsList);
        List<JavaProjectGenerator.Export> list3 = JavaProjectGenerator.guessExports(projectModel.evaluator, projectModel.baseFolder, JavaProjectGenerator.getTargetMappings(antProjectHelper), projectModel.javaCompilationUnitsList);
        if (list3.size() > 0) {
            JavaProjectGenerator.putExports(antProjectHelper, list3);
        }
        if ((list = JavaProjectGenerator.guessSubprojects(projectModel.evaluator, projectModel.javaCompilationUnitsList, projectModel.baseFolder, projectModel.nbProjectFolder)).size() > 0) {
            JavaProjectGenerator.putSubprojects(antProjectHelper, list);
        }
        projectModel.resetState();
    }

    public static void saveProject(final AntProjectHelper antProjectHelper, final ProjectModel projectModel) {
        ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Void>(){

            public Void run() {
                JavaProjectGenerator.putSourceFolders(antProjectHelper, projectModel.sourceFolders, ProjectModel.TYPE_JAVA);
                JavaProjectGenerator.putSourceViews(antProjectHelper, projectModel.sourceFolders, "packages");
                List<JavaProjectGenerator.SourceFolder> list = JavaProjectGenerator.getSourceFolders(antProjectHelper, null);
                list = projectModel.updatePrincipalSourceFolders(list, false);
                ProjectModel.updateSourceFolders(list, projectModel);
                JavaProjectGenerator.putSourceFolders(antProjectHelper, list, null);
                AuxiliaryConfiguration auxiliaryConfiguration = Util.getAuxiliaryConfiguration((AntProjectHelper)antProjectHelper);
                JavaProjectGenerator.putJavaCompilationUnits(antProjectHelper, auxiliaryConfiguration, projectModel.javaCompilationUnitsList);
                projectModel.resetState();
                List<JavaProjectGenerator.Export> list2 = JavaProjectGenerator.guessExports(projectModel.getEvaluator(), projectModel.baseFolder, JavaProjectGenerator.getTargetMappings(antProjectHelper), projectModel.javaCompilationUnitsList);
                JavaProjectGenerator.putExports(antProjectHelper, list2);
                List<String> list3 = JavaProjectGenerator.guessSubprojects(projectModel.getEvaluator(), projectModel.javaCompilationUnitsList, projectModel.baseFolder, projectModel.nbProjectFolder);
                JavaProjectGenerator.putSubprojects(antProjectHelper, list3);
                List<String> list4 = JavaProjectGenerator.guessBuildFolders(projectModel.getEvaluator(), projectModel.javaCompilationUnitsList, projectModel.baseFolder, projectModel.nbProjectFolder);
                JavaProjectGenerator.putBuildFolders(antProjectHelper, list4);
                List<String> list5 = JavaProjectGenerator.getBuildFiles(projectModel.getEvaluator(), projectModel.javaCompilationUnitsList, projectModel.baseFolder, projectModel.nbProjectFolder);
                JavaProjectGenerator.putBuildFiles(antProjectHelper, list5);
                return null;
            }
        });
    }

    private static void updateSourceFolders(List<JavaProjectGenerator.SourceFolder> list, ProjectModel projectModel) {
        if (projectModel.encoding != null) {
            String string;
            JavaProjectGenerator.SourceFolder sourceFolder2;
            for (JavaProjectGenerator.SourceFolder sourceFolder2 : list) {
                if (!sourceFolder2.location.equals(".")) continue;
                sourceFolder2.encoding = projectModel.encoding;
                return;
            }
            JavaProjectGenerator.SourceFolder sourceFolder3 = new JavaProjectGenerator.SourceFolder();
            sourceFolder2 = null;
            try {
                sourceFolder2 = ProjectManager.getDefault().findProject(FileUtil.toFileObject((File)projectModel.nbProjectFolder));
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            sourceFolder3.label = string = sourceFolder2 != null ? ProjectUtils.getInformation((Project)sourceFolder2).getDisplayName() : "projectdir";
            sourceFolder3.location = ".";
            sourceFolder3.encoding = projectModel.encoding;
            list.add(sourceFolder3);
        }
    }

    List<JavaProjectGenerator.SourceFolder> updatePrincipalSourceFolders(List<JavaProjectGenerator.SourceFolder> list, boolean bl) {
        Object object;
        ArrayList<JavaProjectGenerator.SourceFolder> arrayList = new ArrayList<JavaProjectGenerator.SourceFolder>(list);
        for (String string : this.addedSourceFolders) {
            if (!this.isExternalSourceRoot(string)) continue;
            boolean bl2 = false;
            object = "";
            String string2 = null;
            String string3 = null;
            for (JavaProjectGenerator.SourceFolder sourceFolder : arrayList) {
                if (sourceFolder.location.equals(string) && sourceFolder.type == null) {
                    bl2 = true;
                    break;
                }
                if (!sourceFolder.location.equals(string) || sourceFolder.type == null) continue;
                object = sourceFolder.label;
                string2 = sourceFolder.includes;
                string3 = sourceFolder.excludes;
            }
            if (bl2) continue;
            JavaProjectGenerator.SourceFolder sourceFolder = new JavaProjectGenerator.SourceFolder();
            sourceFolder.location = string;
            sourceFolder.label = object;
            sourceFolder.includes = string2;
            sourceFolder.excludes = string3;
            arrayList.add(sourceFolder);
        }
        for (String string : this.removedSourceFolders) {
            if (!this.isExternalSourceRoot(string)) continue;
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                object = (JavaProjectGenerator.SourceFolder)iterator.next();
                if (!((JavaProjectGenerator.SourceFolder)object).location.equals(string) || ((JavaProjectGenerator.SourceFolder)object).type != null) continue;
                iterator.remove();
            }
        }
        if (bl && !this.baseFolder.equals(this.nbProjectFolder)) {
            JavaProjectGenerator.SourceFolder sourceFolder = new JavaProjectGenerator.SourceFolder();
            sourceFolder.location = "${project.dir}";
            sourceFolder.label = this.baseFolder.getName();
            arrayList.add(sourceFolder);
        }
        return arrayList;
    }

    private boolean isExternalSourceRoot(String string) {
        File file;
        String string2;
        String string3 = this.baseFolder.getAbsolutePath();
        if (!string3.endsWith(File.separator)) {
            string3 = string3 + File.separatorChar;
        }
        if (!(string2 = this.nbProjectFolder.getAbsolutePath()).endsWith(File.separator)) {
            string2 = string2 + File.separatorChar;
        }
        if ((file = Util.resolveFile((PropertyEvaluator)this.evaluator, (File)this.baseFolder, (String)string)) == null) {
            return false;
        }
        string = file.getAbsolutePath();
        return !string.startsWith(string3) && !string.startsWith(string2);
    }

    public File getBaseFolder() {
        return this.baseFolder;
    }

    public File getNBProjectFolder() {
        return this.nbProjectFolder;
    }

    public PropertyEvaluator getEvaluator() {
        return this.evaluator;
    }

    public int getSourceFoldersCount() {
        return this.sourceFolders.size();
    }

    public JavaProjectGenerator.SourceFolder getSourceFolder(int n) {
        return this.sourceFolders.get(n);
    }

    public void moveSourceFolder(int n, int n2) {
        JavaProjectGenerator.SourceFolder sourceFolder = this.sourceFolders.remove(n);
        this.sourceFolders.add(n2, sourceFolder);
    }

    public void addSourceFolder(JavaProjectGenerator.SourceFolder sourceFolder, boolean bl) {
        Object object;
        List<CompilationUnitKey> list = this.createCompilationUnitKeys();
        boolean bl2 = ProjectModel.isSingleCompilationUnit(list);
        if (bl2) {
            object = this.javaCompilationUnitsList.get(0);
            if (((JavaProjectGenerator.JavaCompilationUnit)object).isTests != bl) {
                this.updateCompilationUnits(true);
                bl2 = false;
            }
        }
        this.sourceFolders.add(sourceFolder);
        if (bl2) {
            if (TYPE_JAVA.equals(sourceFolder.type)) {
                object = this.javaCompilationUnitsList.get(0);
                ((JavaProjectGenerator.JavaCompilationUnit)object).packageRoots.add(sourceFolder.location);
            }
        } else {
            for (CompilationUnitKey compilationUnitKey : this.createCompilationUnitKeys()) {
                this.getCompilationUnit(compilationUnitKey, bl);
            }
        }
        if (this.removedSourceFolders.contains(sourceFolder.location)) {
            this.removedSourceFolders.remove(sourceFolder.location);
        } else {
            this.addedSourceFolders.add(sourceFolder.location);
        }
        this.fireChangeEvent();
    }

    public void removeSourceFolder(int n) {
        JavaProjectGenerator.SourceFolder sourceFolder = this.sourceFolders.get(n);
        if (TYPE_JAVA.equals(sourceFolder.type)) {
            this.removeSourceLocation(sourceFolder.location);
        }
        this.sourceFolders.remove(n);
        if (this.addedSourceFolders.contains(sourceFolder.location)) {
            this.addedSourceFolders.remove(sourceFolder.location);
        } else {
            this.removedSourceFolders.add(sourceFolder.location);
        }
        this.fireChangeEvent();
    }

    public void clearSourceFolders() {
        this.sourceFolders.clear();
        this.javaCompilationUnitsList.clear();
        this.fireChangeEvent();
    }

    public String getSourceLevel() {
        return this.sourceLevel;
    }

    public void setSourceLevel(String string) {
        if (this.sourceLevel == null && string == null || this.sourceLevel != null && this.sourceLevel.equals(string)) {
            return;
        }
        this.sourceLevel = string;
        for (JavaProjectGenerator.JavaCompilationUnit javaCompilationUnit : this.javaCompilationUnitsList) {
            javaCompilationUnit.sourceLevel = string;
        }
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String string) {
        this.encoding = string == null || string.equals(NO_ENCODING) ? null : string;
        for (JavaProjectGenerator.SourceFolder sourceFolder : this.sourceFolders) {
            sourceFolder.encoding = this.encoding;
        }
    }

    public boolean canHaveSeparateClasspath() {
        return this.sourceFolders.size() > 1 || this.javaCompilationUnitsList.size() > 1;
    }

    public boolean canCreateSingleCompilationUnit() {
        boolean bl = false;
        boolean bl2 = false;
        for (JavaProjectGenerator.JavaCompilationUnit javaCompilationUnit : this.javaCompilationUnitsList) {
            if (javaCompilationUnit.isTests) {
                bl = true;
                continue;
            }
            bl2 = true;
        }
        return !bl || !bl2;
    }

    public static boolean isSingleCompilationUnit(List<CompilationUnitKey> list) {
        return list.size() == 1 && list.get((int)0).label == null;
    }

    public List<CompilationUnitKey> createCompilationUnitKeys() {
        CompilationUnitKey compilationUnitKey;
        ArrayList<CompilationUnitKey> arrayList = new ArrayList<CompilationUnitKey>();
        for (JavaProjectGenerator.JavaCompilationUnit object : this.javaCompilationUnitsList) {
            compilationUnitKey = new CompilationUnitKey();
            compilationUnitKey.locations = object.packageRoots;
            compilationUnitKey.label = null;
            arrayList.add(compilationUnitKey);
        }
        for (JavaProjectGenerator.SourceFolder sourceFolder : this.sourceFolders) {
            if (!TYPE_JAVA.equals(sourceFolder.type)) continue;
            compilationUnitKey = new CompilationUnitKey();
            compilationUnitKey.locations = new ArrayList<String>();
            compilationUnitKey.locations.add(sourceFolder.location);
            compilationUnitKey.label = sourceFolder.label;
            int n = arrayList.indexOf(compilationUnitKey);
            if (n != -1) {
                CompilationUnitKey compilationUnitKey2 = (CompilationUnitKey)arrayList.get(n);
                compilationUnitKey2.label = sourceFolder.label;
                continue;
            }
            boolean bl = false;
            for (JavaProjectGenerator.JavaCompilationUnit javaCompilationUnit : this.javaCompilationUnitsList) {
                if (!javaCompilationUnit.packageRoots.contains(sourceFolder.location)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            arrayList.add(compilationUnitKey);
        }
        return arrayList;
    }

    public void updateCompilationUnits(boolean bl) {
        if (bl) {
            String string = null;
            List<String> list = null;
            if (this.javaCompilationUnitsList.size() > 0) {
                List<JavaProjectGenerator.JavaCompilationUnit.CP> list2 = this.javaCompilationUnitsList.get((int)0).classpath;
                if (list2 != null) {
                    for (JavaProjectGenerator.JavaCompilationUnit.CP cP : list2) {
                        if (!cP.mode.equals(CLASSPATH_MODE_COMPILE)) continue;
                        string = cP.classpath;
                        break;
                    }
                }
                list = this.javaCompilationUnitsList.get((int)0).output;
            }
            this.javaCompilationUnitsList.clear();
            for (JavaProjectGenerator.SourceFolder sourceFolder : this.sourceFolders) {
                JavaProjectGenerator.JavaCompilationUnit javaCompilationUnit = new JavaProjectGenerator.JavaCompilationUnit();
                javaCompilationUnit.packageRoots = new ArrayList<String>();
                javaCompilationUnit.packageRoots.add(sourceFolder.location);
                if (string != null) {
                    JavaProjectGenerator.JavaCompilationUnit.CP cP = new JavaProjectGenerator.JavaCompilationUnit.CP();
                    cP.mode = CLASSPATH_MODE_COMPILE;
                    cP.classpath = string;
                    javaCompilationUnit.classpath = new ArrayList<JavaProjectGenerator.JavaCompilationUnit.CP>();
                    javaCompilationUnit.classpath.add(cP);
                }
                if (list != null) {
                    javaCompilationUnit.output = new ArrayList<String>();
                    javaCompilationUnit.output.addAll(list);
                }
                javaCompilationUnit.sourceLevel = this.sourceLevel;
                this.javaCompilationUnitsList.add(javaCompilationUnit);
            }
        } else {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (JavaProjectGenerator.SourceFolder sourceFolder : this.sourceFolders) {
                arrayList.add(sourceFolder.location);
            }
            LinkedHashSet linkedHashSet = new LinkedHashSet();
            LinkedHashSet<String> linkedHashSet2 = new LinkedHashSet<String>();
            for (JavaProjectGenerator.JavaCompilationUnit javaCompilationUnit : this.javaCompilationUnitsList) {
                if (javaCompilationUnit.output != null) {
                    linkedHashSet2.addAll(javaCompilationUnit.output);
                }
                if (javaCompilationUnit.classpath == null) continue;
                for (JavaProjectGenerator.JavaCompilationUnit.CP cP : javaCompilationUnit.classpath) {
                    if (!cP.mode.equals(CLASSPATH_MODE_COMPILE)) continue;
                    linkedHashSet.addAll(Arrays.asList(PropertyUtils.tokenizePath((String)cP.classpath)));
                }
            }
            this.javaCompilationUnitsList.clear();
            JavaProjectGenerator.JavaCompilationUnit javaCompilationUnit = new JavaProjectGenerator.JavaCompilationUnit();
            javaCompilationUnit.packageRoots = arrayList;
            JavaProjectGenerator.JavaCompilationUnit.CP cP = new JavaProjectGenerator.JavaCompilationUnit.CP();
            if (linkedHashSet.size() > 0) {
                StringBuffer stringBuffer = new StringBuffer();
                Iterator iterator = linkedHashSet.iterator();
                while (iterator.hasNext()) {
                    stringBuffer.append((String)iterator.next());
                    if (!iterator.hasNext()) continue;
                    stringBuffer.append(File.pathSeparatorChar);
                }
                cP.classpath = stringBuffer.toString();
                cP.mode = CLASSPATH_MODE_COMPILE;
                javaCompilationUnit.classpath = new ArrayList<JavaProjectGenerator.JavaCompilationUnit.CP>();
                javaCompilationUnit.classpath.add(cP);
            }
            javaCompilationUnit.output = new ArrayList<String>(linkedHashSet2);
            javaCompilationUnit.sourceLevel = this.sourceLevel;
            this.javaCompilationUnitsList.add(javaCompilationUnit);
        }
        this.fireChangeEvent();
    }

    public JavaProjectGenerator.JavaCompilationUnit getCompilationUnit(CompilationUnitKey compilationUnitKey, boolean bl) {
        for (JavaProjectGenerator.JavaCompilationUnit javaCompilationUnit : this.javaCompilationUnitsList) {
            if (!((Object)javaCompilationUnit.packageRoots).equals(compilationUnitKey.locations)) continue;
            return javaCompilationUnit;
        }
        JavaProjectGenerator.JavaCompilationUnit javaCompilationUnit = new JavaProjectGenerator.JavaCompilationUnit();
        javaCompilationUnit.packageRoots = compilationUnitKey.locations;
        javaCompilationUnit.sourceLevel = this.sourceLevel;
        javaCompilationUnit.isTests = bl;
        this.javaCompilationUnitsList.add(javaCompilationUnit);
        return javaCompilationUnit;
    }

    private void removeSourceLocation(String string) {
        Iterator<JavaProjectGenerator.JavaCompilationUnit> iterator = this.javaCompilationUnitsList.iterator();
        while (iterator.hasNext()) {
            JavaProjectGenerator.JavaCompilationUnit javaCompilationUnit = iterator.next();
            if (javaCompilationUnit.packageRoots.contains(string)) {
                javaCompilationUnit.packageRoots.remove(string);
            }
            if (javaCompilationUnit.packageRoots.size() != 0) continue;
            iterator.remove();
        }
    }

    private static void updateStyle(List<JavaProjectGenerator.SourceFolder> list) {
        for (JavaProjectGenerator.SourceFolder sourceFolder : list) {
            assert (sourceFolder.type.equals(TYPE_JAVA));
            sourceFolder.style = "packages";
        }
    }

    void setSourceFolders(List<JavaProjectGenerator.SourceFolder> list) {
        this.sourceFolders = list;
    }

    List<JavaProjectGenerator.SourceFolder> getSourceFolders() {
        return this.sourceFolders;
    }

    void setJavaCompilationUnits(List<JavaProjectGenerator.JavaCompilationUnit> list) {
        this.javaCompilationUnitsList = list;
    }

    List<JavaProjectGenerator.JavaCompilationUnit> getJavaCompilationUnits() {
        return this.javaCompilationUnitsList;
    }

    public static String getDefaultSourceLevel() {
        JavaPlatform javaPlatform = JavaPlatform.getDefault();
        SpecificationVersion specificationVersion = javaPlatform.getSpecification().getVersion();
        if (specificationVersion.compareTo((Object)JDK_MAX_SUPPORTED_VERSION) > 0) {
            specificationVersion = JDK_MAX_SUPPORTED_VERSION;
        }
        return specificationVersion.toString();
    }

    public boolean isTestSourceFolder(int n) {
        return this.isTestSourceFolder(this.getSourceFolder(n));
    }

    public boolean isTestSourceFolder(JavaProjectGenerator.SourceFolder sourceFolder) {
        for (JavaProjectGenerator.JavaCompilationUnit javaCompilationUnit : this.javaCompilationUnitsList) {
            if (!javaCompilationUnit.packageRoots.contains(sourceFolder.location)) continue;
            return javaCompilationUnit.isTests;
        }
        return false;
    }

    public static class CompilationUnitKey {
        public List<String> locations;
        public String label;

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof CompilationUnitKey)) {
                return false;
            }
            CompilationUnitKey compilationUnitKey = (CompilationUnitKey)object;
            return ((Object)this.locations).equals(compilationUnitKey.locations);
        }

        public int hashCode() {
            return ((Object)this.locations).hashCode() * 7;
        }

        public String toString() {
            return "PM.CUK:[label=" + this.label + ", locations=" + this.locations + ", this=" + super.toString() + "]";
        }
    }
}

