/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject.ui.wizards;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.java.j2seproject.J2SEProjectGenerator;
import org.netbeans.modules.java.j2seproject.ui.FoldersListSettings;
import org.netbeans.modules.java.j2seproject.ui.wizards.PanelConfigureProject;
import org.netbeans.modules.java.j2seproject.ui.wizards.PanelIncludesExcludes;
import org.netbeans.modules.java.j2seproject.ui.wizards.PanelSourceFolders;
import org.netbeans.spi.java.project.support.ui.SharableLibrariesUtils;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewJ2SEProjectWizardIterator
implements WizardDescriptor.ProgressInstantiatingIterator {
    static final String PROP_NAME_INDEX = "nameIndex";
    private static final String MANIFEST_FILE = "manifest.mf";
    private static final long serialVersionUID = 1L;
    private WizardType type;
    private transient int index;
    private transient WizardDescriptor.Panel[] panels;
    private transient WizardDescriptor wiz;

    public NewJ2SEProjectWizardIterator() {
        this(WizardType.APP);
    }

    public NewJ2SEProjectWizardIterator(WizardType wizardType) {
        this.type = wizardType;
    }

    public static NewJ2SEProjectWizardIterator library() {
        return new NewJ2SEProjectWizardIterator(WizardType.LIB);
    }

    public static NewJ2SEProjectWizardIterator existing() {
        return new NewJ2SEProjectWizardIterator(WizardType.EXT);
    }

    private WizardDescriptor.Panel[] createPanels() {
        switch (this.type) {
            case EXT: {
                return new WizardDescriptor.Panel[]{new PanelConfigureProject(this.type), new PanelSourceFolders.Panel(), new PanelIncludesExcludes()};
            }
        }
        return new WizardDescriptor.Panel[]{new PanelConfigureProject(this.type)};
    }

    private String[] createSteps() {
        switch (this.type) {
            case EXT: {
                return new String[]{NbBundle.getMessage(NewJ2SEProjectWizardIterator.class, (String)"LAB_ConfigureProject"), NbBundle.getMessage(NewJ2SEProjectWizardIterator.class, (String)"LAB_ConfigureSourceRoots"), NbBundle.getMessage(NewJ2SEProjectWizardIterator.class, (String)"LAB_PanelIncludesExcludes")};
            }
        }
        return new String[]{NbBundle.getMessage(NewJ2SEProjectWizardIterator.class, (String)"LAB_ConfigureProject")};
    }

    public Set<?> instantiate() throws IOException {
        assert (false) : "Cannot call this method if implements WizardDescriptor.ProgressInstantiatingIterator.";
        return null;
    }

    public Set<FileObject> instantiate(ProgressHandle progressHandle) throws IOException {
        FileObject fileObject;
        progressHandle.start(4);
        HashSet<FileObject> hashSet = new HashSet<FileObject>();
        File file = (File)this.wiz.getProperty("projdir");
        if (file != null) {
            file = FileUtil.normalizeFile((File)file);
        }
        String string = (String)this.wiz.getProperty("name");
        String string2 = (String)this.wiz.getProperty("mainClass");
        String string3 = (String)this.wiz.getProperty("sharedLibraries");
        if (string3 != null) {
            if (!string3.endsWith(File.separator)) {
                string3 = string3 + File.separatorChar;
            }
            string3 = string3 + "nblibraries.properties";
        }
        progressHandle.progress(NbBundle.getMessage(NewJ2SEProjectWizardIterator.class, (String)"LBL_NewJ2SEProjectWizardIterator_WizardProgress_CreatingProject"), 1);
        switch (this.type) {
            case EXT: {
                fileObject = (FileObject)this.wiz.getProperty("sourceRoot");
                File[] fileArray = (File[])this.wiz.getProperty("testRoot");
                String string4 = (String)this.wiz.getProperty("buildScriptName");
                AntProjectHelper antProjectHelper = J2SEProjectGenerator.createProject(file, string, (File[])fileObject, fileArray, MANIFEST_FILE, string3, string4);
                EditableProperties editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
                String string5 = (String)this.wiz.getProperty("includes");
                if (string5 == null) {
                    string5 = "**";
                }
                editableProperties.setProperty("includes", string5);
                String string6 = (String)this.wiz.getProperty("excludes");
                if (string6 == null) {
                    string6 = "";
                }
                editableProperties.setProperty("excludes", string6);
                antProjectHelper.putProperties("nbproject/project.properties", editableProperties);
                progressHandle.progress(2);
                for (FileObject fileObject2 : fileObject) {
                    FileObject fileObject3 = FileUtil.toFileObject((File)fileObject2);
                    if (fileObject3 == null) continue;
                    hashSet.add(fileObject3);
                }
                break;
            }
            default: {
                AntProjectHelper antProjectHelper = J2SEProjectGenerator.createProject(file, string, string2, this.type == WizardType.APP ? MANIFEST_FILE : null, string3);
                progressHandle.progress(2);
                if (string2 == null || string2.length() <= 0) break;
                try {
                    FileObject fileObject4 = antProjectHelper.getProjectDirectory().getFileObject("src");
                    FileObject fileObject5 = this.getMainClassFO(fileObject4, string2);
                    assert (fileObject5 != null) : "sourcesRoot: " + fileObject4 + ", mainClass: " + string2;
                    hashSet.add(fileObject5);
                    break;
                }
                catch (Exception exception) {
                    ErrorManager.getDefault().notify((Throwable)exception);
                }
            }
        }
        fileObject = FileUtil.toFileObject((File)file);
        switch (this.type) {
            case APP: {
                NewJ2SEProjectWizardIterator.createManifest(fileObject, false);
                break;
            }
            case EXT: {
                NewJ2SEProjectWizardIterator.createManifest(fileObject, true);
            }
        }
        progressHandle.progress(3);
        int n = (Integer)this.wiz.getProperty(PROP_NAME_INDEX);
        switch (this.type) {
            case APP: {
                FoldersListSettings.getDefault().setNewApplicationCount(n);
                break;
            }
            case LIB: {
                FoldersListSettings.getDefault().setNewLibraryCount(n);
                break;
            }
            case EXT: {
                FoldersListSettings.getDefault().setNewProjectCount(n);
            }
        }
        hashSet.add(fileObject);
        progressHandle.progress(NbBundle.getMessage(NewJ2SEProjectWizardIterator.class, (String)"LBL_NewJ2SEProjectWizardIterator_WizardProgress_PreparingToOpen"), 4);
        File file2 = file = file != null ? file.getParentFile() : null;
        if (file != null && file.exists()) {
            ProjectChooser.setProjectsFolder((File)file);
        }
        SharableLibrariesUtils.setLastProjectSharable((string3 != null ? 1 : 0) != 0);
        return hashSet;
    }

    public void initialize(WizardDescriptor wizardDescriptor) {
        this.wiz = wizardDescriptor;
        this.index = 0;
        this.panels = this.createPanels();
        String[] stringArray = this.createSteps();
        for (int i = 0; i < this.panels.length; ++i) {
            Component component = this.panels[i].getComponent();
            if (stringArray[i] == null) {
                stringArray[i] = component.getName();
            }
            if (!(component instanceof JComponent)) continue;
            JComponent jComponent = (JComponent)component;
            jComponent.putClientProperty("WizardPanel_contentSelectedIndex", i);
            jComponent.putClientProperty("WizardPanel_contentData", stringArray);
        }
        this.wiz.putProperty("sourceRoot", (Object)new File[0]);
        this.wiz.putProperty("testRoot", (Object)new File[0]);
    }

    public void uninitialize(WizardDescriptor wizardDescriptor) {
        if (this.wiz != null) {
            this.wiz.putProperty("projdir", null);
            this.wiz.putProperty("name", null);
            this.wiz.putProperty("mainClass", null);
            switch (this.type) {
                case EXT: {
                    this.wiz.putProperty("sourceRoot", null);
                    this.wiz.putProperty("testRoot", null);
                }
            }
            this.wiz = null;
            this.panels = null;
        }
    }

    public String name() {
        return NbBundle.getMessage(NewJ2SEProjectWizardIterator.class, (String)"LAB_IteratorName", (Object)(this.index + 1), (Object)this.panels.length);
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public final void addChangeListener(ChangeListener changeListener) {
    }

    public final void removeChangeListener(ChangeListener changeListener) {
    }

    private FileObject getMainClassFO(FileObject fileObject, String string) {
        string = string.replace('.', '/');
        return fileObject.getFileObject(string + ".java");
    }

    static String getPackageName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if ((bl || !Character.isJavaIdentifierPart(c)) && (!bl || !Character.isJavaIdentifierStart(c))) continue;
            bl = false;
            if (Character.isUpperCase(c)) {
                c = Character.toLowerCase(c);
            }
            stringBuffer.append(c);
        }
        return stringBuffer.length() == 0 ? NbBundle.getMessage(NewJ2SEProjectWizardIterator.class, (String)"TXT_DefaultPackageName") : stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createManifest(FileObject fileObject, boolean bl) throws IOException {
        if (bl && fileObject.getFileObject(MANIFEST_FILE) != null) {
            return;
        }
        FileObject fileObject2 = fileObject.createData(MANIFEST_FILE);
        FileLock fileLock = fileObject2.lock();
        try {
            OutputStream outputStream = fileObject2.getOutputStream(fileLock);
            try {
                PrintWriter printWriter = new PrintWriter(outputStream);
                printWriter.println("Manifest-Version: 1.0");
                printWriter.println("X-COMMENT: Main-Class will be added automatically by build");
                printWriter.println();
                printWriter.flush();
            }
            finally {
                outputStream.close();
            }
        }
        finally {
            fileLock.releaseLock();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum WizardType {
        APP,
        LIB,
        EXT;

    }
}

