/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.util;

import java.sql.Time;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.db.dataview.meta.DBException;
import org.netbeans.modules.db.dataview.util.TimestampType;
import org.openide.util.NbBundle;

public class TimeType {
    public static final String DEFAULT_FOMAT_PATTERN = "HH:mm:ss";
    private static final DateFormat[] TIME_PARSING_FORMATS = new DateFormat[]{new SimpleDateFormat("HH:mm:ss"), DateFormat.getTimeInstance(), DateFormat.getTimeInstance(3), DateFormat.getTimeInstance(1, TimestampType.LOCALE), DateFormat.getTimeInstance(3, TimestampType.LOCALE), new SimpleDateFormat("HH:mm:ss", TimestampType.LOCALE)};
    public static final TimeZone TIME_ZONE = TimeZone.getDefault();
    private static final long INCREMENT_DAY = 86400000L;

    public TimeType() {
        for (int i = 0; i < TIME_PARSING_FORMATS.length; ++i) {
            TIME_PARSING_FORMATS[i].setLenient(false);
        }
    }

    public static long normalizeTime(long l) {
        int n = TIME_ZONE.inDaylightTime(new Date(l)) ? TIME_ZONE.getDSTSavings() : 0;
        return l < 86400000L ? l : l % 86400000L + (long)n;
    }

    private static Time getNormalizedTime(long l) {
        Time time = null;
        time = new Time(TimeType.normalizeTime(l));
        return time;
    }

    public static Time convert(Object object) throws DBException {
        if (null == object) {
            return null;
        }
        if (object instanceof Time) {
            return (Time)object;
        }
        if (object instanceof String) {
            Date date = TimeType.doParse((String)object);
            if (date == null) {
                throw new DBException(NbBundle.getMessage(TimeType.class, (String)"LBL_invalid_time"));
            }
            return TimeType.getNormalizedTime(date.getTime());
        }
        throw new DBException(NbBundle.getMessage(TimeType.class, (String)"LBL_invalid_time"));
    }

    private static synchronized Date doParse(String string) {
        Date date = null;
        for (DateFormat dateFormat : TIME_PARSING_FORMATS) {
            try {
                date = dateFormat.parse(string);
                break;
            }
            catch (ParseException parseException) {
                Logger.getLogger(TimeType.class.getName()).log(Level.FINEST, parseException.getLocalizedMessage(), parseException);
            }
        }
        return date;
    }
}

