/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.table;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.jdesktop.swingx.decorator.Filter;

public class SuperPatternFilter
extends Filter {
    private List<Integer> toPrevious;
    Pattern pattern;
    String filterStr = "";
    MODE mode;
    private static final String UNKOWN_MODE = "unknown mode";

    public SuperPatternFilter(int n) {
        super(n);
        this.setFilterStr(null, MODE.LITERAL_FIND);
    }

    public boolean isFilterSetTo(String string, MODE mODE) {
        return this.filterStr.equals(string) && this.mode == mODE;
    }

    public void setFilterStr(String string, MODE mODE) {
        if (string == null || this.filterStr.equals(string) && this.mode == mODE) {
            return;
        }
        this.filterStr = string;
        this.mode = mODE;
        switch (mODE) {
            case LITERAL_FIND: 
            case LITERAL_MATCH: {
                break;
            }
            case REGEX_FIND: 
            case REGEX_MATCH: {
                String string2 = string == null || string.length() == 0 ? ".*" : string;
                this.pattern = Pattern.compile(string2, 0);
                break;
            }
            default: {
                throw new RuntimeException(UNKOWN_MODE);
            }
        }
        this.refresh();
    }

    protected void reset() {
        this.toPrevious.clear();
        int n = this.getInputSize();
        this.fromPrevious = new int[n];
        for (int i = 0; i < n; ++i) {
            this.fromPrevious[i] = -1;
        }
    }

    protected void filter() {
        int n = this.getInputSize();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (!this.test(i)) continue;
            this.toPrevious.add(i);
            this.fromPrevious[i] = n2++;
        }
    }

    public boolean test(int n) {
        int n2 = this.getColumnIndex();
        if (!this.adapter.isTestable(n2)) {
            return false;
        }
        return this.testValue((String)this.getInputValue(n, n2));
    }

    boolean testValue(String string) {
        if (string == null) {
            return false;
        }
        switch (this.mode) {
            case LITERAL_FIND: {
                if (this.filterStr == null || this.filterStr.length() == 0) {
                    return true;
                }
                return string.toUpperCase().contains(this.filterStr.toUpperCase());
            }
            case LITERAL_MATCH: {
                if (this.filterStr == null || this.filterStr.length() == 0) {
                    return true;
                }
                return this.filterStr.equals(string);
            }
            case REGEX_FIND: {
                return this.pattern.matcher(string).find();
            }
            case REGEX_MATCH: {
                return this.pattern.matcher(string).matches();
            }
        }
        throw new RuntimeException(UNKOWN_MODE);
    }

    public int getSize() {
        return this.toPrevious.size();
    }

    protected int mapTowardModel(int n) {
        return this.toPrevious.get(n);
    }

    protected void init() {
        this.toPrevious = new ArrayList<Integer>();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MODE {
        LITERAL_FIND,
        REGEX_FIND,
        LITERAL_MATCH,
        REGEX_MATCH;

    }
}

