/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.output;

import java.sql.Connection;
import java.util.List;
import java.util.Map;
import javax.swing.table.TableModel;
import org.netbeans.modules.db.dataview.meta.DBColumn;
import org.netbeans.modules.db.dataview.meta.DBConnectionFactory;
import org.netbeans.modules.db.dataview.meta.DBException;
import org.netbeans.modules.db.dataview.meta.DBModel;
import org.netbeans.modules.db.dataview.meta.DBPrimaryKey;
import org.netbeans.modules.db.dataview.meta.DBTable;
import org.netbeans.modules.db.dataview.output.DataView;
import org.netbeans.modules.db.dataview.output.DataViewDBTable;
import org.netbeans.modules.db.dataview.output.SQLExecutionHelper;
import org.netbeans.modules.db.dataview.util.DataViewUtils;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SQLStatementGenerator {
    private DataViewDBTable tblMeta;
    private DataView dataView;

    public SQLStatementGenerator(DataView dataView) {
        this.dataView = dataView;
        this.tblMeta = dataView.getDataViewDBTable();
    }

    String generateInsertStatement(Object[] objectArray) throws DBException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("INSERT INTO ");
        String string = " (";
        String string2 = "";
        String string3 = ", ";
        boolean bl = false;
        for (int i = 0; i < objectArray.length; ++i) {
            DBColumn dBColumn = this.tblMeta.getColumn(i);
            Object object = objectArray[i];
            if (dBColumn.isGenerated()) continue;
            if ((object == null || object.equals("<NULL>")) && !dBColumn.isNullable()) {
                throw new DBException(NbBundle.getMessage(SQLStatementGenerator.class, (String)"MSG_nullable_check"));
            }
            if (bl) {
                string2 = string2 + string3;
                string = string + string3;
            } else {
                bl = true;
            }
            if (object != null && DataViewUtils.isSQLConstantString(object)) {
                String string4 = ((String)object).substring(1, ((String)object).length() - 1);
                string2 = string2 + string4;
            } else {
                string2 = string2 + (objectArray[i] == null ? " NULL " : "?");
            }
            string = string + dBColumn.getQualifiedName(true);
        }
        string = string + ")";
        stringBuilder.append(this.tblMeta.getFullyQualifiedName(0, true) + string + " Values(" + string2 + ")");
        return stringBuilder.toString();
    }

    String generateRawInsertStatement(Object[] objectArray) throws DBException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("INSERT INTO ");
        String string = " (";
        String string2 = "";
        String string3 = ", ";
        boolean bl = false;
        for (int i = 0; i < objectArray.length; ++i) {
            DBColumn dBColumn = this.tblMeta.getColumn(i);
            Object object = objectArray[i];
            if (dBColumn.isGenerated()) continue;
            if ((object == null || object.equals("<NULL>")) && !dBColumn.isNullable()) {
                throw new DBException(NbBundle.getMessage(SQLStatementGenerator.class, (String)"MSG_nullable_check"));
            }
            if (bl) {
                string2 = string2 + string3;
                string = string + string3;
            } else {
                bl = true;
            }
            if (object != null && DataViewUtils.isSQLConstantString(object)) {
                String string4 = ((String)object).substring(1, ((String)object).length() - 1);
                string2 = string2 + string4;
            } else {
                string2 = string2 + this.getQualifiedValue(dBColumn.getJdbcType(), objectArray[i]);
            }
            string = string + dBColumn.getQualifiedName(false);
        }
        string = string + ")";
        stringBuilder.append(this.tblMeta.getFullyQualifiedName(0, false) + string + " \n\tVALUES (" + string2 + ")");
        return stringBuilder.toString();
    }

    String generateUpdateStatement(int n, Map<Integer, Object> map, List<Object> list, List<Integer> list2, TableModel tableModel) throws DBException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("UPDATE ").append(this.tblMeta.getFullyQualifiedName(0, true)).append(" SET ");
        String string = ", ";
        boolean bl = false;
        for (Integer n2 : map.keySet()) {
            DBColumn dBColumn = this.tblMeta.getColumn(n2);
            Object object = map.get(n2);
            int n3 = dBColumn.getJdbcType();
            if ((object == null || object.equals("<NULL>")) && !dBColumn.isNullable()) {
                throw new DBException(NbBundle.getMessage(SQLStatementGenerator.class, (String)"MSG_nullable_check"));
            }
            if (bl) {
                stringBuilder.append(string);
            } else {
                bl = true;
            }
            stringBuilder.append(this.tblMeta.getQualifiedName(n2, true));
            if (object != null && DataViewUtils.isSQLConstantString(object)) {
                String string2 = ((String)object).substring(1, ((String)object).length() - 1);
                stringBuilder.append(" = ").append(string2);
                continue;
            }
            stringBuilder.append(" = ?");
            list.add(object);
            list2.add(n3);
        }
        stringBuilder.append(" WHERE ");
        this.generateWhereCondition(stringBuilder, list2, list, n, tableModel);
        return stringBuilder.toString();
    }

    String generateUpdateStatement(int n, Map<Integer, Object> map, TableModel tableModel) throws DBException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("UPDATE ").append(this.tblMeta.getFullyQualifiedName(0, false)).append(" SET ");
        String string = ", ";
        boolean bl = false;
        for (Integer n2 : map.keySet()) {
            DBColumn dBColumn = this.tblMeta.getColumn(n2);
            Object object = map.get(n2);
            int n3 = dBColumn.getJdbcType();
            if ((object == null || object.equals("<NULL>")) && !dBColumn.isNullable()) {
                throw new DBException(NbBundle.getMessage(SQLStatementGenerator.class, (String)"MSG_nullable_check"));
            }
            if (bl) {
                stringBuilder.append(string);
            } else {
                bl = true;
            }
            stringBuilder.append(this.tblMeta.getQualifiedName(n2, true));
            if (object != null && DataViewUtils.isSQLConstantString(object)) {
                String string2 = ((String)object).substring(1, ((String)object).length() - 1);
                stringBuilder.append(" = ").append(string2);
                continue;
            }
            stringBuilder.append(" = ").append(this.getQualifiedValue(n3, object).toString());
        }
        stringBuilder.append(" WHERE ");
        this.generateWhereCondition(stringBuilder, n, tableModel);
        return stringBuilder.toString();
    }

    String generateDeleteStatement(List<Integer> list, List<Object> list2, int n, TableModel tableModel) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DELETE FROM ").append(this.tblMeta.getFullyQualifiedName(0, true)).append(" WHERE ");
        this.generateWhereCondition(stringBuilder, list, list2, n, tableModel);
        return stringBuilder.toString();
    }

    String generateDeleteStatement(int n, TableModel tableModel) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DELETE FROM ").append(this.tblMeta.getFullyQualifiedName(0, false)).append(" WHERE ");
        this.generateWhereCondition(stringBuilder, n, tableModel);
        return stringBuilder.toString();
    }

    String generateCreateStatement(DBTable dBTable) throws DBException, Exception {
        Connection connection = DBConnectionFactory.getInstance().getConnection(this.dataView.getDatabaseConnection());
        String string = "";
        if (connection == null) {
            Throwable throwable = DBConnectionFactory.getInstance().getLastException();
            string = throwable != null ? throwable.getMessage() : NbBundle.getMessage(SQLExecutionHelper.class, (String)"MSG_connection_failure", (Object)this.dataView.getDatabaseConnection());
            this.dataView.setErrorStatusText(new DBException(string));
            throw new DBException(string);
        }
        boolean bl = ((DBModel)dBTable.getParentObject()).getDBType() == 0;
        StringBuffer stringBuffer = new StringBuffer();
        List<DBColumn> list = dBTable.getColumnList();
        stringBuffer.append("CREATE TABLE ").append(dBTable.getQualifiedName(false)).append(" (");
        int n = 0;
        for (DBColumn object : list) {
            if (n++ > 0) {
                stringBuffer.append(", ");
            }
            String string2 = object.getTypeName();
            stringBuffer.append(object.getQualifiedName(false)).append(" ");
            int n2 = object.getScale();
            int n3 = object.getPrecision();
            if (n3 > 0 && DataViewUtils.isPrecisionRequired(object.getJdbcType(), bl)) {
                if (string2.contains("(")) {
                    stringBuffer.append(string2.replace("(", "(" + n3));
                } else {
                    stringBuffer.append(string2).append("(").append(n3);
                    if (n2 > 0 && DataViewUtils.isScaleRequired(object.getJdbcType())) {
                        stringBuffer.append(", ").append(n2).append(")");
                    } else {
                        stringBuffer.append(")");
                    }
                }
            } else {
                stringBuffer.append(string2);
            }
            if (DataViewUtils.isBinary(object.getJdbcType()) && bl) {
                stringBuffer.append("  FOR BIT DATA ");
            }
            if (object.hasDefault()) {
                stringBuffer.append(" DEFAULT ").append(object.getDefaultValue()).append(" ");
            }
            if (!object.isNullable()) {
                stringBuffer.append(" NOT NULL");
            }
            if (!object.isGenerated()) continue;
            stringBuffer.append(" ").append(this.getAutoIncrementText(((DBModel)dBTable.getParentObject()).getDBType()));
        }
        DBPrimaryKey dBPrimaryKey = dBTable.getPrimaryKey();
        if (dBPrimaryKey != null) {
            n = 0;
            stringBuffer.append(", PRIMARY KEY (");
            for (String string2 : dBPrimaryKey.getColumnNames()) {
                if (n++ > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(dBTable.getQuoter().quoteIfNeeded(string2));
            }
            stringBuffer.append(")");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    static String getCountSQLQuery(String string) {
        String[] stringArray = string.toUpperCase().split("FROM");
        string = string.substring(stringArray[0].length());
        String[] stringArray2 = string.toUpperCase().split("ORDER BY");
        string = string.substring(0, stringArray2[0].length());
        return "SELECT COUNT(*) " + string;
    }

    static String getCountAsSubQuery(String string) {
        String[] stringArray = string.toUpperCase().split("ORDER BY");
        string = string.substring(0, stringArray[0].length());
        return "SELECT COUNT(*) FROM (" + string + ") C2668";
    }

    private boolean addSeparator(boolean bl, StringBuilder stringBuilder, String string) {
        if (bl) {
            stringBuilder.append(string);
            return true;
        }
        return true;
    }

    private void generateNameValue(int n, StringBuilder stringBuilder, Object object, List<Object> list, List<Integer> list2) {
        stringBuilder.append(this.tblMeta.getQualifiedName(n, true));
        if (object != null) {
            list.add(object);
            list2.add(this.tblMeta.getColumnType(n));
            stringBuilder.append(" = ? ");
        } else {
            stringBuilder.append(" IS NULL ");
        }
    }

    private void generateNameValue(int n, StringBuilder stringBuilder, Object object) {
        String string = this.tblMeta.getQualifiedName(n, false);
        int n2 = this.tblMeta.getColumnType(n);
        stringBuilder.append(string);
        if (object != null) {
            stringBuilder.append(" = ").append(this.getQualifiedValue(n2, object));
        } else {
            stringBuilder.append(" IS NULL");
        }
    }

    private void generateWhereCondition(StringBuilder stringBuilder, List<Integer> list, List<Object> list2, int n, TableModel tableModel) {
        DBPrimaryKey dBPrimaryKey = this.tblMeta.geTable(0).getPrimaryKey();
        boolean bl = false;
        boolean bl2 = false;
        if (dBPrimaryKey != null) {
            block0: for (String object : dBPrimaryKey.getColumnNames()) {
                for (int i = 0; i < tableModel.getColumnCount(); ++i) {
                    Object object2;
                    String string = this.tblMeta.getColumnName(i);
                    if (!string.equals(object) || (object2 = this.dataView.getDataViewPageContext().getColumnData(n, i)) == null) continue;
                    bl = true;
                    bl2 = this.addSeparator(bl2, stringBuilder, " AND ");
                    this.generateNameValue(i, stringBuilder, object2, list2, list);
                    continue block0;
                }
            }
        }
        if (dBPrimaryKey == null || !bl) {
            for (int i = 0; i < tableModel.getColumnCount(); ++i) {
                Object object = this.dataView.getDataViewPageContext().getColumnData(n, i);
                bl2 = this.addSeparator(bl2, stringBuilder, " AND ");
                this.generateNameValue(i, stringBuilder, object, list2, list);
            }
        }
    }

    private void generateWhereCondition(StringBuilder stringBuilder, int n, TableModel tableModel) {
        DBPrimaryKey dBPrimaryKey = this.tblMeta.geTable(0).getPrimaryKey();
        boolean bl = false;
        boolean bl2 = false;
        if (dBPrimaryKey != null) {
            block0: for (String object : dBPrimaryKey.getColumnNames()) {
                for (int i = 0; i < tableModel.getColumnCount(); ++i) {
                    Object object2;
                    String string = this.tblMeta.getColumnName(i);
                    if (!string.equals(object) || (object2 = this.dataView.getDataViewPageContext().getColumnData(n, i)) == null) continue;
                    bl = true;
                    bl2 = this.addSeparator(bl2, stringBuilder, " AND ");
                    this.generateNameValue(i, stringBuilder, object2);
                    continue block0;
                }
            }
        }
        if (dBPrimaryKey == null || !bl) {
            for (int i = 0; i < tableModel.getColumnCount(); ++i) {
                Object object = this.dataView.getDataViewPageContext().getColumnData(n, i);
                bl2 = this.addSeparator(bl2, stringBuilder, " AND ");
                this.generateNameValue(i, stringBuilder, object);
            }
        }
    }

    private Object getQualifiedValue(int n, Object object) {
        if (object == null) {
            return "NULL";
        }
        if (n == -7 && !(object instanceof Boolean)) {
            return "b'" + object + "'";
        }
        if (DataViewUtils.isNumeric(n)) {
            return object;
        }
        return "'" + object + "'";
    }

    private String getAutoIncrementText(int n) throws Exception {
        switch (n) {
            case 5: {
                return "AUTO_INCREMENT";
            }
            case 4: {
                return "SERIAL";
            }
            case 2: {
                return "IDENTITY";
            }
        }
        return "GENERATED ALWAYS AS IDENTITY";
    }
}

