/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf.codecoverage;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.settings.AttributesUtilities;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.gsf.codecoverage.CoverageManagerImpl;
import org.netbeans.modules.gsf.codecoverage.api.CoverageType;
import org.netbeans.modules.gsf.codecoverage.api.FileCoverageDetails;
import org.netbeans.spi.editor.highlighting.HighlightsSequence;
import org.netbeans.spi.editor.highlighting.support.AbstractHighlightsContainer;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoverageHighlightsContainer
extends AbstractHighlightsContainer
implements DocumentListener {
    private AttributeSet covered;
    private AttributeSet uncovered;
    private AttributeSet inferred;
    private AttributeSet partial;
    private List<Position> lastPositions;
    private List<CoverageType> lastTypes;
    private boolean enabled;
    private boolean listening;
    private final BaseDocument doc;
    private final String mimeType;
    private long version = 0L;
    private FileObject fileObject;
    private Project project;

    CoverageHighlightsContainer(Document document) {
        this.doc = document instanceof BaseDocument ? (BaseDocument)document : null;
        this.mimeType = (String)document.getProperty("mimeType");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HighlightsSequence getHighlights(int n, int n2) {
        this.enabled = false;
        CoverageManagerImpl coverageManagerImpl = CoverageManagerImpl.getInstance();
        if (this.doc == null || coverageManagerImpl == null || !coverageManagerImpl.isEnabled(this.mimeType)) {
            return HighlightsSequence.EMPTY;
        }
        this.enabled = true;
        Object object = this;
        synchronized (object) {
            if (this.fileObject == null) {
                this.fileObject = GsfUtilities.findFileObject((Document)this.doc);
                this.project = this.fileObject != null ? FileOwnerQuery.getOwner((FileObject)this.fileObject) : null;
                if (this.fileObject == null || this.project == null) {
                    return HighlightsSequence.EMPTY;
                }
            }
        }
        object = coverageManagerImpl.getDetails(this.project, this.fileObject, (Document)this.doc);
        if (object == null) {
            return HighlightsSequence.EMPTY;
        }
        this.initColors();
        if (!this.listening) {
            this.listening = true;
            this.doc.addDocumentListener(WeakListeners.document((DocumentListener)this, null));
        }
        return new Highlights(0L, n, n2, (FileCoverageDetails)object);
    }

    private static Color getColoring(FontColorSettings fontColorSettings, String string) {
        AttributeSet attributeSet = fontColorSettings.getTokenFontColors(string);
        if (attributeSet != null) {
            return (Color)attributeSet.getAttribute(StyleConstants.Background);
        }
        return null;
    }

    private void initColors() {
        if (this.covered != null) {
            return;
        }
        Color color = null;
        Color color2 = null;
        Color color3 = null;
        Color color4 = null;
        FontColorSettings fontColorSettings = (FontColorSettings)MimeLookup.getLookup((String)this.mimeType).lookup(FontColorSettings.class);
        if (fontColorSettings != null) {
            color = CoverageHighlightsContainer.getColoring(fontColorSettings, "covered");
            color2 = CoverageHighlightsContainer.getColoring(fontColorSettings, "uncovered");
            color3 = CoverageHighlightsContainer.getColoring(fontColorSettings, "inferred");
            color4 = CoverageHighlightsContainer.getColoring(fontColorSettings, "partial");
        }
        if (color == null) {
            color = new Color(204, 255, 204);
        }
        if (color2 == null) {
            color2 = new Color(255, 204, 204);
        }
        if (color3 == null) {
            color3 = new Color(224, 255, 224);
        }
        if (color4 == null) {
            color4 = new Color(255, 255, 224);
        }
        this.covered = color == null ? SimpleAttributeSet.EMPTY : AttributesUtilities.createImmutable((Object[])new Object[]{StyleConstants.Background, color, ATTR_EXTENDS_EOL, Boolean.TRUE, ATTR_EXTENDS_EMPTY_LINE, Boolean.TRUE});
        this.uncovered = color2 == null ? SimpleAttributeSet.EMPTY : AttributesUtilities.createImmutable((Object[])new Object[]{StyleConstants.Background, color2, ATTR_EXTENDS_EOL, Boolean.TRUE, ATTR_EXTENDS_EMPTY_LINE, Boolean.TRUE});
        this.inferred = color3 == null ? SimpleAttributeSet.EMPTY : AttributesUtilities.createImmutable((Object[])new Object[]{StyleConstants.Background, color3, ATTR_EXTENDS_EOL, Boolean.TRUE, ATTR_EXTENDS_EMPTY_LINE, Boolean.TRUE});
        this.partial = color4 == null ? SimpleAttributeSet.EMPTY : AttributesUtilities.createImmutable((Object[])new Object[]{StyleConstants.Background, color4, ATTR_EXTENDS_EOL, Boolean.TRUE, ATTR_EXTENDS_EMPTY_LINE, Boolean.TRUE});
    }

    void refresh() {
        this.lastPositions = null;
        this.lastTypes = null;
        this.fireHighlightsChange(0, this.doc.getLength());
    }

    private void handleEdits(int n, int n2, boolean bl) {
        try {
            int n3;
            List<Position> list;
            String string;
            assert (n2 > 0);
            if (bl && (string = this.doc.getText(n, n2)).trim().length() == 0 && (Utilities.isRowEmpty((BaseDocument)this.doc, (int)n) || n >= Utilities.getRowLastNonWhite((BaseDocument)this.doc, (int)n) + 1 || n <= Utilities.getRowFirstNonWhite((BaseDocument)this.doc, (int)n))) {
                this.fireHighlightsChange(n, n + n2);
                return;
            }
            int n4 = Utilities.getRowFirstNonWhite((BaseDocument)this.doc, (int)n);
            if (n4 == -1) {
                n4 = Utilities.getRowStart((BaseDocument)this.doc, (int)n);
            }
            if ((list = this.lastPositions) != null && (n3 = this.findPositionIndex(list, n4)) >= 0) {
                ArrayList<Position> arrayList = new ArrayList<Position>(list);
                arrayList.remove(n3);
                this.lastPositions = arrayList;
                this.fireHighlightsChange(n, n + n2);
            }
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        if (this.enabled) {
            this.handleEdits(documentEvent.getOffset(), documentEvent.getLength(), true);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    private int findPositionIndex(List<Position> list, final int n) {
        return Collections.binarySearch(list, new Position(){

            public int getOffset() {
                return n;
            }
        }, new Comparator<Position>(){

            @Override
            public int compare(Position position, Position position2) {
                return position.getOffset() - position2.getOffset();
            }
        });
    }

    private class Highlights
    implements HighlightsSequence {
        private final List<Position> positions;
        private final List<CoverageType> types;
        private final long version;
        private final int startOffsetBoundary;
        private final int endOffsetBoundary;
        private int startOffset;
        private int endOffset;
        private AttributeSet attributeSet;
        private boolean finished = false;
        private int index;

        private Highlights(long l, int n, int n2, FileCoverageDetails fileCoverageDetails) {
            int n3;
            this.version = l;
            this.startOffsetBoundary = n;
            this.endOffsetBoundary = n2;
            if (CoverageHighlightsContainer.this.lastPositions == null) {
                this.positions = new ArrayList<Position>();
                this.types = new ArrayList<CoverageType>();
                int n4 = fileCoverageDetails.getLineCount();
                for (n3 = 0; n3 < n4; ++n3) {
                    CoverageType coverageType = fileCoverageDetails.getType(n3);
                    if (coverageType != CoverageType.COVERED && coverageType != CoverageType.INFERRED && coverageType != CoverageType.NOT_COVERED && coverageType != CoverageType.PARTIAL) continue;
                    try {
                        int n5 = Utilities.getRowStartFromLineOffset((BaseDocument)CoverageHighlightsContainer.this.doc, (int)n3);
                        if (n5 == -1) continue;
                        int n6 = Utilities.getRowFirstNonWhite((BaseDocument)CoverageHighlightsContainer.this.doc, (int)n5);
                        if (n6 != -1) {
                            n5 = n6;
                        }
                        Position position = CoverageHighlightsContainer.this.doc.createPosition(n5, Position.Bias.Forward);
                        this.positions.add(position);
                        this.types.add(coverageType);
                        continue;
                    }
                    catch (BadLocationException badLocationException) {
                        Exceptions.printStackTrace((Throwable)badLocationException);
                    }
                }
                CoverageHighlightsContainer.this.lastPositions = this.positions;
                CoverageHighlightsContainer.this.lastTypes = this.types;
            } else {
                this.positions = CoverageHighlightsContainer.this.lastPositions;
                this.types = CoverageHighlightsContainer.this.lastTypes;
            }
            try {
                n3 = Utilities.getRowFirstNonWhite((BaseDocument)CoverageHighlightsContainer.this.doc, (int)this.startOffsetBoundary);
                if (n3 == -1) {
                    n3 = Utilities.getRowStart((BaseDocument)CoverageHighlightsContainer.this.doc, (int)this.startOffsetBoundary);
                    this.index = CoverageHighlightsContainer.this.findPositionIndex(this.positions, n3);
                    if (this.index < 0) {
                        this.index = -this.index;
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        private boolean _moveNext() {
            while (this.index < this.positions.size()) {
                Position position = this.positions.get(this.index);
                int n = position.getOffset();
                try {
                    n = Utilities.getRowStart((BaseDocument)CoverageHighlightsContainer.this.doc, (int)n);
                }
                catch (BadLocationException badLocationException) {
                    Exceptions.printStackTrace((Throwable)badLocationException);
                }
                if (n > this.endOffsetBoundary) break;
                if (n >= this.startOffsetBoundary) {
                    this.startOffset = n;
                    try {
                        this.endOffset = Utilities.getRowEnd((BaseDocument)CoverageHighlightsContainer.this.doc, (int)n);
                        if (this.endOffset < CoverageHighlightsContainer.this.doc.getLength()) {
                            ++this.endOffset;
                        }
                        CoverageType coverageType = this.types.get(this.index);
                        switch (coverageType) {
                            case COVERED: {
                                this.attributeSet = CoverageHighlightsContainer.this.covered;
                                break;
                            }
                            case NOT_COVERED: {
                                this.attributeSet = CoverageHighlightsContainer.this.uncovered;
                                break;
                            }
                            case INFERRED: {
                                this.attributeSet = CoverageHighlightsContainer.this.inferred;
                                break;
                            }
                            case PARTIAL: {
                                this.attributeSet = CoverageHighlightsContainer.this.partial;
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException();
                            }
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        Exceptions.printStackTrace((Throwable)badLocationException);
                    }
                    ++this.index;
                    return true;
                }
                ++this.index;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean moveNext() {
            CoverageHighlightsContainer coverageHighlightsContainer = CoverageHighlightsContainer.this;
            synchronized (coverageHighlightsContainer) {
                if (this.checkVersion() && this._moveNext()) {
                    return true;
                }
            }
            this.finished = true;
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getStartOffset() {
            CoverageHighlightsContainer coverageHighlightsContainer = CoverageHighlightsContainer.this;
            synchronized (coverageHighlightsContainer) {
                if (this.finished) {
                    throw new NoSuchElementException();
                }
                return this.startOffset;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getEndOffset() {
            CoverageHighlightsContainer coverageHighlightsContainer = CoverageHighlightsContainer.this;
            synchronized (coverageHighlightsContainer) {
                if (this.finished) {
                    throw new NoSuchElementException();
                }
                return this.endOffset;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AttributeSet getAttributes() {
            CoverageHighlightsContainer coverageHighlightsContainer = CoverageHighlightsContainer.this;
            synchronized (coverageHighlightsContainer) {
                if (this.finished) {
                    throw new NoSuchElementException();
                }
                return this.attributeSet;
            }
        }

        private boolean checkVersion() {
            return this.version == CoverageHighlightsContainer.this.version;
        }
    }
}

