/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.codegen;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.maven.codegen.NewMirrorPanel;
import org.netbeans.modules.maven.model.settings.Mirror;
import org.netbeans.modules.maven.model.settings.SettingsModel;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.spi.editor.codegen.CodeGenerator;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.w3c.dom.Node;

public class MirrorGenerator
implements CodeGenerator {
    private SettingsModel model;
    private JTextComponent component;

    private MirrorGenerator(SettingsModel settingsModel, JTextComponent jTextComponent) {
        this.model = settingsModel;
        this.component = jTextComponent;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(MirrorGenerator.class, (String)"NAME_Mirror");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke() {
        try {
            this.model.sync();
        }
        catch (IOException iOException) {
            Logger.getLogger(MirrorGenerator.class.getName()).log(Level.INFO, "Error while syncing the editor document with model for pom.xml file", iOException);
        }
        if (!this.model.getState().equals((Object)Model.State.VALID)) {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(MirrorGenerator.class, (String)"MSG_Cannot_Parse"));
            return;
        }
        NewMirrorPanel newMirrorPanel = new NewMirrorPanel(this.model);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)newMirrorPanel, NbBundle.getMessage(MirrorGenerator.class, (String)"TIT_Add_mirror"));
        newMirrorPanel.attachDialogDisplayer(dialogDescriptor);
        Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
        if (object == DialogDescriptor.OK_OPTION) {
            String string = newMirrorPanel.getMirrorId();
            Mirror mirror = this.model.getSettings().findMirrorById(string);
            if (mirror == null) {
                try {
                    this.model.startTransaction();
                    mirror = this.model.getFactory().createMirror();
                    mirror.setId(string);
                    mirror.setUrl(newMirrorPanel.getMirrorUrl());
                    mirror.setMirrorOf(newMirrorPanel.getMirrorOf());
                    this.model.getSettings().addMirror(mirror);
                }
                finally {
                    this.model.endTransaction();
                }
                int n = mirror.getModel().getAccess().findPosition((Node)mirror.getPeer());
                this.component.setCaretPosition(n);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    implements CodeGenerator.Factory {
        public List<? extends CodeGenerator> create(Lookup lookup) {
            ArrayList<MirrorGenerator> arrayList = new ArrayList<MirrorGenerator>();
            SettingsModel settingsModel = (SettingsModel)lookup.lookup(SettingsModel.class);
            JTextComponent jTextComponent = (JTextComponent)lookup.lookup(JTextComponent.class);
            if (settingsModel != null) {
                arrayList.add(new MirrorGenerator(settingsModel, jTextComponent));
            }
            return arrayList;
        }
    }
}

