/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.api.phpmodule;

import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExecutionService;
import org.netbeans.api.extexecution.ExternalProcessBuilder;
import org.netbeans.api.extexecution.input.InputProcessor;
import org.netbeans.api.extexecution.input.InputProcessors;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PhpProgram {
    private static final ExecutionDescriptor DEFAULT_DESCRIPTOR = new ExecutionDescriptor().controllable(true).frontWindow(true).inputVisible(true).showProgress(true);
    public static final ExecutionDescriptor.InputProcessorFactory ANSI_STRIPPING_FACTORY = new ExecutionDescriptor.InputProcessorFactory(){

        public InputProcessor newInputProcessor(InputProcessor inputProcessor) {
            return InputProcessors.ansiStripping((InputProcessor)inputProcessor);
        }
    };
    protected static final Logger LOGGER = Logger.getLogger(PhpProgram.class.getName());
    private static final String[] NO_PARAMETERS = new String[0];
    private final String program;
    private final String[] parameters;
    private final String fullCommand;

    public PhpProgram(String string) {
        if (string == null) {
            string = "";
        }
        String[] stringArray = string.split(" * (?=\\-|/)", 2);
        switch (stringArray.length) {
            case 1: {
                LOGGER.fine("Only program given (no parameters)");
                this.program = stringArray[0].trim();
                this.parameters = NO_PARAMETERS;
                this.fullCommand = this.program;
                break;
            }
            default: {
                assert (stringArray.length > 1);
                this.program = stringArray[0].trim();
                this.parameters = Utilities.parseParameters((String)stringArray[1].trim());
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine(String.format("Parameters parsed: %s => %s", stringArray[1].trim(), Arrays.asList(this.parameters)));
                }
                this.fullCommand = string.trim();
            }
        }
    }

    public final String getProgram() {
        return this.program;
    }

    public final String[] getParameters() {
        return (String[])this.parameters.clone();
    }

    public final String getFullCommand() {
        return this.fullCommand;
    }

    public final boolean isValid() {
        return this.validate() == null;
    }

    public abstract String validate();

    public ExternalProcessBuilder getProcessBuilder() {
        ExternalProcessBuilder externalProcessBuilder = new ExternalProcessBuilder(this.program);
        for (String string : this.parameters) {
            externalProcessBuilder = externalProcessBuilder.addArgument(string);
        }
        return externalProcessBuilder;
    }

    public static ExecutionDescriptor getExecutionDescriptor() {
        return DEFAULT_DESCRIPTOR;
    }

    public static Future<Integer> executeLater(ExternalProcessBuilder externalProcessBuilder, ExecutionDescriptor executionDescriptor, String string) {
        return ExecutionService.newService((Callable)externalProcessBuilder, (ExecutionDescriptor)executionDescriptor, (String)string).run();
    }

    public static int executeAndWait(ExternalProcessBuilder externalProcessBuilder, ExecutionDescriptor executionDescriptor, String string) throws ExecutionException, InterruptedException {
        return (Integer)ExecutionService.newService((Callable)externalProcessBuilder, (ExecutionDescriptor)executionDescriptor, (String)string).run().get();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append(" [program: ");
        stringBuilder.append(this.program);
        stringBuilder.append(", parameters: ");
        stringBuilder.append(Arrays.asList(this.parameters));
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static final class InvalidPhpProgramException
    extends Exception {
        private static final long serialVersionUID = -831989756418354L;

        public InvalidPhpProgramException(String string) {
            super(string);
        }
    }
}

