/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.api;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmField;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmMethod;
import org.netbeans.modules.cnd.api.model.CsmVisibility;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.openide.util.lookup.Lookups;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EncapsulateFieldRefactoring
extends AbstractRefactoring {
    private String getterName;
    private CsmMethod defaultGetter;
    private String setterName;
    private CsmMethod defaultSetter;
    private Set<CsmVisibility> methodModifiers;
    private Set<CsmVisibility> fieldModifiers;
    private boolean alwaysUseAccessors;
    private boolean methodInline;
    private final CsmFile declFile;
    private final CsmFile defFile;
    private final CsmClass enclosingClass;

    public EncapsulateFieldRefactoring(CsmField csmField, CsmFile csmFile, CsmFile csmFile2) {
        super(Lookups.fixed((Object[])new Object[]{csmField}));
        this.enclosingClass = csmField.getContainingClass();
        this.declFile = csmFile;
        this.defFile = csmFile2;
    }

    public CsmField getSourceField() {
        return (CsmField)this.getRefactoringSource().lookup(CsmField.class);
    }

    public CsmClass getEnclosingClass() {
        return this.enclosingClass;
    }

    public CsmFile getClassDeclarationFile() {
        return this.declFile;
    }

    public CsmFile getClassDefinitionFile() {
        return this.defFile;
    }

    public String getGetterName() {
        return this.getterName;
    }

    public String getSetterName() {
        return this.setterName;
    }

    public Set<CsmVisibility> getMethodModifiers() {
        return this.methodModifiers;
    }

    public Set<CsmVisibility> getFieldModifiers() {
        return this.fieldModifiers;
    }

    public boolean isAlwaysUseAccessors() {
        return this.alwaysUseAccessors;
    }

    public boolean isMethodInline() {
        return this.methodInline;
    }

    public CsmMethod getDefaultGetter() {
        return this.defaultGetter;
    }

    public CsmMethod getDefaultSetter() {
        return this.defaultSetter;
    }

    public void setDefaultGetter(CsmMethod csmMethod) {
        this.defaultGetter = csmMethod;
    }

    public void setDefaultSetter(CsmMethod csmMethod) {
        this.defaultSetter = csmMethod;
    }

    public void setGetterName(String string) {
        this.getterName = string;
    }

    public void setSetterName(String string) {
        this.setterName = string;
    }

    public void setMethodModifiers(Set<CsmVisibility> set) {
        this.methodModifiers = Collections.unmodifiableSet(new HashSet<CsmVisibility>(set));
    }

    public void setFieldModifiers(Set<CsmVisibility> set) {
        this.fieldModifiers = Collections.unmodifiableSet(new HashSet<CsmVisibility>(set));
    }

    public void setAlwaysUseAccessors(boolean bl) {
        this.alwaysUseAccessors = bl;
    }

    public void setMethodInline(boolean bl) {
        this.methodInline = bl;
    }
}

