/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.lexer;

import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.modules.ruby.lexer.RubyCommentTokenId;
import org.netbeans.modules.ruby.lexer.RubyLexer;
import org.netbeans.modules.ruby.lexer.RubyStringTokenId;
import org.netbeans.spi.lexer.LanguageEmbedding;
import org.netbeans.spi.lexer.LanguageHierarchy;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerRestartInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum RubyTokenId implements TokenId
{
    ERROR(null, "error"),
    IDENTIFIER(null, "identifier"),
    CLASS_VAR(null, "staticfield"),
    INSTANCE_VAR(null, "field"),
    GLOBAL_VAR(null, "static"),
    CONSTANT(null, "constant"),
    DOCUMENTATION(null, "comment"),
    ABSTRACT("abstract", "keyword"),
    INT_LITERAL(null, "number"),
    REGEXP_LITERAL(null, "regexp"),
    FLOAT_LITERAL(null, "number"),
    STRING_LITERAL(null, "string"),
    WHITESPACE(null, "whitespace"),
    LINE_COMMENT(null, "comment"),
    BLOCK_COMMENT(null, "comment"),
    TYPE_SYMBOL(null, "typesymbol"),
    LPAREN("(", "separator"),
    RPAREN(")", "separator"),
    LBRACE("{", "separator"),
    RBRACE("}", "separator"),
    LBRACKET("[", "separator"),
    RBRACKET("]", "separator"),
    STRING_BEGIN(null, "string"),
    STRING_END(null, "string"),
    REGEXP_BEGIN(null, "regexp"),
    REGEXP_END(null, "regexp"),
    ANY_KEYWORD(null, "keyword"),
    ANY_OPERATOR(null, "operator"),
    DOT(null, "operator"),
    RANGE(null, "operator"),
    COLON3(null, "operator"),
    SUPER(null, "keyword"),
    SELF(null, "keyword"),
    QUOTED_STRING_LITERAL(null, "string"),
    QUOTED_STRING_BEGIN(null, "string"),
    QUOTED_STRING_END(null, "string"),
    EMBEDDED_RUBY(null, "default"),
    MODULE(null, "keyword"),
    CLASS(null, "keyword"),
    DEF(null, "keyword"),
    END(null, "keyword"),
    BEGIN(null, "keyword"),
    FOR(null, "keyword"),
    CASE(null, "keyword"),
    LOOP(null, "keyword"),
    DO(null, "keyword"),
    IF(null, "keyword"),
    WHILE(null, "keyword"),
    UNTIL(null, "keyword"),
    UNLESS(null, "keyword"),
    ELSE(null, "keyword"),
    ELSIF(null, "keyword"),
    ENSURE(null, "keyword"),
    WHEN(null, "keyword"),
    RESCUE(null, "keyword"),
    NONUNARY_OP(null, "operator");

    private final String fixedText;
    private final String primaryCategory;
    private static final Language<RubyTokenId> language;

    private RubyTokenId(String string2, String string3) {
        this.fixedText = string2;
        this.primaryCategory = string3;
    }

    public String fixedText() {
        return this.fixedText;
    }

    public String primaryCategory() {
        return this.primaryCategory;
    }

    public static Language<RubyTokenId> language() {
        return language;
    }

    static {
        language = new LanguageHierarchy<RubyTokenId>(){

            protected String mimeType() {
                return "text/x-ruby";
            }

            protected Collection<RubyTokenId> createTokenIds() {
                return EnumSet.allOf(RubyTokenId.class);
            }

            protected Map<String, Collection<RubyTokenId>> createTokenCategories() {
                HashMap<String, Collection<RubyTokenId>> hashMap = new HashMap<String, Collection<RubyTokenId>>();
                return hashMap;
            }

            protected Lexer<RubyTokenId> createLexer(LexerRestartInfo<RubyTokenId> lexerRestartInfo) {
                return RubyLexer.create(lexerRestartInfo);
            }

            protected LanguageEmbedding<?> embedding(Token<RubyTokenId> token, LanguagePath languagePath, InputAttributes inputAttributes) {
                RubyTokenId rubyTokenId = (RubyTokenId)token.id();
                if (rubyTokenId == QUOTED_STRING_LITERAL) {
                    return LanguageEmbedding.create(RubyStringTokenId.languageDouble(), (int)0, (int)0);
                }
                if (rubyTokenId == STRING_LITERAL) {
                    return LanguageEmbedding.create(RubyStringTokenId.languageSingle(), (int)0, (int)0);
                }
                if (rubyTokenId == LINE_COMMENT || rubyTokenId == BLOCK_COMMENT) {
                    return LanguageEmbedding.create(RubyCommentTokenId.language(), (int)1, (int)0);
                }
                if (rubyTokenId == DOCUMENTATION) {
                    return LanguageEmbedding.create(RubyCommentTokenId.language(), (int)0, (int)0);
                }
                if (rubyTokenId == EMBEDDED_RUBY) {
                    return LanguageEmbedding.create(RubyTokenId.language(), (int)0, (int)0);
                }
                return null;
            }
        }.language();
    }
}

