/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.lexer;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.ruby.RubyPredefinedVariable;
import org.netbeans.modules.ruby.RubyType;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.lexer.LexUtilities;
import org.netbeans.modules.ruby.lexer.RubyTokenId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Call {
    private static final Pattern CALL_TO_NEW = Pattern.compile(".+(\\.new(\\z|\\(.*\\)))");
    private static final Pattern CALL_TO_NEW_IN_CHAIN = Pattern.compile(".+(\\.new(\\z|\\(.*\\)\\.?\\w*|\\.\\w?.*))");
    public static final Call LOCAL = new Call(RubyType.createUnknown(), null, false, false);
    public static final Call NONE = new Call(RubyType.createUnknown(), null, false, false);
    public static final Call UNKNOWN = new Call(RubyType.createUnknown(), null, false, false);
    private final RubyType type;
    private final String lhs;
    private final boolean isStatic;
    private final boolean methodExpected;
    private final boolean constantExpected;
    private boolean isLHSConstant;
    private static final String EMPTY_LHS = "EMPTY_LHS";

    private Call(RubyType rubyType, String string, boolean bl, boolean bl2) {
        this(rubyType, string, bl, bl2, false);
    }

    private Call(RubyType rubyType, String string, boolean bl, boolean bl2, boolean bl3) {
        this.type = rubyType;
        this.lhs = string;
        this.methodExpected = bl2;
        if (string == null && rubyType.isKnown()) {
            assert (rubyType.isSingleton()) : "should be singleton, was: " + rubyType;
            string = rubyType.first();
        }
        this.isStatic = bl;
        this.constantExpected = bl3;
    }

    private void setLHSConstant(boolean bl) {
        this.isLHSConstant = bl;
    }

    public RubyType getType() {
        return this.type;
    }

    public String getLhs() {
        if (EMPTY_LHS.equals(this.lhs)) {
            return "";
        }
        return this.lhs;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public boolean isLHSConstant() {
        return this.isLHSConstant;
    }

    public boolean isSimpleIdentifier() {
        if (this.lhs == null || this.lhs.equals(EMPTY_LHS)) {
            return false;
        }
        int n = this.lhs.length();
        for (int i = 0; i < n; ++i) {
            char c = this.lhs.charAt(i);
            if (Character.isJavaIdentifierPart(c) || c == '@' || c == '$') continue;
            return false;
        }
        return true;
    }

    public boolean isConstantExpected() {
        return this.constantExpected;
    }

    public boolean isMethodExpected() {
        return this.methodExpected;
    }

    public String toString() {
        if (this == LOCAL) {
            return "LOCAL";
        }
        if (this == NONE) {
            return "NONE";
        }
        if (this == UNKNOWN) {
            return "UNKNOWN";
        }
        return "Call(type: " + this.type + ", lhs: " + this.lhs + ", isStatic: " + this.isStatic + ", isLHSConstant: " + this.isLHSConstant + ')';
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NonNull
    public static Call getCallType(BaseDocument baseDocument, TokenHierarchy<Document> tokenHierarchy, int n) {
        Object object;
        String string;
        int n2;
        String string2;
        Token token;
        TokenSequence tokenSequence = LexUtilities.getRubyTokenSequence(tokenHierarchy, n);
        if (tokenSequence == null) {
            return NONE;
        }
        tokenSequence.move(n);
        boolean bl = false;
        boolean bl2 = false;
        if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
            return NONE;
        }
        if (tokenSequence.offset() == n) {
            tokenSequence.movePrevious();
        }
        if ((token = tokenSequence.token()) == null) return LOCAL;
        TokenId tokenId = token.id();
        if (tokenId == RubyTokenId.WHITESPACE) {
            return LOCAL;
        }
        if (tokenId == RubyTokenId.EMBEDDED_RUBY) {
            tokenSequence = tokenSequence.embedded();
            assert (tokenSequence != null);
            tokenSequence.move(n);
            if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
                return NONE;
            }
            token = tokenSequence.token();
            tokenId = token.id();
        }
        if (tokenId == RubyTokenId.IDENTIFIER || tokenId == RubyTokenId.CONSTANT || tokenId.primaryCategory().equals("keyword")) {
            string2 = ((Object)token.text()).toString();
            if (".".equals(string2)) {
                bl = true;
            } else if (!"::".equals(string2)) {
                bl = true;
                if (Character.isUpperCase(string2.charAt(0))) {
                    bl = false;
                }
                if (!tokenSequence.movePrevious()) {
                    return LOCAL;
                }
            }
            token = tokenSequence.token();
            tokenId = token.id();
        }
        if (tokenId == RubyTokenId.DOT) {
            bl = true;
        } else if (tokenId != RubyTokenId.COLON3) {
            if (tokenId != RubyTokenId.IDENTIFIER) return LOCAL;
            string2 = ((Object)token.text()).toString();
            if (string2.equals(".")) {
                bl = true;
            } else {
                if (!string2.equals("::")) return LOCAL;
                bl2 = true;
            }
        }
        int n3 = n2 = tokenSequence.offset();
        int n4 = 0;
        try {
            if (n > baseDocument.getLength()) {
                n = baseDocument.getLength();
            }
            n4 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        boolean bl3 = false;
        int n5 = 0;
        while (tokenSequence.movePrevious() && tokenSequence.offset() >= n4) {
            token = tokenSequence.token();
            tokenId = token.id();
            if (tokenId == RubyTokenId.LPAREN) {
                if (n5 <= 0) break;
                --n5;
                continue;
            }
            if (tokenId == RubyTokenId.RPAREN) {
                ++n5;
                continue;
            }
            if (n5 > 0) continue;
            string = null;
            if (tokenId == RubyTokenId.ANY_KEYWORD) {
                string = ((Object)token.text()).toString();
            }
            if (tokenId == RubyTokenId.WHITESPACE) break;
            if (!bl3 && (object = Call.tryLiteral(tokenId, bl, string)) != null) {
                return object;
            }
            if (tokenId == RubyTokenId.GLOBAL_VAR || tokenId == RubyTokenId.INSTANCE_VAR || tokenId == RubyTokenId.CLASS_VAR || tokenId == RubyTokenId.IDENTIFIER || tokenId.primaryCategory().equals("keyword") || tokenId == RubyTokenId.DOT || tokenId == RubyTokenId.COLON3 || tokenId == RubyTokenId.CONSTANT || tokenId == RubyTokenId.SUPER || tokenId == RubyTokenId.SELF || Call.isLiteral(tokenId)) {
                n3 = tokenSequence.offset();
                if (tokenId != RubyTokenId.DOT) continue;
                bl3 = true;
                continue;
            }
            if (tokenId == RubyTokenId.LBRACE || tokenId == RubyTokenId.LBRACKET) break;
            return UNKNOWN;
        }
        if (n3 >= n2) return UNKNOWN;
        try {
            string = baseDocument.getText(n3, n2 - n3);
            if (string.equals("super") || string.equals("self")) {
                return new Call(RubyType.create(string), string, false, true);
            }
            if (Character.isUpperCase(string.charAt(0))) {
                Object object2;
                int n6 = Call.isCallToNew(string);
                if (n6 != -1 && RubyUtils.isValidConstantFQN((String)(object2 = string.substring(0, string.length() - n6)))) {
                    return new Call(RubyType.create((String)object2), string, false, bl);
                }
                object2 = RubyPredefinedVariable.getType(string);
                boolean bl4 = object2 == null && !Call.containsCallToNew(string) && !Call.isChainedCall(string) || bl2;
                boolean bl5 = RubyUtils.isValidConstantFQN(string);
                if (object2 == null && bl5) {
                    object2 = RubyType.create(string);
                }
                Object object3 = object2 == null ? RubyType.createUnknown() : object2;
                Call call = new Call((RubyType)object3, string, bl4, bl, bl2);
                call.setLHSConstant(bl5);
                return call;
            }
            object = RubyPredefinedVariable.getType(string);
            RubyType rubyType = object == null ? RubyType.createUnknown() : object;
            return new Call(rubyType, string, false, bl, bl2);
        }
        catch (BadLocationException badLocationException) {
            return LOCAL;
        }
    }

    private static int isCallToNew(String string) {
        Matcher matcher = CALL_TO_NEW.matcher(string);
        if (!matcher.matches()) {
            return -1;
        }
        return matcher.group(1).length();
    }

    private static boolean containsCallToNew(String string) {
        return CALL_TO_NEW_IN_CHAIN.matcher(string).matches();
    }

    private static boolean isChainedCall(String string) {
        return string.indexOf(46) > 0;
    }

    private static Call tryLiteral(TokenId tokenId, boolean bl, String string) {
        if (tokenId == RubyTokenId.RBRACKET) {
            return new Call(RubyType.ARRAY, EMPTY_LHS, false, bl);
        }
        if (tokenId == RubyTokenId.RBRACE) {
            return new Call(RubyType.HASH, EMPTY_LHS, false, bl);
        }
        if (tokenId == RubyTokenId.STRING_END || tokenId == RubyTokenId.QUOTED_STRING_END) {
            return new Call(RubyType.STRING, EMPTY_LHS, false, bl);
        }
        if (tokenId == RubyTokenId.REGEXP_END) {
            return new Call(RubyType.REGEXP, EMPTY_LHS, false, bl);
        }
        if (tokenId == RubyTokenId.INT_LITERAL) {
            return new Call(RubyType.FIXNUM, EMPTY_LHS, false, bl);
        }
        if (tokenId == RubyTokenId.FLOAT_LITERAL) {
            return new Call(RubyType.FLOAT, EMPTY_LHS, false, bl);
        }
        if (tokenId == RubyTokenId.TYPE_SYMBOL) {
            return new Call(RubyType.SYMBOL, EMPTY_LHS, false, bl);
        }
        if (tokenId == RubyTokenId.RANGE) {
            return new Call(RubyType.RANGE, EMPTY_LHS, false, bl);
        }
        if (tokenId == RubyTokenId.ANY_KEYWORD && "nil".equals(string)) {
            return new Call(RubyType.NIL_CLASS, EMPTY_LHS, false, bl);
        }
        if (tokenId == RubyTokenId.ANY_KEYWORD && "true".equals(string)) {
            return new Call(RubyType.TRUE_CLASS, EMPTY_LHS, false, bl);
        }
        if (tokenId == RubyTokenId.ANY_KEYWORD && "false".equals(string)) {
            return new Call(RubyType.FALSE_CLASS, EMPTY_LHS, false, bl);
        }
        return null;
    }

    private static boolean isLiteral(TokenId tokenId) {
        return tokenId == RubyTokenId.RBRACKET || tokenId == RubyTokenId.RBRACE || tokenId == RubyTokenId.STRING_END || tokenId == RubyTokenId.REGEXP_END || tokenId == RubyTokenId.INT_LITERAL || tokenId == RubyTokenId.FLOAT_LITERAL || tokenId == RubyTokenId.TYPE_SYMBOL || tokenId == RubyTokenId.RANGE || tokenId == RubyTokenId.ANY_KEYWORD || tokenId == RubyTokenId.ANY_KEYWORD || tokenId == RubyTokenId.ANY_KEYWORD;
    }
}

