/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.ruby.RubyType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RubyPredefinedVariable {
    private final String name;
    private final String description;
    private final RubyType type;
    private static final List<RubyPredefinedVariable> VARIABLES = RubyPredefinedVariable.initialize();
    private static final List<RubyPredefinedVariable> CLASS_VARIABLES = RubyPredefinedVariable.initializeClassVars();

    private RubyPredefinedVariable(String string, String string2, RubyType rubyType) {
        this.name = string;
        this.description = string2;
        this.type = rubyType;
    }

    private static List<RubyPredefinedVariable> initialize() {
        ArrayList<RubyPredefinedVariable> arrayList = new ArrayList<RubyPredefinedVariable>();
        arrayList.add(RubyPredefinedVariable.create("$!", "The exception information message set by 'raise'.", RubyType.STRING));
        arrayList.add(RubyPredefinedVariable.create("$@", "Array of backtrace of the last exception thrown.", RubyType.ARRAY));
        arrayList.add(RubyPredefinedVariable.create("$&", "The string matched by the last successful pattern match in this scope.", RubyType.STRING));
        arrayList.add(RubyPredefinedVariable.create("$`", "The string to the left  of the last successful match.", RubyType.STRING));
        arrayList.add(RubyPredefinedVariable.create("$'", "The string to the right of the last successful match.", RubyType.STRING));
        arrayList.add(RubyPredefinedVariable.create("$+", "The last bracket matched by the last successful match.", RubyType.STRING));
        arrayList.add(RubyPredefinedVariable.create("$n", "The Nth group of the last successful regexp match.", RubyType.STRING));
        arrayList.add(RubyPredefinedVariable.create("$~", "The information about the last match in the current scope.", RubyType.STRING));
        arrayList.add(RubyPredefinedVariable.create("$=", "The flag for case insensitive, nil by default.", RubyType.BOOLEAN));
        arrayList.add(RubyPredefinedVariable.create("$/", "The input record separator, newline by default.", RubyType.STRING));
        arrayList.add(RubyPredefinedVariable.create("$\\", "The output record separator for the print and IO#write. Default is nil.", RubyType.STRING));
        arrayList.add(RubyPredefinedVariable.create("$,", "The output field separator for the print and Array#join.", RubyType.STRING));
        arrayList.add(RubyPredefinedVariable.create("$;", "The default separator for String#split.", RubyType.STRING));
        arrayList.add(RubyPredefinedVariable.create("$.", "The current input line number of the last file that was read.", RubyType.STRING));
        arrayList.add(RubyPredefinedVariable.create("$<", "The virtual concatenation file of the files given on command line.", RubyType.STRING));
        arrayList.add(RubyPredefinedVariable.create("$>", "The default output for print, printf. $stdout by default.", "IO"));
        arrayList.add(RubyPredefinedVariable.create("$_", "The last input line of string by gets or readline.", RubyType.STRING));
        arrayList.add(RubyPredefinedVariable.create("$0", "Contains the name of the script being executed. May be assignable.", RubyType.STRING));
        arrayList.add(RubyPredefinedVariable.create("$*", "Command line arguments given for the script sans args.", RubyType.ARRAY));
        arrayList.add(RubyPredefinedVariable.create("$$", "The process number of the Ruby running this script.", RubyType.FIXNUM));
        arrayList.add(RubyPredefinedVariable.create("$?", "The status of the last executed child process.", RubyType.STRING));
        arrayList.add(RubyPredefinedVariable.create("$:", "Load path for scripts and binary modules by load or require.", RubyType.ARRAY));
        arrayList.add(RubyPredefinedVariable.create("$\"", "The array contains the module names loaded by require.", RubyType.ARRAY));
        arrayList.add(RubyPredefinedVariable.create("$DEBUG", "The status of the -d switch.", RubyType.BOOLEAN));
        arrayList.add(RubyPredefinedVariable.create("$FILENAME", "Current input file from $&lt;. Same as $&lt;.filename.", RubyType.STRING));
        arrayList.add(RubyPredefinedVariable.create("$LOAD_PATH", "The alias to the $:.", RubyType.ARRAY));
        arrayList.add(RubyPredefinedVariable.create("$stderr", "The current standard error output.", "IO"));
        arrayList.add(RubyPredefinedVariable.create("$stdin", "The current standard input.", "IO"));
        arrayList.add(RubyPredefinedVariable.create("$stdout", "The current standard output.", "IO"));
        arrayList.add(RubyPredefinedVariable.create("$VERBOSE", "The verbose flag, which is set by the -v switch.", RubyType.BOOLEAN));
        arrayList.add(RubyPredefinedVariable.create("$-0", "The alias to $/.", RubyType.STRING));
        arrayList.add(RubyPredefinedVariable.create("$-a", "True if option -a (\"autosplit\" mode) is set. Read-only variable.", RubyType.BOOLEAN));
        arrayList.add(RubyPredefinedVariable.create("$-d", "The alias to $DEBUG.", RubyType.BOOLEAN));
        arrayList.add(RubyPredefinedVariable.create("$-F", "The alias to $;.", RubyType.STRING));
        arrayList.add(RubyPredefinedVariable.create("$-i", "If in-place-edit mode is set, this variable holds the extension, otherwise nil.", RubyType.STRING));
        arrayList.add(RubyPredefinedVariable.create("$-I", "The alias to $:.", RubyType.ARRAY));
        arrayList.add(RubyPredefinedVariable.create("$-l", "True if option -l is set (\"line-ending processing\" is on). Read-only variable.", RubyType.BOOLEAN));
        arrayList.add(RubyPredefinedVariable.create("$-p", "True if option -p is set (\"loop\" mode is on). Read-only variable.", RubyType.BOOLEAN));
        arrayList.add(RubyPredefinedVariable.create("$-v", "The alias to $VERBOSE.", RubyType.BOOLEAN));
        arrayList.add(RubyPredefinedVariable.create("$-w", "True if option -w is set.", RubyType.BOOLEAN));
        return arrayList;
    }

    private static List<RubyPredefinedVariable> initializeClassVars() {
        ArrayList<RubyPredefinedVariable> arrayList = new ArrayList<RubyPredefinedVariable>();
        arrayList.add(RubyPredefinedVariable.create("__FILE__", RubyType.STRING));
        arrayList.add(RubyPredefinedVariable.create("__LINE__", RubyType.FIXNUM));
        arrayList.add(RubyPredefinedVariable.create("ARGF", "Object"));
        arrayList.add(RubyPredefinedVariable.create("ARGV", RubyType.ARRAY));
        arrayList.add(RubyPredefinedVariable.create("DATA", "File"));
        arrayList.add(RubyPredefinedVariable.create("DATA", "IO"));
        arrayList.add(RubyPredefinedVariable.create("ENV", RubyType.OBJECT));
        arrayList.add(RubyPredefinedVariable.create("FALSE", RubyType.FALSE_CLASS));
        arrayList.add(RubyPredefinedVariable.create("NIL", RubyType.NIL_CLASS));
        arrayList.add(RubyPredefinedVariable.create("RUBY_PLATFORM", RubyType.STRING));
        arrayList.add(RubyPredefinedVariable.create("RUBY_RELEASE_DATE", RubyType.STRING));
        arrayList.add(RubyPredefinedVariable.create("RUBY_VERSION", RubyType.STRING));
        arrayList.add(RubyPredefinedVariable.create("SCRIPT_LINES__", "Hash"));
        arrayList.add(RubyPredefinedVariable.create("STDERR", "IO"));
        arrayList.add(RubyPredefinedVariable.create("STDIN", "IO"));
        arrayList.add(RubyPredefinedVariable.create("STDOUT", "IO"));
        arrayList.add(RubyPredefinedVariable.create("TOPLEVEL_BINDING", "Binding"));
        arrayList.add(RubyPredefinedVariable.create("TRUE", RubyType.TRUE_CLASS));
        return arrayList;
    }

    private static RubyPredefinedVariable create(String string, String string2, RubyType rubyType) {
        return new RubyPredefinedVariable(string, string2, rubyType);
    }

    private static RubyPredefinedVariable create(String string, RubyType rubyType) {
        return new RubyPredefinedVariable(string, "", rubyType);
    }

    private static RubyPredefinedVariable create(String string, String string2) {
        return new RubyPredefinedVariable(string, "", RubyType.create(string2));
    }

    private static RubyPredefinedVariable create(String string, String string2, String string3) {
        return new RubyPredefinedVariable(string, string2, RubyType.create(string3));
    }

    String getDescription() {
        return this.description;
    }

    String getName() {
        return this.name;
    }

    RubyType getType() {
        return this.type;
    }

    static List<RubyPredefinedVariable> getPredefinedVariables() {
        return VARIABLES;
    }

    static List<RubyPredefinedVariable> getPredefinedClassVariables() {
        return CLASS_VARIABLES;
    }

    public static RubyType getType(String string) {
        for (RubyPredefinedVariable rubyPredefinedVariable : VARIABLES) {
            if (!rubyPredefinedVariable.getName().equals(string)) continue;
            return rubyPredefinedVariable.getType();
        }
        for (RubyPredefinedVariable rubyPredefinedVariable : CLASS_VARIABLES) {
            if (!rubyPredefinedVariable.getName().equals(string)) continue;
            return rubyPredefinedVariable.getType();
        }
        return null;
    }

    public String toString() {
        return RubyPredefinedVariable.class.getSimpleName() + "[name: " + this.name + ", type: " + this.type + "]";
    }
}

