/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.charts.xy.synchronous;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.util.List;
import org.netbeans.lib.profiler.charts.ChartContext;
import org.netbeans.lib.profiler.charts.ChartItem;
import org.netbeans.lib.profiler.charts.ChartItemChange;
import org.netbeans.lib.profiler.charts.ItemSelection;
import org.netbeans.lib.profiler.charts.swing.LongRect;
import org.netbeans.lib.profiler.charts.swing.Utils;
import org.netbeans.lib.profiler.charts.xy.XYItem;
import org.netbeans.lib.profiler.charts.xy.XYItemChange;
import org.netbeans.lib.profiler.charts.xy.XYItemPainter;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYChartContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynchronousXYItemPainter
extends XYItemPainter.Abstract {
    protected final int lineWidth;
    protected final Color lineColor;
    protected final Color fillColor;
    protected final Stroke lineStroke;
    protected final int type;
    protected final int maxValueOffset;

    public static SynchronousXYItemPainter absolutePainter(float f, Color color, Color color2) {
        return new SynchronousXYItemPainter(f, color, color2, 0, 0);
    }

    public static SynchronousXYItemPainter relativePainter(float f, Color color, Color color2, int n) {
        return new SynchronousXYItemPainter(f, color, color2, 1, n);
    }

    public SynchronousXYItemPainter(float f, Color color, Color color2, int n, int n2) {
        if (color == null && color2 == null) {
            throw new IllegalArgumentException("No parameters defined");
        }
        this.lineWidth = (int)Math.ceil(f);
        this.lineColor = Utils.checkedColor(color);
        this.fillColor = Utils.checkedColor(color2);
        this.lineStroke = new BasicStroke(f, 1, 1);
        this.type = n;
        this.maxValueOffset = n2;
    }

    @Override
    public LongRect getItemBounds(ChartItem chartItem) {
        XYItem xYItem = (XYItem)chartItem;
        if (this.type == 0) {
            return this.getDataBounds(xYItem.getBounds());
        }
        LongRect longRect = new LongRect(xYItem.getBounds());
        longRect.y = 0L;
        longRect.height = 0L;
        return longRect;
    }

    @Override
    public LongRect getItemBounds(ChartItem chartItem, ChartContext chartContext) {
        XYItem xYItem = (XYItem)chartItem;
        if (this.type == 0) {
            return this.getViewBounds(xYItem.getBounds(), chartContext);
        }
        return this.getViewBoundsRelative(xYItem.getBounds(), xYItem, chartContext);
    }

    @Override
    public boolean isBoundsChange(ChartItemChange chartItemChange) {
        XYItemChange xYItemChange = (XYItemChange)chartItemChange;
        return !LongRect.equals(xYItemChange.getOldValuesBounds(), xYItemChange.getNewValuesBounds());
    }

    @Override
    public boolean isAppearanceChange(ChartItemChange chartItemChange) {
        XYItemChange xYItemChange = (XYItemChange)chartItemChange;
        LongRect longRect = xYItemChange.getDirtyValuesBounds();
        return longRect.width != 0L || longRect.height != 0L;
    }

    @Override
    public LongRect getDirtyBounds(ChartItemChange chartItemChange, ChartContext chartContext) {
        XYItemChange xYItemChange = (XYItemChange)chartItemChange;
        if (this.type == 0) {
            return this.getViewBounds(xYItemChange.getDirtyValuesBounds(), chartContext);
        }
        LongRect longRect = xYItemChange.getOldValuesBounds();
        LongRect longRect2 = xYItemChange.getNewValuesBounds();
        if (longRect.y != longRect2.y || longRect.height != longRect2.height) {
            return this.getItemBounds(xYItemChange.getItem(), chartContext);
        }
        return this.getViewBoundsRelative(xYItemChange.getDirtyValuesBounds(), xYItemChange.getItem(), chartContext);
    }

    @Override
    public double getItemView(double d, XYItem xYItem, ChartContext chartContext) {
        if (this.type == 0) {
            return super.getItemView(d, xYItem, chartContext);
        }
        double d2 = SynchronousXYItemPainter.getItemValueFactor(chartContext, this.maxValueOffset, xYItem.getBounds().height);
        return chartContext.getViewY((double)chartContext.getDataOffsetY() + d2 * d);
    }

    @Override
    public double getItemValue(double d, XYItem xYItem, ChartContext chartContext) {
        if (this.type == 0) {
            return super.getItemValue(d, xYItem, chartContext);
        }
        double d2 = SynchronousXYItemPainter.getItemValueFactor(chartContext, this.maxValueOffset, xYItem.getBounds().height);
        return chartContext.getDataY(d) / d2;
    }

    @Override
    public double getItemValueScale(XYItem xYItem, ChartContext chartContext) {
        if (this.type == 0) {
            return super.getItemValueScale(xYItem, chartContext);
        }
        long l = xYItem.getBounds().height;
        if (l == 0L) {
            return 1.0;
        }
        double d = SynchronousXYItemPainter.getItemValueFactor(chartContext, this.maxValueOffset, l);
        return d / chartContext.getDataHeight(1.0);
    }

    @Override
    public boolean supportsHovering(ChartItem chartItem) {
        return false;
    }

    @Override
    public boolean supportsSelecting(ChartItem chartItem) {
        return false;
    }

    @Override
    public LongRect getSelectionBounds(ItemSelection itemSelection, ChartContext chartContext) {
        throw new UnsupportedOperationException("getSelectionBounds() not supported");
    }

    @Override
    public ItemSelection getClosestSelection(ChartItem chartItem, int n, int n2, ChartContext chartContext) {
        return null;
    }

    @Override
    public void paintItem(ChartItem chartItem, List<ItemSelection> list, List<ItemSelection> list2, Graphics2D graphics2D, Rectangle rectangle, ChartContext chartContext) {
        this.paint((XYItem)chartItem, list, list2, graphics2D, rectangle, (SynchronousXYChartContext)chartContext);
    }

    private LongRect getDataBounds(LongRect longRect) {
        LongRect longRect2 = new LongRect(longRect);
        if (this.fillColor != null) {
            longRect2.height += longRect2.y;
            longRect2.y = 0L;
        }
        return longRect2;
    }

    private LongRect getViewBounds(LongRect longRect, ChartContext chartContext) {
        LongRect longRect2 = this.getDataBounds(longRect);
        LongRect longRect3 = chartContext.getViewRect(longRect2);
        LongRect.addBorder(longRect3, this.lineWidth);
        return longRect3;
    }

    private LongRect getViewBoundsRelative(LongRect longRect, XYItem xYItem, ChartContext chartContext) {
        long l;
        LongRect longRect2 = xYItem.getBounds();
        double d = SynchronousXYItemPainter.getItemValueFactor(chartContext, this.maxValueOffset, longRect2.height);
        double d2 = (double)chartContext.getDataOffsetY() + d * (double)(longRect.y - longRect2.y);
        double d3 = (double)chartContext.getDataOffsetY() + d * (double)(longRect.y + longRect.height - longRect2.y);
        long l2 = (long)Math.ceil(chartContext.getViewX(longRect.x));
        long l3 = (long)Math.ceil(chartContext.getViewWidth(longRect.width));
        if (chartContext.isRightBased()) {
            l2 -= l3;
        }
        long l4 = (long)Math.ceil(chartContext.getViewY(d2));
        long l5 = (long)Math.ceil(chartContext.getViewY(d3));
        long l6 = l = chartContext.isBottomBased() ? l4 - l5 : l5 - l4;
        if (!chartContext.isBottomBased()) {
            l5 -= l;
        }
        LongRect longRect3 = new LongRect(l2, l5, l3, l);
        LongRect.addBorder(longRect3, this.lineWidth);
        return longRect3;
    }

    protected void paint(XYItem xYItem, List<ItemSelection> list, List<ItemSelection> list2, Graphics2D graphics2D, Rectangle rectangle, SynchronousXYChartContext synchronousXYChartContext) {
        if (xYItem.getValuesCount() < 2) {
            return;
        }
        if (synchronousXYChartContext.getViewWidth() == 0L || synchronousXYChartContext.getViewHeight() == 0L) {
            return;
        }
        int[][] nArray = SynchronousXYItemPainter.createPoints(xYItem, rectangle, synchronousXYChartContext, this.type, this.maxValueOffset);
        if (nArray == null) {
            return;
        }
        int[] nArray2 = nArray[0];
        int[] nArray3 = nArray[1];
        int n = nArray2.length;
        if (this.fillColor != null) {
            int n2 = Utils.checkedInt(synchronousXYChartContext.getViewY(synchronousXYChartContext.getDataOffsetY()));
            n2 = Math.max(Utils.checkedInt(synchronousXYChartContext.getViewportOffsetY()), n2);
            n2 = Math.min(Utils.checkedInt(synchronousXYChartContext.getViewportOffsetY() + (long)synchronousXYChartContext.getViewportHeight()), n2);
            Polygon polygon = new Polygon();
            polygon.xpoints = nArray2;
            polygon.ypoints = nArray3;
            polygon.npoints = n;
            polygon.xpoints[n - 2] = nArray2[n - 3];
            polygon.ypoints[n - 2] = n2;
            polygon.xpoints[n - 1] = nArray2[0];
            polygon.ypoints[n - 1] = n2;
            graphics2D.setPaint(this.fillColor);
            graphics2D.fill(polygon);
        }
        if (this.lineColor != null) {
            graphics2D.setPaint(this.lineColor);
            graphics2D.setStroke(this.lineStroke);
            graphics2D.drawPolyline(nArray2, nArray3, n - 2);
        }
    }

    private static int[][] createPoints(XYItem xYItem, Rectangle rectangle, SynchronousXYChartContext synchronousXYChartContext, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6 = xYItem.getValuesCount();
        int[][] nArray = synchronousXYChartContext.getVisibleBounds(rectangle);
        int n7 = nArray[0][0];
        int n8 = n7;
        if (n8 == -1) {
            n8 = nArray[0][1];
        }
        if (n8 == -1) {
            return null;
        }
        if (n7 != -1 && n8 > 0) {
            --n8;
        }
        if ((n5 = (n4 = nArray[1][0])) == -1) {
            n5 = nArray[1][1];
        }
        if (n5 == -1) {
            n5 = n6 - 1;
        }
        if (n4 != -1 && n5 < n6 - 1) {
            ++n5;
        }
        if ((n3 = (int)Math.ceil((long)n6 / synchronousXYChartContext.getViewWidth())) == 0) {
            n3 = 1;
        }
        int n9 = n5 - n8 + 1;
        if (n3 > 1) {
            int n10 = n8 % n3;
            int n11 = n5 % n3;
            n5 = n5 - n11 + n3;
            n9 = (n5 - (n8 -= n10)) / n3 + 1;
            n5 = Math.min(n5, n6 - 1);
        }
        int[] nArray2 = new int[n9 + 2];
        int[] nArray3 = new int[n9 + 2];
        double d = n == 1 ? SynchronousXYItemPainter.getItemValueFactor(synchronousXYChartContext, n2, xYItem.getBounds().height) : 0.0;
        for (int i = 0; i < n9; ++i) {
            int n12 = i == n9 - 1 ? n5 : n8 + i * n3;
            nArray2[i] = Utils.checkedInt(Math.ceil(synchronousXYChartContext.getViewX(xYItem.getXValue(n12))));
            nArray3[i] = Utils.checkedInt(Math.ceil(SynchronousXYItemPainter.getYValue(xYItem, n12, n, synchronousXYChartContext, d)));
        }
        return new int[][]{nArray2, nArray3};
    }

    private static double getYValue(XYItem xYItem, int n, int n2, ChartContext chartContext, double d) {
        if (n2 == 0) {
            return chartContext.getViewY(xYItem.getYValue(n));
        }
        return chartContext.getViewY((double)chartContext.getDataOffsetY() + d * (double)(xYItem.getYValue(n) - xYItem.getBounds().y));
    }

    private static double getItemValueFactor(ChartContext chartContext, double d, double d2) {
        return ((double)chartContext.getDataHeight() - chartContext.getDataHeight(d)) / d2;
    }
}

