/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.View;
import org.netbeans.api.editor.settings.AttributesUtilities;
import org.netbeans.editor.AtomicLockEvent;
import org.netbeans.editor.AtomicLockListener;
import org.netbeans.editor.BaseCaret;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.DrawContext;
import org.netbeans.editor.DrawEngineLineView;
import org.netbeans.editor.DrawLayer;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.MarkFactory;
import org.netbeans.editor.view.spi.LockView;
import org.netbeans.modules.editor.lib2.highlighting.HighlightingManager;
import org.netbeans.modules.editor.lib2.highlighting.HighlightingSpiPackageAccessor;
import org.netbeans.modules.editor.lib2.highlighting.HighlightsLayerAccessor;
import org.netbeans.modules.editor.lib2.highlighting.HighlightsLayerFilter;
import org.netbeans.spi.editor.highlighting.HighlightsChangeEvent;
import org.netbeans.spi.editor.highlighting.HighlightsChangeListener;
import org.netbeans.spi.editor.highlighting.HighlightsContainer;
import org.netbeans.spi.editor.highlighting.HighlightsLayer;
import org.netbeans.spi.editor.highlighting.HighlightsSequence;
import org.netbeans.spi.editor.highlighting.ZOrder;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class HighlightingDrawLayer
extends DrawLayer.AbstractLayer
implements HighlightsChangeListener,
AtomicLockListener {
    private static final Logger LOG = Logger.getLogger(HighlightingDrawLayer.class.getName());
    private static final String LAYER_A_NAME = "org-netbeans-lib-editor-nview-HighlightingDrawLayer/A";
    private static final String LAYER_B_NAME = "highlight-row-layer";
    private static final String LAYER_C_NAME = "org-netbeans-lib-editor-nview-HighlightingDrawLayer/C";
    private static final String LAYER_D_NAME = "org-netbeans-lib-editor-nview-HighlightingDrawLayer/D";
    private static final HighlightsLayerFilter FILTER_A = new HighlightsLayerFilter(){

        public List<? extends HighlightsLayer> filterLayers(List<? extends HighlightsLayer> list) {
            ArrayList<HighlightsLayer> arrayList = new ArrayList<HighlightsLayer>();
            boolean bl = false;
            for (HighlightsLayer highlightsLayer : list) {
                HighlightsLayerAccessor highlightsLayerAccessor = HighlightingSpiPackageAccessor.get().getHighlightsLayerAccessor(highlightsLayer);
                if ("org.netbeans.modules.editor.lib2.highlighting.CaretRowHighlighting".equals(highlightsLayerAccessor.getLayerTypeId())) {
                    bl = true;
                    continue;
                }
                if (!bl) continue;
                arrayList.add(highlightsLayer);
            }
            return arrayList;
        }
    };
    private static final HighlightsLayerFilter FILTER_B = new HighlightsLayerFilter(){

        public List<? extends HighlightsLayer> filterLayers(List<? extends HighlightsLayer> list) {
            ArrayList<HighlightsLayer> arrayList = new ArrayList<HighlightsLayer>();
            int n = HighlightingSpiPackageAccessor.get().getZOrderRack(ZOrder.SYNTAX_RACK);
            for (HighlightsLayer highlightsLayer : list) {
                HighlightsLayerAccessor highlightsLayerAccessor = HighlightingSpiPackageAccessor.get().getHighlightsLayerAccessor(highlightsLayer);
                if (HighlightingSpiPackageAccessor.get().getZOrderRack(highlightsLayerAccessor.getZOrder()) > n) {
                    arrayList.add(highlightsLayer);
                }
                if (!"org.netbeans.modules.editor.lib2.highlighting.CaretRowHighlighting".equals(highlightsLayerAccessor.getLayerTypeId())) continue;
                break;
            }
            return arrayList;
        }
    };
    private static final HighlightsLayerFilter FILTER_C = new HighlightsLayerFilter(){

        public List<? extends HighlightsLayer> filterLayers(List<? extends HighlightsLayer> list) {
            ArrayList<HighlightsLayer> arrayList = new ArrayList<HighlightsLayer>();
            int n = HighlightingSpiPackageAccessor.get().getZOrderRack(ZOrder.SYNTAX_RACK);
            for (HighlightsLayer highlightsLayer : list) {
                HighlightsLayerAccessor highlightsLayerAccessor = HighlightingSpiPackageAccessor.get().getHighlightsLayerAccessor(highlightsLayer);
                if (HighlightingSpiPackageAccessor.get().getZOrderRack(highlightsLayerAccessor.getZOrder()) < n) continue;
                if (HighlightingSpiPackageAccessor.get().getZOrderRack(highlightsLayerAccessor.getZOrder()) != n) break;
                arrayList.add(highlightsLayer);
            }
            return arrayList;
        }
    };
    private static final HighlightsLayerFilter FILTER_D = new HighlightsLayerFilter(){

        public List<? extends HighlightsLayer> filterLayers(List<? extends HighlightsLayer> list) {
            ArrayList<HighlightsLayer> arrayList = new ArrayList<HighlightsLayer>();
            int n = HighlightingSpiPackageAccessor.get().getZOrderRack(ZOrder.SYNTAX_RACK);
            for (HighlightsLayer highlightsLayer : list) {
                HighlightsLayerAccessor highlightsLayerAccessor = HighlightingSpiPackageAccessor.get().getHighlightsLayerAccessor(highlightsLayer);
                if (HighlightingSpiPackageAccessor.get().getZOrderRack(highlightsLayerAccessor.getZOrder()) == n) break;
                arrayList.add(highlightsLayer);
            }
            return arrayList;
        }
    };
    private final HighlightsLayerFilter filter;
    private WeakReference<JTextComponent> paneRef = null;
    private HighlightsContainer highlights = null;
    private AttributeSet lastAttributeSet = null;
    private AttributeSet lastEOLAttribs = null;
    private AttributeSet lastELAttribs = null;
    private boolean theLittleSpitAtTheBeginningOfAnEmptyLineDrawn = false;
    private int lastLineIndex;
    private boolean atomicLockListeningResolved;
    private boolean inAtomicLock;
    private Position damageStartPos;
    private Position damageEndPos;

    public static void hookUp(EditorUI editorUI) {
        DrawLayer drawLayer;
        DrawLayer drawLayer2;
        DrawLayer drawLayer3;
        DrawLayer drawLayer4 = editorUI.findLayer(LAYER_A_NAME);
        if (drawLayer4 == null) {
            drawLayer4 = new HighlightingDrawLayer(LAYER_A_NAME, FILTER_A);
            editorUI.addLayer(drawLayer4, 10000);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Successfully registered layerA in " + HighlightingDrawLayer.simpleToString(editorUI));
            }
        } else if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("LayerA is already registered in " + HighlightingDrawLayer.simpleToString(editorUI));
        }
        if ((drawLayer3 = editorUI.findLayer(LAYER_B_NAME)) == null) {
            drawLayer3 = new HighlightingDrawLayer(LAYER_B_NAME, FILTER_B);
            editorUI.addLayer(drawLayer3, 2050);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Successfully registered layerB in " + HighlightingDrawLayer.simpleToString(editorUI));
            }
        } else if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("LayerB is already registered in " + HighlightingDrawLayer.simpleToString(editorUI));
        }
        if ((drawLayer2 = editorUI.findLayer(LAYER_C_NAME)) == null) {
            drawLayer2 = new HighlightingDrawLayer(LAYER_C_NAME, FILTER_C);
            editorUI.addLayer(drawLayer2, 1000);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Successfully registered layerC in " + HighlightingDrawLayer.simpleToString(editorUI));
            }
        } else if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("LayerC is already registered in " + HighlightingDrawLayer.simpleToString(editorUI));
        }
        if ((drawLayer = editorUI.findLayer(LAYER_D_NAME)) == null) {
            drawLayer = new HighlightingDrawLayer(LAYER_D_NAME, FILTER_D);
            editorUI.addLayer(drawLayer, 500);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Successfully registered layerD in " + HighlightingDrawLayer.simpleToString(editorUI));
            }
        } else if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("LayerD is already registered in " + HighlightingDrawLayer.simpleToString(editorUI));
        }
    }

    private HighlightingDrawLayer(String string, HighlightsLayerFilter highlightsLayerFilter) {
        super(string);
        this.filter = highlightsLayerFilter;
    }

    @Override
    public void init(DrawContext drawContext) {
        Serializable serializable;
        super.init(drawContext);
        if (this.highlights == null) {
            BaseDocument baseDocument;
            serializable = drawContext.getEditorUI().getComponent();
            if (serializable == null) {
                baseDocument = drawContext.getEditorUI().getDocument();
                if (baseDocument == null) {
                    return;
                }
                String string = (String)baseDocument.getProperty("mimeType");
                assert (string != null) : "Document's mime type can't be null: " + baseDocument;
                JEditorPane jEditorPane = new JEditorPane();
                jEditorPane.setDocument(baseDocument);
                jEditorPane.putClientProperty("HighlightsLayerIncludes", new String[]{"^.*NonLexerSyntaxHighlighting$", "^.*SyntaxHighlighting$"});
                serializable = jEditorPane;
            }
            this.paneRef = new WeakReference<JTextComponent>((JTextComponent)serializable);
            baseDocument = HighlightingManager.getInstance();
            this.highlights = baseDocument.getHighlights((JTextComponent)serializable, this.filter);
            this.highlights.addHighlightsChangeListener((HighlightsChangeListener)this);
            if (LOG.isLoggable(Level.FINE)) {
                if (this.filter == FILTER_A) {
                    LOG.fine("CHC@" + Integer.toHexString(System.identityHashCode(this.highlights)) + " is for FILTER_A");
                } else if (this.filter == FILTER_B) {
                    LOG.fine("CHC@" + Integer.toHexString(System.identityHashCode(this.highlights)) + " is for FILTER_B");
                } else if (this.filter == FILTER_C) {
                    LOG.fine("CHC@" + Integer.toHexString(System.identityHashCode(this.highlights)) + " is for FILTER_C");
                }
            }
        }
        this.lastAttributeSet = null;
        this.lastEOLAttribs = null;
        this.lastELAttribs = null;
        this.theLittleSpitAtTheBeginningOfAnEmptyLineDrawn = false;
        if (!this.atomicLockListeningResolved) {
            this.atomicLockListeningResolved = true;
            serializable = drawContext.getEditorUI().getDocument();
            ((BaseDocument)serializable).addAtomicLockListener((AtomicLockListener)WeakListeners.create(AtomicLockListener.class, (EventListener)this, (Object)serializable));
        }
    }

    @Override
    public boolean isActive(DrawContext drawContext, MarkFactory.DrawMark drawMark) {
        if (this.highlights != null) {
            return this.processOffset(drawContext, false);
        }
        return false;
    }

    @Override
    public void updateContext(DrawContext drawContext) {
        if (this.highlights != null) {
            if (drawContext.isEOL() && drawContext.isBOL()) {
                if (this.extendsEmptyLine() && !this.theLittleSpitAtTheBeginningOfAnEmptyLineDrawn) {
                    this.theLittleSpitAtTheBeginningOfAnEmptyLineDrawn = true;
                    Coloring coloring = Coloring.fromAttributeSet(this.lastELAttribs);
                    coloring.apply(drawContext);
                } else if (this.extendsEOL()) {
                    Coloring coloring = Coloring.fromAttributeSet(this.lastEOLAttribs);
                    coloring.apply(drawContext);
                }
            } else if (drawContext.isEOL()) {
                if (this.extendsEOL()) {
                    Coloring coloring = Coloring.fromAttributeSet(this.lastEOLAttribs);
                    coloring.apply(drawContext);
                }
            } else {
                this.processOffset(drawContext, true);
            }
        }
    }

    @Override
    public boolean extendsEOL() {
        boolean bl;
        if (this.lastEOLAttribs == null && this.lastAttributeSet != null) {
            List<AttributeSet> list = (List<AttributeSet>)this.lastAttributeSet.getAttribute("dismantled-structure");
            AttributeSet[] attributeSetArray = this.filter(list != null ? list : Collections.singletonList(this.lastAttributeSet));
            this.lastEOLAttribs = attributeSetArray[0];
            this.lastELAttribs = attributeSetArray[1];
        }
        boolean bl2 = bl = this.lastEOLAttribs != null && this.lastEOLAttribs != SimpleAttributeSet.EMPTY;
        if (LOG.isLoggable(Level.FINE) && this.filter == FILTER_A) {
            LOG.fine(HighlightingDrawLayer.simpleToString(this) + ".extendsEOL = " + bl);
        }
        return bl;
    }

    @Override
    public boolean extendsEmptyLine() {
        boolean bl;
        if (this.lastELAttribs == null && this.lastAttributeSet != null) {
            List<AttributeSet> list = (List<AttributeSet>)this.lastAttributeSet.getAttribute("dismantled-structure");
            AttributeSet[] attributeSetArray = this.filter(list != null ? list : Collections.singletonList(this.lastAttributeSet));
            this.lastEOLAttribs = attributeSetArray[0];
            this.lastELAttribs = attributeSetArray[1];
        }
        boolean bl2 = bl = this.lastELAttribs != null && this.lastELAttribs != SimpleAttributeSet.EMPTY;
        if (LOG.isLoggable(Level.FINE) && this.filter == FILTER_A) {
            LOG.fine(HighlightingDrawLayer.simpleToString(this) + ".extendsEmptyLine = " + bl);
        }
        return bl;
    }

    public void highlightChanged(HighlightsChangeEvent highlightsChangeEvent) {
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("BRIDGE-LAYER: changed area [" + highlightsChangeEvent.getStartOffset() + ", " + highlightsChangeEvent.getEndOffset() + "]");
        }
        if (highlightsChangeEvent.getStartOffset() == highlightsChangeEvent.getEndOffset()) {
            return;
        }
        if (this.inAtomicLock) {
            Document document;
            JTextComponent jTextComponent = (JTextComponent)this.paneRef.get();
            if (jTextComponent != null && (document = jTextComponent.getDocument()) != null) {
                int n = Math.max(0, Math.min(highlightsChangeEvent.getStartOffset(), document.getLength()));
                int n2 = Math.max(n, Math.min(highlightsChangeEvent.getEndOffset(), document.getLength()));
                try {
                    if (this.damageStartPos == null) {
                        this.damageStartPos = document.createPosition(n);
                    }
                    if (this.damageEndPos == null) {
                        this.damageEndPos = document.createPosition(n2);
                    }
                    if (n < this.damageStartPos.getOffset()) {
                        this.damageStartPos = document.createPosition(n);
                    }
                    if (n2 > this.damageEndPos.getOffset()) {
                        this.damageEndPos = document.createPosition(n2);
                    }
                }
                catch (BadLocationException badLocationException) {
                    LOG.log(Level.WARNING, "Cannot set damaged range", badLocationException);
                    this.damageStartPos = null;
                    this.damageEndPos = null;
                }
            }
            if (LOG.isLoggable(Level.FINE) && this.damageStartPos != null && this.damageEndPos != null) {
                LOG.fine("highlightsChangeEvent: [" + highlightsChangeEvent.getStartOffset() + ", " + highlightsChangeEvent.getEndOffset() + "], toDAMAGE: [" + this.damageStartPos.getOffset() + ", " + this.damageEndPos.getOffset() + "]\n");
            }
            return;
        }
        this.invokeDamageRange(highlightsChangeEvent.getStartOffset(), highlightsChangeEvent.getEndOffset());
    }

    private void invokeDamageRange(final int n, final int n2) {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                block11: {
                    Document document;
                    HighlightingDrawLayer.this.setNextActivityChangeOffset(0);
                    JTextComponent jTextComponent = (JTextComponent)HighlightingDrawLayer.this.paneRef.get();
                    if (jTextComponent != null && (document = jTextComponent.getDocument()) instanceof AbstractDocument) {
                        AbstractDocument abstractDocument = (AbstractDocument)document;
                        abstractDocument.readLock();
                        try {
                            int n4;
                            int n22 = Math.min(n2, jTextComponent.getDocument().getLength() + 1);
                            int n3 = n4 = n >= n22 ? 0 : n;
                            if (n4 >= n22) break block11;
                            try {
                                if (LOG.isLoggable(Level.FINE)) {
                                    LOG.fine("DamageRange: [" + n4 + ", " + n22 + "]\n");
                                }
                                jTextComponent.getUI().damageRange(jTextComponent, n4, n22);
                            }
                            catch (Exception exception) {
                                LOG.log(Level.INFO, "Can't update view: range = [" + n4 + ", " + n22 + "]", exception);
                            }
                            try {
                                if (HighlightingDrawLayer.this.filter == FILTER_C) {
                                    HighlightingDrawLayer.this.notifyViews(jTextComponent.getUI().getRootView(jTextComponent), n4, n22);
                                }
                            }
                            catch (Exception exception) {
                                LOG.log(Level.INFO, "Can't reset line views: range = [" + n4 + ", " + n22 + "]", exception);
                            }
                            Caret caret = jTextComponent.getCaret();
                            if (caret instanceof BaseCaret) {
                                ((BaseCaret)caret).changedUpdate(null);
                            }
                        }
                        finally {
                            abstractDocument.readUnlock();
                        }
                    }
                }
            }
        });
    }

    @Override
    public void atomicLock(AtomicLockEvent atomicLockEvent) {
        this.inAtomicLock = true;
    }

    @Override
    public void atomicUnlock(AtomicLockEvent atomicLockEvent) {
        this.inAtomicLock = false;
        if (this.damageStartPos != null && this.damageEndPos != null) {
            this.invokeDamageRange(this.damageStartPos.getOffset(), this.damageEndPos.getOffset());
        }
        this.damageStartPos = null;
        this.damageEndPos = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyViews(View view, int n, int n2) {
        while (view != null) {
            int n3 = view.getViewIndex(n, Position.Bias.Forward);
            if (n3 != -1) {
                View view2 = view.getView(n3);
                if (view2 instanceof DrawEngineLineView) break;
                view = view2;
                continue;
            }
            view = null;
        }
        if (view != null) {
            LockView lockView = LockView.get(view);
            lockView.lock();
            try {
                int n4 = view.getViewIndex(n, Position.Bias.Forward);
                int n5 = view.getViewIndex(n2, Position.Bias.Forward);
                for (int i = n4; i <= n5; ++i) {
                    View view3 = view.getView(i);
                    if (!(view3 instanceof DrawEngineLineView)) continue;
                    ((DrawEngineLineView)view3).highlightsChanged(Math.max(n, view3.getStartOffset()), Math.min(n2, view3.getEndOffset()));
                }
            }
            finally {
                lockView.unlock();
            }
        }
    }

    private int findLineEndOffset(Document document, int n) {
        Element element;
        int n2 = this.lastLineIndex;
        Element element2 = document.getDefaultRootElement();
        if (n2 < element2.getElementCount() && n >= (element = element2.getElement(n2)).getStartOffset() && n < element.getEndOffset()) {
            return element.getEndOffset();
        }
        this.lastLineIndex = n2 = element2.getElementIndex(n);
        return element2.getElement(n2).getEndOffset();
    }

    private boolean processOffset(DrawContext drawContext, boolean bl) {
        HighlightsSequence highlightsSequence;
        boolean bl2;
        int n;
        BaseDocument baseDocument = drawContext.getEditorUI().getDocument();
        int n2 = this.findLineEndOffset(baseDocument, n = drawContext.getFragmentOffset());
        if (n2 >= baseDocument.getLength()) {
            n2 = Integer.MAX_VALUE;
        }
        if (bl2 = (highlightsSequence = this.highlights.getHighlights(n, n2)).moveNext()) {
            if (highlightsSequence.getStartOffset() <= n) {
                if (bl) {
                    Coloring coloring = Coloring.fromAttributeSet(highlightsSequence.getAttributes());
                    coloring.apply(drawContext);
                }
                this.lastAttributeSet = highlightsSequence.getAttributes();
                this.setNextActivityChangeOffset(highlightsSequence.getEndOffset());
            } else {
                this.setNextActivityChangeOffset(highlightsSequence.getStartOffset());
            }
            return true;
        }
        return false;
    }

    private AttributeSet[] filter(List<AttributeSet> list) {
        AttributeSet attributeSet2;
        ArrayList<AttributeSet> arrayList = new ArrayList<AttributeSet>();
        ArrayList<AttributeSet> arrayList2 = new ArrayList<AttributeSet>();
        for (AttributeSet attributeSet2 : list) {
            Object object = attributeSet2.getAttribute(HighlightsContainer.ATTR_EXTENDS_EOL);
            if (object instanceof Boolean && ((Boolean)object).booleanValue()) {
                arrayList.add(attributeSet2);
            }
            if (!((object = attributeSet2.getAttribute(HighlightsContainer.ATTR_EXTENDS_EMPTY_LINE)) instanceof Boolean) || !((Boolean)object).booleanValue()) continue;
            arrayList2.add(attributeSet2);
        }
        AttributeSet attributeSet3 = arrayList.size() > 1 ? AttributesUtilities.createComposite((AttributeSet[])arrayList.toArray(new AttributeSet[arrayList.size()])) : (arrayList.size() == 1 ? (AttributeSet)arrayList.get(0) : SimpleAttributeSet.EMPTY);
        attributeSet2 = arrayList2.size() > 1 ? AttributesUtilities.createComposite((AttributeSet[])arrayList2.toArray(new AttributeSet[arrayList2.size()])) : (arrayList2.size() == 1 ? (AttributeSet)arrayList2.get(0) : SimpleAttributeSet.EMPTY);
        return new AttributeSet[]{attributeSet3, attributeSet2};
    }

    private static String simpleToString(Object object) {
        return object == null ? "null" : object.getClass() + "@" + Integer.toHexString(System.identityHashCode(object));
    }
}

