/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ide.ergonomics.fod;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.ide.ergonomics.fod.ConfigurationPanel;
import org.netbeans.modules.ide.ergonomics.fod.FeatureInfo;
import org.netbeans.modules.ide.ergonomics.fod.FoDFileSystem;
import org.openide.modules.ModuleInfo;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FeatureManager
implements PropertyChangeListener,
LookupListener {
    private static FeatureManager INSTANCE;
    private static final Logger UILOG;
    private static final RequestProcessor RP;
    private final Lookup.Result<ModuleInfo> result;
    private final ChangeSupport support;
    private Set<String> enabledCnbs = Collections.emptySet();
    private static Lookup featureTypesLookup;
    private static boolean noCnbCheck;

    private FeatureManager() {
        this.support = new ChangeSupport((Object)this);
        this.result = Lookup.getDefault().lookupResult(ModuleInfo.class);
        this.result.addLookupListener((LookupListener)this);
        this.resultChanged(null);
    }

    public static synchronized FeatureManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new FeatureManager();
        }
        return INSTANCE;
    }

    public RequestProcessor.Task create(Runnable runnable) {
        return RP.create(runnable);
    }

    static void logUI(String string, Object ... objectArray) {
        LogRecord logRecord = new LogRecord(Level.FINE, string);
        logRecord.setResourceBundleName("org.netbeans.modules.ide.ergonomics.fod.Bundle");
        logRecord.setResourceBundle(NbBundle.getBundle(ConfigurationPanel.class));
        logRecord.setParameters(objectArray);
        logRecord.setLoggerName(UILOG.getName());
        UILOG.log(logRecord);
    }

    static boolean showInAU(ModuleInfo moduleInfo) {
        Object object = moduleInfo.getAttribute("AutoUpdate-Show-In-Client");
        return object == null || "true".equals(object);
    }

    public static Map<String, String> nbprojectTypes() {
        return FeatureInfo.nbprojectTypes();
    }

    public static Map<String, String> projectFiles() {
        return FeatureInfo.projectFiles();
    }

    public static Collection<? extends FeatureInfo> features() {
        return FeatureManager.featureTypesLookup().lookupAll(FeatureInfo.class);
    }

    static FeatureInfo findInfo(String string) {
        for (FeatureInfo featureInfo : FeatureManager.features()) {
            if (!featureInfo.getCodeNames().contains(string)) continue;
            return featureInfo;
        }
        return null;
    }

    public static int dumpModules() {
        return FeatureManager.dumpModules(Level.FINE, Level.FINEST);
    }

    public static int dumpModules(Level level, Level level2) {
        if (!FoDFileSystem.LOG.isLoggable(level)) {
            return -1;
        }
        int n = 0;
        Collection collection = Lookup.getDefault().lookupAll(ModuleInfo.class);
        for (FeatureInfo featureInfo : FeatureManager.features()) {
            TreeSet<String> treeSet = new TreeSet<String>();
            TreeSet<String> treeSet2 = new TreeSet<String>();
            for (ModuleInfo moduleInfo : collection) {
                if (!featureInfo.getCodeNames().contains(moduleInfo.getCodeNameBase())) continue;
                if (moduleInfo.isEnabled()) {
                    treeSet.add(moduleInfo.getCodeNameBase());
                    continue;
                }
                treeSet2.add(moduleInfo.getCodeNameBase());
            }
            if (treeSet.isEmpty() && treeSet2.isEmpty()) {
                FoDFileSystem.LOG.log(level, featureInfo.clusterName + " not present");
                continue;
            }
            if (treeSet.isEmpty()) {
                FoDFileSystem.LOG.log(level, featureInfo.clusterName + " disabled");
                continue;
            }
            if (treeSet2.isEmpty()) {
                FoDFileSystem.LOG.log(level, featureInfo.clusterName + " enabled");
                ++n;
                continue;
            }
            FoDFileSystem.LOG.log(level, featureInfo.clusterName + " enabled " + treeSet.size() + " disabled " + treeSet2.size());
            ++n;
            for (String string : treeSet2) {
                FoDFileSystem.LOG.log(level2, "- " + string);
            }
            for (String string : treeSet) {
                FoDFileSystem.LOG.log(level2, "+ " + string);
            }
        }
        return n;
    }

    public static synchronized void assignFeatureTypesLookup(Lookup lookup) {
        boolean bl = false;
        if (!$assertionsDisabled) {
            bl = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (!bl) {
            throw new IllegalStateException();
        }
        featureTypesLookup = lookup;
        noCnbCheck = true;
    }

    private static synchronized Lookup featureTypesLookup() {
        if (featureTypesLookup != null) {
            return featureTypesLookup;
        }
        String string = System.getProperty("netbeans.dirs");
        if (string == null) {
            featureTypesLookup = Lookup.EMPTY;
        } else {
            String[] stringArray;
            InstanceContent instanceContent = new InstanceContent();
            AbstractLookup abstractLookup = new AbstractLookup((AbstractLookup.Content)instanceContent);
            for (String string2 : stringArray = string.split(File.pathSeparator)) {
                int n = string2.lastIndexOf(File.separatorChar);
                String string3 = string2.substring(n + 1).replaceFirst("[0-9\\.]*$", "");
                String string4 = "/org/netbeans/modules/ide/ergonomics/" + string3;
                String string5 = string4 + "/layer.xml";
                String string6 = string4 + "/Bundle.properties";
                URL uRL = FeatureManager.class.getResource(string5);
                URL uRL2 = FeatureManager.class.getResource(string6);
                if (uRL == null || uRL2 == null) continue;
                try {
                    FeatureInfo featureInfo = FeatureInfo.create(string3, uRL, uRL2);
                    instanceContent.add((Object)featureInfo);
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
            featureTypesLookup = abstractLookup;
        }
        return featureTypesLookup;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.support.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.support.removeChangeListener(changeListener);
    }

    public void resultChanged(LookupEvent lookupEvent) {
        for (Object object : this.result.allInstances()) {
            object.removePropertyChangeListener((PropertyChangeListener)this);
            object.addPropertyChangeListener((PropertyChangeListener)this);
        }
        HashSet hashSet = new HashSet();
        for (ModuleInfo moduleInfo : this.result.allInstances()) {
            if (!moduleInfo.isEnabled()) continue;
            hashSet.add(moduleInfo.getCodeNameBase());
        }
        this.enabledCnbs = hashSet;
        if (lookupEvent != null) {
            this.fireChange();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("enabled".equals(propertyChangeEvent.getPropertyName())) {
            ModuleInfo moduleInfo = (ModuleInfo)propertyChangeEvent.getSource();
            if (!noCnbCheck && this.enabledCnbs.contains(moduleInfo.getCodeNameBase()) && moduleInfo.isEnabled()) {
                return;
            }
            this.fireChange();
            if (moduleInfo.isEnabled()) {
                this.enabledCnbs.add(moduleInfo.getCodeNameBase());
            } else {
                this.enabledCnbs.remove(moduleInfo.getCodeNameBase());
            }
        }
    }

    private void fireChange() {
        FoDFileSystem.LOG.fine("Firing FeatureManager change");
        for (FeatureInfo featureInfo : FeatureManager.features()) {
            featureInfo.clearCache();
        }
        this.support.fireChange();
        FoDFileSystem.LOG.fine("FeatureManager change delivered");
    }

    public final void waitFinished() {
        RP.post(new Runnable(){

            public void run() {
            }
        }).waitFinished();
    }

    static {
        UILOG = Logger.getLogger("org.netbeans.ui.ergonomics");
        RP = new RequestProcessor("FoD Processor");
    }
}

