/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.wizards;

import java.awt.Component;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import org.netbeans.api.java.project.classpath.ProjectClassPathModifier;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Formatter;
import org.netbeans.modules.j2ee.core.api.support.SourceGroups;
import org.netbeans.modules.spring.api.beans.ConfigFileGroup;
import org.netbeans.modules.spring.api.beans.ConfigFileManager;
import org.netbeans.modules.spring.beans.ProjectSpringScopeProvider;
import org.netbeans.modules.spring.beans.wizards.SpringXMLConfigGroupPanel;
import org.netbeans.modules.spring.beans.wizards.SpringXMLConfigNamespacesPanel;
import org.netbeans.modules.spring.spi.beans.SpringConfigFileLocationProvider;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileAlreadyLockedException;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.MutexException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NewSpringXMLConfigWizardIterator
implements WizardDescriptor.AsynchronousInstantiatingIterator {
    private int index;
    private WizardDescriptor wizard;
    private WizardDescriptor.Panel[] panels;

    private WizardDescriptor.Panel[] getPanels() {
        if (this.panels == null) {
            Project project = Templates.getProject((WizardDescriptor)this.wizard);
            SourceGroup[] sourceGroupArray = ProjectUtils.getSources((Project)project).getSourceGroups("generic");
            ConfigFileManager configFileManager = NewSpringXMLConfigWizardIterator.getConfigFileManager(project);
            List<ConfigFileGroup> list = configFileManager != null ? configFileManager.getConfigFileGroups() : null;
            SpringXMLConfigGroupPanel springXMLConfigGroupPanel = list != null && !list.isEmpty() ? new SpringXMLConfigGroupPanel(list) : null;
            WizardDescriptor.Panel panel = Templates.createSimpleTargetChooser((Project)project, (SourceGroup[])sourceGroupArray, (WizardDescriptor.Panel)springXMLConfigGroupPanel);
            this.panels = new WizardDescriptor.Panel[]{panel, new SpringXMLConfigNamespacesPanel()};
            String[] stringArray = this.createSteps();
            for (int i = 0; i < this.panels.length; ++i) {
                Component component = this.panels[i].getComponent();
                if (stringArray[i] == null) {
                    stringArray[i] = component.getName();
                }
                if (!(component instanceof JComponent)) continue;
                JComponent jComponent = (JComponent)component;
                jComponent.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
                jComponent.putClientProperty("WizardPanel_contentData", stringArray);
                jComponent.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
                jComponent.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
                jComponent.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
            }
        }
        return this.panels;
    }

    public Set instantiate() throws IOException {
        Library[] libraryArray;
        final FileObject fileObject = Templates.getTargetFolder((WizardDescriptor)this.wizard);
        final String string = Templates.getTargetName((WizardDescriptor)this.wizard);
        final FileObject[] fileObjectArray = new FileObject[]{null};
        FileUtil.runAtomicAction((FileSystem.AtomicAction)new FileSystem.AtomicAction(){

            public void run() throws IOException {
                fileObjectArray[0] = fileObject.createData(string, Templates.getTemplate((WizardDescriptor)NewSpringXMLConfigWizardIterator.this.wizard).getExt());
                String[] stringArray = (String[])NewSpringXMLConfigWizardIterator.this.wizard.getProperty("includedNamespaces");
                NewSpringXMLConfigWizardIterator.this.generateFileContents(fileObjectArray[0], stringArray);
            }
        });
        boolean bl = (Boolean)this.wizard.getProperty("addSpringToClassPath");
        if (bl) {
            libraryArray = new Library[]{(Library)this.wizard.getProperty("springLibrary")};
            this.addLibrariesToClassPath(libraryArray);
        }
        this.addFileToConfigFileManager((Set<ConfigFileGroup>)((libraryArray = (Library[])this.wizard.getProperty("configFileGroups")) != null ? libraryArray : Collections.emptySet()), FileUtil.toFile((FileObject)fileObjectArray[0]));
        return Collections.singleton(fileObjectArray[0]);
    }

    private void addLibrariesToClassPath(Library[] libraryArray) throws IOException {
        FileObject fileObject = NewSpringXMLConfigWizardIterator.getSourceGroupArtifact(Templates.getProject((WizardDescriptor)this.wizard), Templates.getTargetFolder((WizardDescriptor)this.wizard));
        if (fileObject != null) {
            ProjectClassPathModifier.addLibraries((Library[])libraryArray, (FileObject)fileObject, (String)"classpath/compile");
        }
    }

    private void addFileToConfigFileManager(final Set<ConfigFileGroup> set, final File file) throws IOException {
        final ConfigFileManager configFileManager = NewSpringXMLConfigWizardIterator.getConfigFileManager(Templates.getProject((WizardDescriptor)this.wizard));
        try {
            configFileManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws IOException {
                    List<File> list = configFileManager.getConfigFiles();
                    ArrayList<File> arrayList = new ArrayList<File>(list);
                    arrayList.add(file);
                    List<ConfigFileGroup> list2 = configFileManager.getConfigFileGroups();
                    List<ConfigFileGroup> list3 = null;
                    if (set.size() > 0) {
                        list3 = new ArrayList<ConfigFileGroup>(list2.size());
                        for (ConfigFileGroup configFileGroup : list2) {
                            if (set.contains(configFileGroup)) {
                                ConfigFileGroup configFileGroup2 = NewSpringXMLConfigWizardIterator.this.addFileToConfigGroup(configFileGroup, file);
                                list3.add(configFileGroup2);
                                continue;
                            }
                            list3.add(configFileGroup);
                        }
                    } else {
                        list3 = list2;
                    }
                    configFileManager.putConfigFilesAndGroups(arrayList, list3);
                    configFileManager.save();
                    return null;
                }
            });
        }
        catch (MutexException mutexException) {
            throw (IOException)mutexException.getException();
        }
    }

    private ConfigFileGroup addFileToConfigGroup(ConfigFileGroup configFileGroup, File file) {
        List<File> list = configFileGroup.getFiles();
        list.add(file);
        return ConfigFileGroup.create(configFileGroup.getName(), list);
    }

    public void initialize(WizardDescriptor wizardDescriptor) {
        this.wizard = wizardDescriptor;
        if (Templates.getTargetFolder((WizardDescriptor)wizardDescriptor) == null) {
            FileObject fileObject;
            Project project = Templates.getProject((WizardDescriptor)wizardDescriptor);
            SpringConfigFileLocationProvider springConfigFileLocationProvider = project != null ? (SpringConfigFileLocationProvider)project.getLookup().lookup(SpringConfigFileLocationProvider.class) : null;
            FileObject fileObject2 = fileObject = springConfigFileLocationProvider != null ? springConfigFileLocationProvider.getLocation() : null;
            if (fileObject != null) {
                Templates.setTargetFolder((WizardDescriptor)wizardDescriptor, (FileObject)fileObject);
            }
        }
    }

    public void uninitialize(WizardDescriptor wizardDescriptor) {
        this.panels = null;
    }

    public WizardDescriptor.Panel current() {
        return this.getPanels()[this.index];
    }

    public String name() {
        return this.index + 1 + ". from " + this.getPanels().length;
    }

    public boolean hasNext() {
        return this.index < this.getPanels().length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    private String[] createSteps() {
        String[] stringArray = null;
        Object object = this.wizard.getProperty("WizardPanel_contentData");
        if (object != null && object instanceof String[]) {
            stringArray = (String[])object;
        }
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        String[] stringArray2 = new String[stringArray.length - 1 + this.panels.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = i < stringArray.length - 1 ? stringArray[i] : this.panels[i - stringArray.length + 1].getComponent().getName();
        }
        return stringArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateFileContents(FileObject fileObject, String[] stringArray) {
        StringBuilder stringBuilder = this.generateXML(stringArray);
        try {
            Class<?> clazz = CloneableEditorSupport.getEditorKit((String)"text/x-springconfig+xml").getClass();
            BaseDocument baseDocument = new BaseDocument(clazz, false);
            Formatter formatter = Formatter.getFormatter(clazz);
            baseDocument.remove(0, baseDocument.getLength());
            baseDocument.insertString(0, stringBuilder.toString(), null);
            formatter.reformatLock();
            try {
                baseDocument.atomicLock();
                try {
                    formatter.reformat(baseDocument, 0, baseDocument.getLength());
                }
                finally {
                    baseDocument.atomicUnlock();
                }
            }
            finally {
                formatter.reformatUnlock();
            }
            stringBuilder.replace(0, stringBuilder.length(), baseDocument.getText(0, baseDocument.getLength()));
            String string = stringBuilder.toString();
            FileLock fileLock = fileObject.lock();
            try {
                BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(fileObject.getOutputStream(fileLock)));
                bufferedWriter.write(string);
                bufferedWriter.close();
            }
            finally {
                fileLock.releaseLock();
            }
        }
        catch (FileAlreadyLockedException fileAlreadyLockedException) {
            Exceptions.printStackTrace((Throwable)fileAlreadyLockedException);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
    }

    private StringBuilder generateXML(String[] stringArray) {
        String string = System.getProperty("line.separator");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("       xsi:schemaLocation=\"http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans-2.5.xsd");
        StringBuilder stringBuilder2 = new StringBuilder();
        stringBuilder2.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>").append(string);
        stringBuilder2.append("<beans xmlns=\"http://www.springframework.org/schema/beans\"").append(string);
        stringBuilder2.append("       xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"").append(string);
        for (String string2 : stringArray) {
            String string3 = string2.substring(0, string2.indexOf("-")).trim();
            String string4 = string2.substring(string2.indexOf("-") + 1).trim();
            if (!string4.equals("http://www.springframework.org/schema/p")) {
                String string5 = string4.substring(0, string4.lastIndexOf("/"));
                stringBuilder2.append("       xmlns:").append(string3).append("=\"").append(string5).append("\"").append(string);
                stringBuilder.append(string);
                stringBuilder.append("       ").append(string5).append(" ").append(string4);
                continue;
            }
            stringBuilder2.append("       xmlns:").append(string3).append("=\"").append(string4).append("\"").append(string);
        }
        stringBuilder2.append((CharSequence)stringBuilder).append("\"");
        stringBuilder2.append(">").append(string).append("    ").append(string);
        stringBuilder2.append("</beans>");
        return stringBuilder2;
    }

    static ConfigFileManager getConfigFileManager(Project project) {
        ProjectSpringScopeProvider projectSpringScopeProvider = (ProjectSpringScopeProvider)project.getLookup().lookup(ProjectSpringScopeProvider.class);
        return projectSpringScopeProvider != null ? projectSpringScopeProvider.getSpringScope().getConfigFileManager() : null;
    }

    static FileObject getSourceGroupArtifact(Project project, FileObject fileObject) {
        SourceGroup[] sourceGroupArray;
        for (SourceGroup sourceGroup : sourceGroupArray = SourceGroups.getJavaSourceGroups((Project)project)) {
            FileObject fileObject2 = sourceGroup.getRootFolder();
            if (!fileObject.equals(fileObject2) && (!FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject) || !sourceGroup.contains(fileObject))) continue;
            return fileObject;
        }
        int n = 0;
        SourceGroup[] sourceGroupArray2 = sourceGroupArray;
        int n2 = sourceGroupArray2.length;
        if (n < n2) {
            SourceGroup sourceGroup;
            sourceGroup = sourceGroupArray2[n];
            return sourceGroup.getRootFolder();
        }
        return null;
    }
}

