/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.model;

import java.util.concurrent.Callable;
import java.util.concurrent.locks.ReentrantLock;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExclusiveAccess {
    private static final ExclusiveAccess INSTANCE = new ExclusiveAccess();
    private final RequestProcessor rp = new RequestProcessor("Spring config file access thread", 1, false);
    private final ReentrantLock lock = new ReentrantLock();

    public static ExclusiveAccess getInstance() {
        return INSTANCE;
    }

    public AsyncTask createAsyncTask(Runnable runnable) {
        return new AsyncTask(this.rp.create((Runnable)new TaskWrapper(runnable), true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> V runSyncTask(Callable<V> callable) throws Exception {
        this.lock.lock();
        try {
            V v = callable.call();
            return v;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isCurrentThreadAccess() {
        return this.lock.isHeldByCurrentThread();
    }

    private final class TaskWrapper
    implements Runnable {
        private final Runnable delegate;

        public TaskWrapper(Runnable runnable) {
            this.delegate = runnable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ExclusiveAccess.this.lock.lock();
            try {
                this.delegate.run();
            }
            finally {
                ExclusiveAccess.this.lock.unlock();
            }
        }
    }

    public static final class AsyncTask {
        private final RequestProcessor.Task task;

        AsyncTask(RequestProcessor.Task task) {
            this.task = task;
        }

        public void schedule(int n) {
            this.task.schedule(n);
        }

        public boolean cancel() {
            return this.task.cancel();
        }

        public boolean isFinished() {
            return this.task.isFinished();
        }
    }
}

